/*
 * Decompiled with CFR 0.152.
 */
package ml.denis3d.repack.net.dv8tion.jda.core.managers;

import javax.annotation.CheckReturnValue;
import ml.denis3d.repack.net.dv8tion.jda.core.AccountType;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.Icon;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.SelfUser;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.impl.JDAImpl;
import ml.denis3d.repack.net.dv8tion.jda.core.managers.impl.ManagerBase;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.Request;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.Response;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.Route;
import ml.denis3d.repack.net.dv8tion.jda.core.utils.Checks;
import ml.denis3d.repack.net.dv8tion.jda.core.utils.cache.UpstreamReference;
import ml.denis3d.repack.okhttp3.RequestBody;
import ml.denis3d.repack.org.json.JSONObject;

public class AccountManager
extends ManagerBase {
    public static final long NAME = 1L;
    public static final long AVATAR = 2L;
    public static final long EMAIL = 4L;
    public static final long PASSWORD = 8L;
    protected final UpstreamReference<SelfUser> selfUser;
    protected String currentPassword;
    protected String name;
    protected Icon avatar;
    protected String email;
    protected String password;

    public AccountManager(SelfUser selfUser) {
        super(selfUser.getJDA(), Route.Self.MODIFY_SELF.compile(new String[0]));
        this.selfUser = new UpstreamReference<SelfUser>(selfUser);
    }

    public SelfUser getSelfUser() {
        return this.selfUser.get();
    }

    @Override
    @CheckReturnValue
    public AccountManager reset(long fields) {
        super.reset(fields);
        if ((fields & 2L) == 2L) {
            this.avatar = null;
        }
        return this;
    }

    @Override
    @CheckReturnValue
    public AccountManager reset(long ... fields) {
        super.reset(fields);
        return this;
    }

    @Override
    @CheckReturnValue
    public AccountManager reset() {
        super.reset();
        this.avatar = null;
        return this;
    }

    @CheckReturnValue
    public AccountManager setName(String name) {
        return this.setName(name, null);
    }

    @CheckReturnValue
    public AccountManager setName(String name, String currentPassword) {
        Checks.notBlank(name, "Name");
        Checks.check(name.length() >= 2 && name.length() <= 32, "Name must be between 2-32 characters long");
        this.currentPassword = currentPassword;
        this.name = name;
        this.set |= 1L;
        return this;
    }

    @CheckReturnValue
    public AccountManager setAvatar(Icon avatar) {
        return this.setAvatar(avatar, null);
    }

    @CheckReturnValue
    public AccountManager setAvatar(Icon avatar, String currentPassword) {
        this.currentPassword = currentPassword;
        this.avatar = avatar;
        this.set |= 2L;
        return this;
    }

    @CheckReturnValue
    public AccountManager setEmail(String email, String currentPassword) {
        Checks.notNull(email, "email");
        this.currentPassword = currentPassword;
        this.email = email;
        this.set |= 4L;
        return this;
    }

    @CheckReturnValue
    public AccountManager setPassword(String newPassword, String currentPassword) {
        Checks.notNull(newPassword, "password");
        Checks.check(newPassword.length() >= 6 && newPassword.length() <= 128, "Password must be between 2-128 characters long");
        this.currentPassword = currentPassword;
        this.password = newPassword;
        this.set |= 8L;
        return this;
    }

    @Override
    protected RequestBody finalizeData() {
        boolean isClient = this.getJDA().getAccountType() == AccountType.CLIENT;
        Checks.check(!isClient || this.currentPassword != null && !this.currentPassword.isEmpty(), "Provided client account password to be used in auth is null or empty!");
        JSONObject body = new JSONObject();
        body.put("username", this.getSelfUser().getName());
        body.put("avatar", this.opt(this.getSelfUser().getAvatarId()));
        if (this.shouldUpdate(1L)) {
            body.put("username", this.name);
        }
        if (this.shouldUpdate(2L)) {
            body.put("avatar", this.avatar == null ? JSONObject.NULL : this.avatar.getEncoding());
        }
        if (isClient) {
            body.put("password", this.currentPassword);
            body.put("email", this.email);
            if (this.shouldUpdate(4L)) {
                body.put("email", this.email);
            }
            if (this.shouldUpdate(8L)) {
                body.put("new_password", this.password);
            }
        }
        this.reset();
        return this.getRequestBody(body);
    }

    @Override
    protected void handleResponse(Response response, Request<Void> request) {
        if (!response.isOk()) {
            request.onFailure(response);
            return;
        }
        String newToken = response.getObject().getString("token").replace("Bot ", "");
        ((JDAImpl)this.api.get()).setToken(newToken);
        request.onSuccess(null);
    }
}

