/*
 * Decompiled with CFR 0.152.
 */
package ml.denis3d.repack.net.dv8tion.jda.core.requests;

import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.zip.GZIPInputStream;
import ml.denis3d.repack.net.dv8tion.jda.core.AccountType;
import ml.denis3d.repack.net.dv8tion.jda.core.JDA;
import ml.denis3d.repack.net.dv8tion.jda.core.JDAInfo;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.impl.JDAImpl;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.RateLimiter;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.Request;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.Response;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.Route;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.ratelimit.BotRateLimiter;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.ratelimit.ClientRateLimiter;
import ml.denis3d.repack.net.dv8tion.jda.core.utils.JDALogger;
import ml.denis3d.repack.okhttp3.Call;
import ml.denis3d.repack.okhttp3.MediaType;
import ml.denis3d.repack.okhttp3.OkHttpClient;
import ml.denis3d.repack.okhttp3.Request;
import ml.denis3d.repack.okhttp3.RequestBody;
import ml.denis3d.repack.okhttp3.internal.http.HttpMethod;
import ml.denis3d.repack.org.slf4j.Logger;
import ml.denis3d.repack.org.slf4j.MDC;
import org.jetbrains.annotations.Async;

public class Requester {
    public static final Logger LOG = JDALogger.getLog(Requester.class);
    public static final String DISCORD_API_PREFIX = String.format("https://discordapp.com/api/v%d/", 6);
    public static final String USER_AGENT = "DiscordBot (https://github.com/DV8FromTheWorld/JDA, " + JDAInfo.VERSION + ")";
    public static final RequestBody EMPTY_BODY = RequestBody.create(null, new byte[0]);
    public static final MediaType MEDIA_TYPE_JSON = MediaType.parse("application/json; charset=utf-8");
    public static final MediaType MEDIA_TYPE_OCTET = MediaType.parse("application/octet-stream; charset=utf-8");
    protected final JDAImpl api;
    private final RateLimiter rateLimiter;
    private final OkHttpClient httpClient;
    private boolean isContextReady = false;
    private ConcurrentMap<String, String> contextMap = null;
    private volatile boolean retryOnTimeout = false;

    public Requester(JDA api) {
        this(api, api.getAccountType());
    }

    public Requester(JDA api, AccountType accountType) {
        if (accountType == null) {
            throw new NullPointerException("Provided accountType was null!");
        }
        this.api = (JDAImpl)api;
        this.rateLimiter = accountType == AccountType.BOT ? new BotRateLimiter(this) : new ClientRateLimiter(this);
        this.httpClient = this.api.getHttpClient();
    }

    public void setContextReady(boolean ready) {
        this.isContextReady = ready;
    }

    public void setContext() {
        if (!this.isContextReady) {
            return;
        }
        if (this.contextMap == null) {
            this.contextMap = this.api.getContextMap();
        }
        this.contextMap.forEach(MDC::put);
    }

    public JDAImpl getJDA() {
        return this.api;
    }

    public <T> void request(@Async.Schedule Request<T> apiRequest) {
        if (this.rateLimiter.isShutdown) {
            throw new IllegalStateException("The Requester has been shutdown! No new requests can be requested!");
        }
        if (apiRequest.shouldQueue()) {
            this.rateLimiter.queueRequest(apiRequest);
        } else {
            this.execute(apiRequest, true);
        }
    }

    public Long execute(Request<?> apiRequest) {
        return this.execute(apiRequest, false);
    }

    public Long execute(Request<?> apiRequest, boolean handleOnRateLimit) {
        return this.execute(apiRequest, false, handleOnRateLimit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long execute(@Async.Execute Request<?> apiRequest, boolean retried, boolean handleOnRatelimit) {
        Long l;
        Route.CompiledRoute route = apiRequest.getRoute();
        Long retryAfter = this.rateLimiter.getRateLimit(route);
        if (retryAfter != null) {
            if (handleOnRatelimit) {
                apiRequest.handleResponse(new Response(retryAfter, Collections.emptySet()));
            }
            return retryAfter;
        }
        Request.Builder builder = new Request.Builder();
        String url = DISCORD_API_PREFIX + route.getCompiledRoute();
        builder.url(url);
        String method = apiRequest.getRoute().getMethod().toString();
        RequestBody body = apiRequest.getBody();
        if (body == null && HttpMethod.requiresRequestBody(method)) {
            body = EMPTY_BODY;
        }
        builder.method(method, body).header("user-agent", USER_AGENT).header("accept-encoding", "gzip");
        if (url.startsWith(DISCORD_API_PREFIX) && this.api.getToken() != null) {
            builder.header("authorization", this.api.getToken());
        }
        if (apiRequest.getHeaders() != null) {
            for (Map.Entry header : apiRequest.getHeaders().entrySet()) {
                builder.addHeader((String)header.getKey(), (String)header.getValue());
            }
        }
        ml.denis3d.repack.okhttp3.Request request = builder.build();
        LinkedHashSet<String> rays = new LinkedHashSet<String>();
        ml.denis3d.repack.okhttp3.Response[] responses = new ml.denis3d.repack.okhttp3.Response[4];
        ml.denis3d.repack.okhttp3.Response lastResponse = null;
        try {
            int attempt = 0;
            do {
                Call call = this.httpClient.newCall(request);
                responses[attempt] = lastResponse = call.execute();
                String cfRay = lastResponse.header("CF-RAY");
                if (cfRay != null) {
                    rays.add(cfRay);
                }
                if (lastResponse.code() < 500) break;
                LOG.debug("Requesting {} -> {} returned status {}... retrying (attempt {})", new Object[]{apiRequest.getRoute().getMethod(), url, lastResponse.code(), ++attempt});
                try {
                    Thread.sleep(50 * attempt);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (attempt < 3 && lastResponse.code() >= 500);
            if (lastResponse.code() >= 500) {
                Response response = new Response(lastResponse, -1L, rays);
                apiRequest.handleResponse(response);
                ml.denis3d.repack.okhttp3.Response[] responseArray = null;
                return responseArray;
            }
            retryAfter = this.rateLimiter.handleResponse(route, lastResponse);
            if (!rays.isEmpty()) {
                LOG.debug("Received response with following cf-rays: {}", (Object)rays);
            }
            if (retryAfter == null) {
                apiRequest.handleResponse(new Response(lastResponse, -1L, rays));
            } else if (handleOnRatelimit) {
                apiRequest.handleResponse(new Response(lastResponse, retryAfter, rays));
            }
            l = retryAfter;
            return l;
        }
        catch (SocketTimeoutException e) {
            if (this.retryOnTimeout && !retried) {
                l = this.execute(apiRequest, true, handleOnRatelimit);
                return l;
            }
            LOG.error("Requester timed out while executing a request", e);
            apiRequest.handleResponse(new Response(lastResponse, e, rays));
            l = null;
            return l;
        }
        catch (Exception e) {
            LOG.error("There was an exception while executing a REST request", e);
            apiRequest.handleResponse(new Response(lastResponse, e, rays));
            l = null;
            return l;
        }
        finally {
            for (ml.denis3d.repack.okhttp3.Response r : responses) {
                if (r == null) break;
                r.close();
            }
        }
    }

    public OkHttpClient getHttpClient() {
        return this.httpClient;
    }

    public RateLimiter getRateLimiter() {
        return this.rateLimiter;
    }

    public void setRetryOnTimeout(boolean retryOnTimeout) {
        this.retryOnTimeout = retryOnTimeout;
    }

    public void shutdown() {
        this.rateLimiter.shutdown();
    }

    public static InputStream getBody(ml.denis3d.repack.okhttp3.Response response) throws IOException {
        String encoding = response.header("content-encoding", "");
        if (encoding.equals("gzip")) {
            return new GZIPInputStream(response.body().byteStream());
        }
        return response.body().byteStream();
    }
}

