/*
 * Decompiled with CFR 0.152.
 */
package ml.denis3d.repack.net.dv8tion.jda.core.requests;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.ref.SoftReference;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.InflaterOutputStream;
import ml.denis3d.repack.com.neovisionaries.ws.client.ThreadType;
import ml.denis3d.repack.com.neovisionaries.ws.client.WebSocket;
import ml.denis3d.repack.com.neovisionaries.ws.client.WebSocketAdapter;
import ml.denis3d.repack.com.neovisionaries.ws.client.WebSocketException;
import ml.denis3d.repack.com.neovisionaries.ws.client.WebSocketFrame;
import ml.denis3d.repack.com.neovisionaries.ws.client.WebSocketListener;
import ml.denis3d.repack.gnu.trove.iterator.TLongObjectIterator;
import ml.denis3d.repack.gnu.trove.map.TLongObjectMap;
import ml.denis3d.repack.net.dv8tion.jda.client.entities.impl.JDAClientImpl;
import ml.denis3d.repack.net.dv8tion.jda.client.handle.CallCreateHandler;
import ml.denis3d.repack.net.dv8tion.jda.client.handle.CallDeleteHandler;
import ml.denis3d.repack.net.dv8tion.jda.client.handle.CallUpdateHandler;
import ml.denis3d.repack.net.dv8tion.jda.client.handle.ChannelRecipientAddHandler;
import ml.denis3d.repack.net.dv8tion.jda.client.handle.ChannelRecipientRemoveHandler;
import ml.denis3d.repack.net.dv8tion.jda.client.handle.RelationshipAddHandler;
import ml.denis3d.repack.net.dv8tion.jda.client.handle.RelationshipRemoveHandler;
import ml.denis3d.repack.net.dv8tion.jda.core.AccountType;
import ml.denis3d.repack.net.dv8tion.jda.core.JDA;
import ml.denis3d.repack.net.dv8tion.jda.core.Permission;
import ml.denis3d.repack.net.dv8tion.jda.core.audio.ConnectionRequest;
import ml.denis3d.repack.net.dv8tion.jda.core.audio.ConnectionStage;
import ml.denis3d.repack.net.dv8tion.jda.core.audio.hooks.ConnectionListener;
import ml.denis3d.repack.net.dv8tion.jda.core.audio.hooks.ConnectionStatus;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.Channel;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.Guild;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.VoiceChannel;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.impl.GuildImpl;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.impl.JDAImpl;
import ml.denis3d.repack.net.dv8tion.jda.core.events.DisconnectEvent;
import ml.denis3d.repack.net.dv8tion.jda.core.events.ExceptionEvent;
import ml.denis3d.repack.net.dv8tion.jda.core.events.ReadyEvent;
import ml.denis3d.repack.net.dv8tion.jda.core.events.ReconnectedEvent;
import ml.denis3d.repack.net.dv8tion.jda.core.events.ResumedEvent;
import ml.denis3d.repack.net.dv8tion.jda.core.events.ShutdownEvent;
import ml.denis3d.repack.net.dv8tion.jda.core.handle.ChannelCreateHandler;
import ml.denis3d.repack.net.dv8tion.jda.core.handle.ChannelDeleteHandler;
import ml.denis3d.repack.net.dv8tion.jda.core.handle.ChannelUpdateHandler;
import ml.denis3d.repack.net.dv8tion.jda.core.handle.GuildBanHandler;
import ml.denis3d.repack.net.dv8tion.jda.core.handle.GuildCreateHandler;
import ml.denis3d.repack.net.dv8tion.jda.core.handle.GuildDeleteHandler;
import ml.denis3d.repack.net.dv8tion.jda.core.handle.GuildEmojisUpdateHandler;
import ml.denis3d.repack.net.dv8tion.jda.core.handle.GuildMemberAddHandler;
import ml.denis3d.repack.net.dv8tion.jda.core.handle.GuildMemberRemoveHandler;
import ml.denis3d.repack.net.dv8tion.jda.core.handle.GuildMemberUpdateHandler;
import ml.denis3d.repack.net.dv8tion.jda.core.handle.GuildMembersChunkHandler;
import ml.denis3d.repack.net.dv8tion.jda.core.handle.GuildRoleCreateHandler;
import ml.denis3d.repack.net.dv8tion.jda.core.handle.GuildRoleDeleteHandler;
import ml.denis3d.repack.net.dv8tion.jda.core.handle.GuildRoleUpdateHandler;
import ml.denis3d.repack.net.dv8tion.jda.core.handle.GuildSyncHandler;
import ml.denis3d.repack.net.dv8tion.jda.core.handle.GuildUpdateHandler;
import ml.denis3d.repack.net.dv8tion.jda.core.handle.MessageBulkDeleteHandler;
import ml.denis3d.repack.net.dv8tion.jda.core.handle.MessageCreateHandler;
import ml.denis3d.repack.net.dv8tion.jda.core.handle.MessageDeleteHandler;
import ml.denis3d.repack.net.dv8tion.jda.core.handle.MessageReactionBulkRemoveHandler;
import ml.denis3d.repack.net.dv8tion.jda.core.handle.MessageReactionHandler;
import ml.denis3d.repack.net.dv8tion.jda.core.handle.MessageUpdateHandler;
import ml.denis3d.repack.net.dv8tion.jda.core.handle.PresenceUpdateHandler;
import ml.denis3d.repack.net.dv8tion.jda.core.handle.ReadyHandler;
import ml.denis3d.repack.net.dv8tion.jda.core.handle.SocketHandler;
import ml.denis3d.repack.net.dv8tion.jda.core.handle.TypingStartHandler;
import ml.denis3d.repack.net.dv8tion.jda.core.handle.UserUpdateHandler;
import ml.denis3d.repack.net.dv8tion.jda.core.handle.VoiceServerUpdateHandler;
import ml.denis3d.repack.net.dv8tion.jda.core.handle.VoiceStateUpdateHandler;
import ml.denis3d.repack.net.dv8tion.jda.core.managers.AudioManager;
import ml.denis3d.repack.net.dv8tion.jda.core.managers.impl.AudioManagerImpl;
import ml.denis3d.repack.net.dv8tion.jda.core.managers.impl.PresenceImpl;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.CloseCode;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.WebSocketSendingThread;
import ml.denis3d.repack.net.dv8tion.jda.core.utils.JDALogger;
import ml.denis3d.repack.net.dv8tion.jda.core.utils.MiscUtil;
import ml.denis3d.repack.net.dv8tion.jda.core.utils.SessionController;
import ml.denis3d.repack.org.json.JSONArray;
import ml.denis3d.repack.org.json.JSONException;
import ml.denis3d.repack.org.json.JSONObject;
import ml.denis3d.repack.org.slf4j.Logger;
import ml.denis3d.repack.org.slf4j.MDC;

public class WebSocketClient
extends WebSocketAdapter
implements WebSocketListener {
    public static final Logger LOG = JDALogger.getLog(WebSocketClient.class);
    public static final int DISCORD_GATEWAY_VERSION = 6;
    public static final int IDENTIFY_DELAY = 5;
    public static final int ZLIB_SUFFIX = 65535;
    protected static final String INVALIDATE_REASON = "INVALIDATE_SESSION";
    protected static final long IDENTIFY_BACKOFF = TimeUnit.SECONDS.toMillis(5L);
    protected final JDAImpl api;
    protected final JDA.ShardInfo shardInfo;
    protected final Map<String, SocketHandler> handlers = new HashMap<String, SocketHandler>();
    protected final Set<String> cfRays = ConcurrentHashMap.newKeySet();
    protected final Set<String> traces = ConcurrentHashMap.newKeySet();
    protected final boolean compression;
    public WebSocket socket;
    protected String sessionId = null;
    protected final Object readLock = new Object();
    protected Inflater zlibContext = new Inflater();
    protected ByteArrayOutputStream readBuffer;
    protected SoftReference<ByteArrayOutputStream> decompressBuffer;
    protected final ReentrantLock queueLock = new ReentrantLock();
    protected final ScheduledExecutorService executor;
    protected WebSocketSendingThread ratelimitThread;
    protected volatile Future<?> keepAliveThread;
    protected boolean initiating;
    protected int reconnectTimeoutS = 2;
    protected long heartbeatStartTime;
    protected long identifyTime = 0L;
    protected final TLongObjectMap<ConnectionRequest> queuedAudioConnections = MiscUtil.newLongMap();
    protected final Queue<String> chunkSyncQueue = new ConcurrentLinkedQueue<String>();
    protected final Queue<String> ratelimitQueue = new ConcurrentLinkedQueue<String>();
    protected volatile long ratelimitResetTime;
    protected final AtomicInteger messagesSent = new AtomicInteger(0);
    protected volatile boolean shutdown = false;
    protected boolean shouldReconnect;
    protected boolean handleIdentifyRateLimit = false;
    protected boolean connected = false;
    protected volatile boolean printedRateLimitMessage = false;
    protected volatile boolean sentAuthInfo = false;
    protected boolean firstInit = true;
    protected boolean processingReady = true;
    protected volatile ConnectNode connectNode;

    public WebSocketClient(JDAImpl api, boolean compression) {
        this.api = api;
        this.executor = api.getGatewayPool();
        this.shardInfo = api.getShardInfo();
        this.compression = compression;
        this.shouldReconnect = api.isAutoReconnect();
        this.connectNode = new StartingNode();
        this.setupHandlers();
        try {
            api.getSessionController().appendSession(this.connectNode);
        }
        catch (Error | RuntimeException e) {
            LOG.error("Failed to append new session to session controller queue. Shutting down!", e);
            this.api.setStatus(JDA.Status.SHUTDOWN);
            this.api.getEventManager().handle(new ShutdownEvent(api, OffsetDateTime.now(), 1006));
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw (Error)e;
        }
    }

    public JDA getJDA() {
        return this.api;
    }

    public Set<String> getCfRays() {
        return this.cfRays;
    }

    public Set<String> getTraces() {
        return this.traces;
    }

    protected void updateTraces(JSONArray arr, String type, int opCode) {
        LOG.debug("Received a _trace for {} (OP: {}) with {}", type, opCode, arr);
        this.traces.clear();
        for (Object o : arr) {
            this.traces.add(String.valueOf(o));
        }
    }

    protected void allocateBuffer(byte[] binary) throws IOException {
        this.readBuffer = new ByteArrayOutputStream(binary.length * 2);
        this.readBuffer.write(binary);
    }

    protected void extendBuffer(byte[] binary) throws IOException {
        if (this.readBuffer != null) {
            this.readBuffer.write(binary);
        }
    }

    public void setAutoReconnect(boolean reconnect) {
        this.shouldReconnect = reconnect;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void ready() {
        if (this.initiating) {
            this.initiating = false;
            this.processingReady = false;
            if (this.firstInit) {
                this.firstInit = false;
                if (this.api.getGuilds().size() >= 2000) {
                    JDAImpl.LOG.warn(" __      __ _    ___  _  _  ___  _  _   ___  _ ");
                    JDAImpl.LOG.warn(" \\ \\    / //_\\  | _ \\| \\| ||_ _|| \\| | / __|| |");
                    JDAImpl.LOG.warn("  \\ \\/\\/ // _ \\ |   /| .` | | | | .` || (_ ||_|");
                    JDAImpl.LOG.warn("   \\_/\\_//_/ \\_\\|_|_\\|_|\\_||___||_|\\_| \\___|(_)");
                    JDAImpl.LOG.warn("You're running a session with over 2000 connected");
                    JDAImpl.LOG.warn("guilds. You should shard the connection in order");
                    JDAImpl.LOG.warn("to split the load or things like resuming");
                    JDAImpl.LOG.warn("connection might not work as expected.");
                    JDAImpl.LOG.warn("For more info see https://git.io/vrFWP");
                }
                JDAImpl.LOG.info("Finished Loading!");
                this.api.getEventManager().handle(new ReadyEvent(this.api, this.api.getResponseTotal()));
            } else {
                this.updateAudioManagerReferences();
                JDAImpl.LOG.info("Finished (Re)Loading!");
                this.api.getEventManager().handle(new ReconnectedEvent(this.api, this.api.getResponseTotal()));
            }
        } else {
            JDAImpl.LOG.info("Successfully resumed Session!");
            this.api.getEventManager().handle(new ResumedEvent(this.api, this.api.getResponseTotal()));
        }
        this.api.setStatus(JDA.Status.CONNECTED);
    }

    public boolean isReady() {
        return !this.initiating;
    }

    public void handle(List<JSONObject> events) {
        events.forEach(this::onDispatch);
    }

    public void send(String message) {
        this.locked("Interrupted while trying to add request to queue", () -> this.ratelimitQueue.add(message));
    }

    public void chunkOrSyncRequest(JSONObject request) {
        this.locked("Interrupted while trying to add chunk request", () -> this.chunkSyncQueue.add(request.toString()));
    }

    protected boolean send(String message, boolean skipQueue) {
        if (!this.connected) {
            return false;
        }
        long now = System.currentTimeMillis();
        if (this.ratelimitResetTime <= now) {
            this.messagesSent.set(0);
            this.ratelimitResetTime = now + 60000L;
            this.printedRateLimitMessage = false;
        }
        if (this.messagesSent.get() <= 115 || skipQueue && this.messagesSent.get() <= 119) {
            LOG.trace("<- {}", (Object)message);
            this.socket.sendText(message);
            this.messagesSent.getAndIncrement();
            return true;
        }
        if (!this.printedRateLimitMessage) {
            LOG.warn("Hit the WebSocket RateLimit! This can be caused by too many presence or voice status updates (connect/disconnect/mute/deaf). Regular: {} Voice: {} Chunking: {}", this.ratelimitQueue.size(), this.queuedAudioConnections.size(), this.chunkSyncQueue.size());
            this.printedRateLimitMessage = true;
        }
        return false;
    }

    protected void setupSendingThread() {
        this.ratelimitThread = new WebSocketSendingThread(this);
        this.ratelimitThread.start();
    }

    public void close() {
        if (this.socket != null) {
            this.socket.sendClose(1000);
        }
    }

    public void close(int code) {
        if (this.socket != null) {
            this.socket.sendClose(code);
        }
    }

    public void close(int code, String reason) {
        if (this.socket != null) {
            this.socket.sendClose(code, reason);
        }
    }

    public synchronized void shutdown() {
        this.shutdown = true;
        this.shouldReconnect = false;
        if (this.connectNode != null) {
            this.api.getSessionController().removeSession(this.connectNode);
        }
        this.close(1000, "Shutting down");
    }

    protected synchronized void connect() {
        if (this.api.getStatus() != JDA.Status.ATTEMPTING_TO_RECONNECT) {
            this.api.setStatus(JDA.Status.CONNECTING_TO_WEBSOCKET);
        }
        if (this.shutdown) {
            throw new RejectedExecutionException("JDA is shutdown!");
        }
        this.initiating = true;
        String url = this.api.getGatewayUrl() + "?encoding=json&v=" + 6;
        if (this.compression) {
            url = url + "&compress=zlib-stream";
            this.decompressBuffer = this.newDecompressBuffer();
        }
        try {
            this.socket = this.api.getWebSocketFactory().createSocket(url).addHeader("Accept-Encoding", "gzip").addListener(this);
            this.socket.connect();
        }
        catch (IOException | WebSocketException e) {
            this.api.resetGatewayUrl();
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void onThreadStarted(WebSocket websocket, ThreadType threadType, Thread thread) throws Exception {
        this.api.setContext();
    }

    @Override
    public void onConnected(WebSocket websocket, Map<String, List<String>> headers) {
        List<String> values;
        this.api.setStatus(JDA.Status.IDENTIFYING_SESSION);
        if (this.sessionId == null) {
            LOG.info("Connected to WebSocket");
        } else {
            LOG.debug("Connected to WebSocket");
        }
        if (headers.containsKey("cf-ray") && !(values = headers.get("cf-ray")).isEmpty()) {
            String ray = values.get(0);
            this.cfRays.add(ray);
            LOG.trace("Received new CF-RAY: {}", (Object)ray);
        }
        this.connected = true;
        this.reconnectTimeoutS = 2;
        this.messagesSent.set(0);
        this.ratelimitResetTime = System.currentTimeMillis() + 60000L;
        if (this.sessionId == null) {
            this.sendIdentify();
        } else {
            this.sendResume();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDisconnected(WebSocket websocket, WebSocketFrame serverCloseFrame, WebSocketFrame clientCloseFrame, boolean closedByServer) {
        boolean closeCodeIsReconnect;
        this.sentAuthInfo = false;
        this.connected = false;
        this.api.setStatus(JDA.Status.DISCONNECTED);
        CloseCode closeCode = null;
        int rawCloseCode = 1000;
        boolean isInvalidate = false;
        if (this.keepAliveThread != null) {
            this.keepAliveThread.cancel(false);
            this.keepAliveThread = null;
        }
        if (serverCloseFrame != null) {
            rawCloseCode = serverCloseFrame.getCloseCode();
            closeCode = CloseCode.from(rawCloseCode);
            if (closeCode == CloseCode.RATE_LIMITED) {
                LOG.error("WebSocket connection closed due to ratelimit! Sent more than 120 websocket messages in under 60 seconds!");
            } else if (closeCode != null) {
                LOG.debug("WebSocket connection closed with code {}", (Object)closeCode);
            } else {
                LOG.warn("WebSocket connection closed with unknown meaning for close-code {}", (Object)rawCloseCode);
            }
        }
        if (clientCloseFrame != null && clientCloseFrame.getCloseCode() == 1000 && Objects.equals(clientCloseFrame.getCloseReason(), INVALIDATE_REASON)) {
            isInvalidate = true;
        }
        boolean bl = closeCodeIsReconnect = closeCode == null || closeCode.isReconnect();
        if (!this.shouldReconnect || !closeCodeIsReconnect || this.executor.isShutdown()) {
            if (this.ratelimitThread != null) {
                this.ratelimitThread.shutdown();
                this.ratelimitThread = null;
            }
            if (!closeCodeIsReconnect) {
                LOG.error("WebSocket connection was closed and cannot be recovered due to identification issues\n{}", (Object)closeCode);
            }
            this.api.shutdownInternals();
            this.api.getEventManager().handle(new ShutdownEvent(this.api, OffsetDateTime.now(), rawCloseCode));
        } else {
            Object object = this.readLock;
            synchronized (object) {
                this.zlibContext = new Inflater();
                if (this.decompressBuffer != null) {
                    this.decompressBuffer.clear();
                }
                this.readBuffer = null;
            }
            if (isInvalidate) {
                this.invalidate();
            }
            this.api.getEventManager().handle(new DisconnectEvent(this.api, serverCloseFrame, clientCloseFrame, closedByServer, OffsetDateTime.now()));
            try {
                this.handleReconnect();
            }
            catch (InterruptedException e) {
                LOG.error("Failed to resume due to interrupted thread", e);
                this.invalidate();
                this.queueReconnect();
            }
        }
    }

    private void handleReconnect() throws InterruptedException {
        if (this.sessionId == null) {
            if (this.handleIdentifyRateLimit) {
                long backoff = this.calculateIdentifyBackoff();
                if (backoff > 0L) {
                    LOG.error("Encountered IDENTIFY Rate Limit! Waiting {} milliseconds before trying again!", (Object)backoff);
                    Thread.sleep(backoff);
                } else {
                    LOG.error("Encountered IDENTIFY Rate Limit!");
                }
            }
            LOG.warn("Got disconnected from WebSocket. Appending to reconnect queue");
            this.queueReconnect();
        } else {
            LOG.warn("Got disconnected from WebSocket. Attempting to resume session");
            this.reconnect();
        }
    }

    protected long calculateIdentifyBackoff() {
        long currentTime = System.currentTimeMillis();
        return currentTime - (this.identifyTime + IDENTIFY_BACKOFF);
    }

    protected void queueReconnect() {
        try {
            this.api.setStatus(JDA.Status.RECONNECT_QUEUED);
            this.connectNode = new ReconnectNode();
            this.api.getSessionController().appendSession(this.connectNode);
        }
        catch (IllegalStateException ex) {
            LOG.error("Reconnect queue rejected session. Shutting down...");
            this.api.setStatus(JDA.Status.SHUTDOWN);
            this.api.getEventManager().handle(new ShutdownEvent(this.api, OffsetDateTime.now(), 1006));
        }
    }

    protected void reconnect() throws InterruptedException {
        this.reconnect(false);
    }

    public void reconnect(boolean callFromQueue) throws InterruptedException {
        Set<MDC.MDCCloseable> contextEntries = null;
        Map<String, String> previousContext = null;
        ConcurrentMap<String, String> contextMap = this.api.getContextMap();
        if (callFromQueue && contextMap != null) {
            previousContext = MDC.getCopyOfContextMap();
            contextEntries = contextMap.entrySet().stream().map(entry -> MDC.putCloseable((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toSet());
        }
        if (this.shutdown) {
            this.api.setStatus(JDA.Status.SHUTDOWN);
            this.api.getEventManager().handle(new ShutdownEvent(this.api, OffsetDateTime.now(), 1000));
            return;
        }
        String message = "";
        if (callFromQueue) {
            message = String.format("Queue is attempting to reconnect a shard...%s ", this.shardInfo != null ? " Shard: " + this.shardInfo.getShardString() : "");
        }
        LOG.debug("{}Attempting to reconnect in {}s", (Object)message, (Object)this.reconnectTimeoutS);
        while (this.shouldReconnect) {
            this.api.setStatus(JDA.Status.WAITING_TO_RECONNECT);
            int delay = this.reconnectTimeoutS;
            Thread.sleep(delay * 1000);
            this.handleIdentifyRateLimit = false;
            this.api.setStatus(JDA.Status.ATTEMPTING_TO_RECONNECT);
            LOG.debug("Attempting to reconnect!");
            try {
                this.connect();
                break;
            }
            catch (RejectedExecutionException ex) {
                this.api.setStatus(JDA.Status.SHUTDOWN);
                this.api.getEventManager().handle(new ShutdownEvent(this.api, OffsetDateTime.now(), 1000));
                return;
            }
            catch (RuntimeException ex) {
                this.reconnectTimeoutS = Math.min(this.reconnectTimeoutS << 1, this.api.getMaxReconnectDelay());
                LOG.warn("Reconnect failed! Next attempt in {}s", (Object)this.reconnectTimeoutS);
            }
        }
        if (contextEntries != null) {
            contextEntries.forEach(MDC.MDCCloseable::close);
        }
        if (previousContext != null) {
            previousContext.forEach(MDC::put);
        }
    }

    protected void setupKeepAlive(long timeout) {
        this.keepAliveThread = this.executor.scheduleAtFixedRate(() -> {
            this.api.setContext();
            if (this.connected) {
                this.sendKeepAlive();
            }
        }, 0L, timeout, TimeUnit.MILLISECONDS);
    }

    protected void sendKeepAlive() {
        String keepAlivePacket = new JSONObject().put("op", 1).put("d", this.api.getResponseTotal()).toString();
        this.send(keepAlivePacket, true);
        this.heartbeatStartTime = System.currentTimeMillis();
    }

    protected void sendIdentify() {
        LOG.debug("Sending Identify-packet...");
        PresenceImpl presenceObj = (PresenceImpl)this.api.getPresence();
        JSONObject connectionProperties = new JSONObject().put("$os", System.getProperty("os.name")).put("$browser", "JDA").put("$device", "JDA").put("$referring_domain", "").put("$referrer", "");
        JSONObject payload = new JSONObject().put("presence", presenceObj.getFullPresence()).put("token", this.getToken()).put("properties", connectionProperties).put("v", 6).put("large_threshold", 250);
        JSONObject identify = new JSONObject().put("op", 2).put("d", payload);
        if (this.shardInfo != null) {
            payload.put("shard", new JSONArray().put(this.shardInfo.getShardId()).put(this.shardInfo.getShardTotal()));
        }
        this.send(identify.toString(), true);
        this.handleIdentifyRateLimit = true;
        this.identifyTime = System.currentTimeMillis();
        this.sentAuthInfo = true;
        this.api.setStatus(JDA.Status.AWAITING_LOGIN_CONFIRMATION);
    }

    protected void sendResume() {
        LOG.debug("Sending Resume-packet...");
        JSONObject resume = new JSONObject().put("op", 6).put("d", new JSONObject().put("session_id", this.sessionId).put("token", this.getToken()).put("seq", this.api.getResponseTotal()));
        this.send(resume.toString(), true);
        this.api.setStatus(JDA.Status.AWAITING_LOGIN_CONFIRMATION);
    }

    protected void invalidate() {
        this.sessionId = null;
        this.sentAuthInfo = false;
        this.locked("Interrupted while trying to invalidate chunk/sync queue", this.chunkSyncQueue::clear);
        this.api.getTextChannelMap().clear();
        this.api.getVoiceChannelMap().clear();
        this.api.getCategoryMap().clear();
        this.api.getGuildMap().clear();
        this.api.getUserMap().clear();
        this.api.getPrivateChannelMap().clear();
        this.api.getFakeUserMap().clear();
        this.api.getFakePrivateChannelMap().clear();
        this.api.getEventCache().clear();
        this.api.getGuildSetupController().clearCache();
        if (this.api.getAccountType() == AccountType.CLIENT) {
            JDAClientImpl client = this.api.asClient();
            client.getRelationshipMap().clear();
            client.getGroupMap().clear();
            client.getCallUserMap().clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateAudioManagerReferences() {
        TLongObjectMap<AudioManager> managerMap = this.api.getAudioManagerMap();
        if (managerMap.size() > 0) {
            LOG.trace("Updating AudioManager references");
        }
        TLongObjectMap<AudioManager> tLongObjectMap = managerMap;
        synchronized (tLongObjectMap) {
            TLongObjectIterator<AudioManager> it = managerMap.iterator();
            while (it.hasNext()) {
                it.advance();
                long guildId = it.key();
                AudioManagerImpl mng = (AudioManagerImpl)it.value();
                GuildImpl guild = (GuildImpl)this.api.getGuildById(guildId);
                if (guild != null) continue;
                this.queuedAudioConnections.remove(guildId);
                mng.closeAudioConnection(ConnectionStatus.DISCONNECTED_REMOVED_DURING_RECONNECT);
                it.remove();
            }
        }
    }

    protected String getToken() {
        if (this.api.getAccountType() == AccountType.BOT) {
            return this.api.getToken().substring("Bot ".length());
        }
        return this.api.getToken();
    }

    protected List<JSONObject> convertPresencesReplace(long responseTotal, JSONArray array) {
        LinkedList<JSONObject> output = new LinkedList<JSONObject>();
        for (int i = 0; i < array.length(); ++i) {
            JSONObject presence = array.getJSONObject(i);
            JSONObject obj = new JSONObject();
            obj.put("jda-field", "This was constructed from a PRESENCES_REPLACE payload").put("op", 0).put("s", responseTotal).put("d", presence).put("t", "PRESENCE_UPDATE");
            output.add(obj);
        }
        return output;
    }

    protected void handleEvent(JSONObject content) {
        try {
            this.onEvent(content);
        }
        catch (Exception ex) {
            LOG.error("Encountered exception on lifecycle level\nJSON: {}", (Object)content, (Object)ex);
            this.api.getEventManager().handle(new ExceptionEvent(this.api, ex, true));
        }
    }

    protected void onEvent(JSONObject content) {
        int opCode = content.getInt("op");
        if (!content.isNull("s")) {
            this.api.setResponseTotal(content.getInt("s"));
        }
        switch (opCode) {
            case 0: {
                this.onDispatch(content);
                break;
            }
            case 1: {
                LOG.debug("Got Keep-Alive request (OP 1). Sending response...");
                this.sendKeepAlive();
                break;
            }
            case 7: {
                LOG.debug("Got Reconnect request (OP 7). Closing connection now...");
                this.close(4000, "OP 7: RECONNECT");
                break;
            }
            case 9: {
                int closeCode;
                LOG.debug("Got Invalidate request (OP 9). Invalidating...");
                this.handleIdentifyRateLimit = this.handleIdentifyRateLimit && System.currentTimeMillis() - this.identifyTime < IDENTIFY_BACKOFF;
                this.sentAuthInfo = false;
                boolean isResume = content.getBoolean("d");
                int n = closeCode = isResume ? 4000 : 1000;
                if (isResume) {
                    LOG.debug("Session can be recovered... Closing and sending new RESUME request");
                } else {
                    this.invalidate();
                }
                this.close(closeCode, INVALIDATE_REASON);
                break;
            }
            case 10: {
                LOG.debug("Got HELLO packet (OP 10). Initializing keep-alive.");
                JSONObject data = content.getJSONObject("d");
                this.setupKeepAlive(data.getLong("heartbeat_interval"));
                if (data.isNull("_trace")) break;
                this.updateTraces(data.getJSONArray("_trace"), "HELLO", 10);
                break;
            }
            case 11: {
                LOG.trace("Got Heartbeat Ack (OP 11).");
                this.api.setPing(System.currentTimeMillis() - this.heartbeatStartTime);
                break;
            }
            default: {
                LOG.debug("Got unknown op-code: {} with content: {}", (Object)opCode, (Object)content);
            }
        }
    }

    protected void onDispatch(JSONObject raw) {
        String type = raw.getString("t");
        long responseTotal = this.api.getResponseTotal();
        if (!(raw.opt("d") instanceof JSONObject)) {
            if (type.equals("PRESENCES_REPLACE")) {
                JSONArray payload = raw.getJSONArray("d");
                List<JSONObject> converted = this.convertPresencesReplace(responseTotal, payload);
                PresenceUpdateHandler handler = (PresenceUpdateHandler)this.getHandler("PRESENCE_UPDATE");
                LOG.trace("{} -> {}", (Object)type, (Object)payload);
                for (JSONObject o : converted) {
                    handler.handle(responseTotal, o);
                }
            } else {
                LOG.debug("Received event with unhandled body type JSON: {}", (Object)raw);
            }
            return;
        }
        JSONObject content = raw.getJSONObject("d");
        LOG.trace("{} -> {}", (Object)type, (Object)content);
        JDAImpl jda = (JDAImpl)this.getJDA();
        try {
            switch (type) {
                case "READY": {
                    this.api.setStatus(JDA.Status.LOADING_SUBSYSTEMS);
                    this.processingReady = true;
                    this.handleIdentifyRateLimit = false;
                    this.sessionId = content.getString("session_id");
                    if (!content.isNull("_trace")) {
                        this.updateTraces(content.getJSONArray("_trace"), "READY", 0);
                    }
                    this.handlers.get("READY").handle(responseTotal, raw);
                    break;
                }
                case "RESUMED": {
                    this.sentAuthInfo = true;
                    if (!this.processingReady) {
                        this.initiating = false;
                        this.ready();
                    } else {
                        LOG.debug("Resumed while still processing initial ready");
                        jda.setStatus(JDA.Status.LOADING_SUBSYSTEMS);
                    }
                    if (!content.isNull("_trace")) {
                        this.updateTraces(content.getJSONArray("_trace"), "RESUMED", 0);
                    }
                    break;
                }
                default: {
                    SocketHandler handler = this.handlers.get(type);
                    if (handler != null) {
                        handler.handle(responseTotal, raw);
                        break;
                    }
                    LOG.debug("Unrecognized event:\n{}", (Object)raw);
                    break;
                }
            }
        }
        catch (JSONException ex) {
            LOG.warn("Got an unexpected Json-parse error. Please redirect following message to the devs:\n\t{}\n\t{} -> {}", ex.getMessage(), type, content, ex);
        }
        catch (Exception ex) {
            LOG.error("Got an unexpected error. Please redirect following message to the devs:\n\t{} -> {}", type, content, ex);
        }
        if (responseTotal % 100L == 0L) {
            jda.getEventCache().timeout(responseTotal);
        }
    }

    @Override
    public void onTextMessage(WebSocket websocket, String message) {
        this.handleEvent(new JSONObject(message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onBinaryMessage(WebSocket websocket, byte[] binary) throws IOException, DataFormatException {
        JSONObject json;
        Object object = this.readLock;
        synchronized (object) {
            if (!this.onBufferMessage(binary)) {
                return;
            }
            json = this.handleBinary(binary);
        }
        this.handleEvent(json);
    }

    protected boolean onBufferMessage(byte[] binary) throws IOException {
        if (binary.length >= 4 && WebSocketClient.getInt(binary, binary.length - 4) == 65535) {
            this.extendBuffer(binary);
            return true;
        }
        if (this.readBuffer != null) {
            this.extendBuffer(binary);
        } else {
            this.allocateBuffer(binary);
        }
        return false;
    }

    protected JSONObject handleBinary(byte[] binary) throws DataFormatException, UnsupportedEncodingException {
        ByteArrayOutputStream decompressBuffer = this.getDecompressBuffer();
        try (InflaterOutputStream decompressor = new InflaterOutputStream(decompressBuffer, this.zlibContext);){
            if (this.readBuffer != null) {
                this.readBuffer.writeTo(decompressor);
            } else {
                decompressor.write(binary);
            }
        }
        catch (IOException e) {
            decompressBuffer.reset();
            this.close(4000, "MALFORMED_PACKAGE");
            throw (DataFormatException)new DataFormatException("Malformed").initCause(e);
        }
        finally {
            this.readBuffer = null;
        }
        String jsonString = decompressBuffer.toString("UTF-8");
        decompressBuffer.reset();
        return new JSONObject(jsonString);
    }

    protected ByteArrayOutputStream getDecompressBuffer() {
        ByteArrayOutputStream buffer;
        if (this.decompressBuffer == null) {
            this.decompressBuffer = this.newDecompressBuffer();
        }
        if ((buffer = this.decompressBuffer.get()) == null) {
            buffer = new ByteArrayOutputStream(1024);
            this.decompressBuffer = new SoftReference<ByteArrayOutputStream>(buffer);
        }
        return buffer;
    }

    protected static int getInt(byte[] sink, int offset) {
        return sink[offset + 3] & 0xFF | (sink[offset + 2] & 0xFF) << 8 | (sink[offset + 1] & 0xFF) << 16 | (sink[offset] & 0xFF) << 24;
    }

    @Override
    public void onUnexpectedError(WebSocket websocket, WebSocketException cause) throws Exception {
        this.handleCallbackError(websocket, cause);
    }

    @Override
    public void handleCallbackError(WebSocket websocket, Throwable cause) {
        LOG.error("There was an error in the WebSocket connection", cause);
        this.api.getEventManager().handle(new ExceptionEvent(this.api, cause, true));
    }

    @Override
    public void onThreadCreated(WebSocket websocket, ThreadType threadType, Thread thread) throws Exception {
        String identifier = this.api.getIdentifierString();
        switch (threadType) {
            case CONNECT_THREAD: {
                thread.setName(identifier + " MainWS-ConnectThread");
                break;
            }
            case FINISH_THREAD: {
                thread.setName(identifier + " MainWS-FinishThread");
                break;
            }
            case READING_THREAD: {
                thread.setName(identifier + " MainWS-ReadThread");
                break;
            }
            case WRITING_THREAD: {
                thread.setName(identifier + " MainWS-WriteThread");
                break;
            }
            default: {
                thread.setName(identifier + " MainWS-" + (Object)((Object)threadType));
            }
        }
    }

    protected void maybeUnlock() {
        if (this.queueLock.isHeldByCurrentThread()) {
            this.queueLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void locked(String comment, Runnable task) {
        try {
            this.queueLock.lockInterruptibly();
            task.run();
        }
        catch (InterruptedException e) {
            LOG.error(comment, e);
        }
        finally {
            this.maybeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T locked(String comment, Supplier<T> task) {
        try {
            this.queueLock.lockInterruptibly();
            T t = task.get();
            return t;
        }
        catch (InterruptedException e) {
            LOG.error(comment, e);
            T t = null;
            return t;
        }
        finally {
            this.maybeUnlock();
        }
    }

    public void queueAudioReconnect(VoiceChannel channel) {
        this.locked("There was an error queueing the audio reconnect", () -> {
            long guildId = channel.getGuild().getIdLong();
            ConnectionRequest request = this.queuedAudioConnections.get(guildId);
            if (request == null) {
                request = new ConnectionRequest(channel, ConnectionStage.RECONNECT);
                this.queuedAudioConnections.put(guildId, request);
            } else {
                request.setStage(ConnectionStage.RECONNECT);
            }
            request.setChannel(channel);
        });
    }

    public void queueAudioConnect(VoiceChannel channel) {
        this.locked("There was an error queueing the audio connect", () -> {
            long guildId = channel.getGuild().getIdLong();
            ConnectionRequest request = this.queuedAudioConnections.get(guildId);
            if (request == null) {
                request = new ConnectionRequest(channel, ConnectionStage.CONNECT);
                this.queuedAudioConnections.put(guildId, request);
            } else if (request.getStage() == ConnectionStage.DISCONNECT) {
                request.setStage(ConnectionStage.RECONNECT);
            }
            request.setChannel(channel);
        });
    }

    public void queueAudioDisconnect(Guild guild) {
        this.locked("There was an error queueing the audio disconnect", () -> {
            long guildId = guild.getIdLong();
            ConnectionRequest request = this.queuedAudioConnections.get(guildId);
            if (request == null) {
                this.queuedAudioConnections.put(guildId, new ConnectionRequest(guild));
            } else {
                request.setStage(ConnectionStage.DISCONNECT);
            }
        });
    }

    public ConnectionRequest removeAudioConnection(long guildId) {
        return this.locked("There was an error cleaning up audio connections for deleted guild", () -> this.queuedAudioConnections.remove(guildId));
    }

    public ConnectionRequest updateAudioConnection(long guildId, VoiceChannel connectedChannel) {
        return this.locked("There was an error updating the audio connection", () -> this.updateAudioConnection0(guildId, connectedChannel));
    }

    public ConnectionRequest updateAudioConnection0(long guildId, VoiceChannel connectedChannel) {
        ConnectionRequest request = this.queuedAudioConnections.get(guildId);
        if (request == null) {
            return null;
        }
        ConnectionStage requestStage = request.getStage();
        if (connectedChannel == null) {
            switch (requestStage) {
                case DISCONNECT: {
                    return this.queuedAudioConnections.remove(guildId);
                }
                case RECONNECT: {
                    request.setStage(ConnectionStage.CONNECT);
                    request.setNextAttemptEpoch(System.currentTimeMillis());
                }
            }
            return null;
        }
        if (requestStage == ConnectionStage.CONNECT && request.getChannelId() == connectedChannel.getIdLong()) {
            return this.queuedAudioConnections.remove(guildId);
        }
        return null;
    }

    private SoftReference<ByteArrayOutputStream> newDecompressBuffer() {
        return new SoftReference<ByteArrayOutputStream>(new ByteArrayOutputStream(1024));
    }

    protected ConnectionRequest getNextAudioConnectRequest() {
        if (!this.isReady()) {
            return null;
        }
        long now = System.currentTimeMillis();
        TLongObjectIterator<ConnectionRequest> it = this.queuedAudioConnections.iterator();
        while (it.hasNext()) {
            it.advance();
            ConnectionRequest audioRequest = it.value();
            if (audioRequest.getNextAttemptEpoch() >= now) continue;
            Guild guild = this.api.getGuildById(audioRequest.getGuildIdLong());
            if (guild == null) {
                it.remove();
                continue;
            }
            ConnectionListener listener = guild.getAudioManager().getConnectionListener();
            if (audioRequest.getStage() != ConnectionStage.DISCONNECT) {
                VoiceChannel channel = guild.getVoiceChannelById(audioRequest.getChannelId());
                if (channel == null) {
                    it.remove();
                    if (listener == null) continue;
                    listener.onStatusChange(ConnectionStatus.DISCONNECTED_CHANNEL_DELETED);
                    continue;
                }
                if (!guild.getSelfMember().hasPermission((Channel)channel, Permission.VOICE_CONNECT)) {
                    it.remove();
                    if (listener == null) continue;
                    listener.onStatusChange(ConnectionStatus.DISCONNECTED_LOST_PERMISSION);
                    continue;
                }
            }
            return audioRequest;
        }
        return null;
    }

    public Map<String, SocketHandler> getHandlers() {
        return this.handlers;
    }

    public <T extends SocketHandler> T getHandler(String type) {
        try {
            return (T)this.handlers.get(type);
        }
        catch (ClassCastException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void setupHandlers() {
        SocketHandler.NOPHandler nopHandler = new SocketHandler.NOPHandler(this.api);
        this.handlers.put("CHANNEL_CREATE", new ChannelCreateHandler(this.api));
        this.handlers.put("CHANNEL_DELETE", new ChannelDeleteHandler(this.api));
        this.handlers.put("CHANNEL_UPDATE", new ChannelUpdateHandler(this.api));
        this.handlers.put("GUILD_BAN_ADD", new GuildBanHandler(this.api, true));
        this.handlers.put("GUILD_BAN_REMOVE", new GuildBanHandler(this.api, false));
        this.handlers.put("GUILD_CREATE", new GuildCreateHandler(this.api));
        this.handlers.put("GUILD_DELETE", new GuildDeleteHandler(this.api));
        this.handlers.put("GUILD_EMOJIS_UPDATE", new GuildEmojisUpdateHandler(this.api));
        this.handlers.put("GUILD_MEMBER_ADD", new GuildMemberAddHandler(this.api));
        this.handlers.put("GUILD_MEMBER_REMOVE", new GuildMemberRemoveHandler(this.api));
        this.handlers.put("GUILD_MEMBER_UPDATE", new GuildMemberUpdateHandler(this.api));
        this.handlers.put("GUILD_MEMBERS_CHUNK", new GuildMembersChunkHandler(this.api));
        this.handlers.put("GUILD_ROLE_CREATE", new GuildRoleCreateHandler(this.api));
        this.handlers.put("GUILD_ROLE_DELETE", new GuildRoleDeleteHandler(this.api));
        this.handlers.put("GUILD_ROLE_UPDATE", new GuildRoleUpdateHandler(this.api));
        this.handlers.put("GUILD_SYNC", new GuildSyncHandler(this.api));
        this.handlers.put("GUILD_UPDATE", new GuildUpdateHandler(this.api));
        this.handlers.put("MESSAGE_CREATE", new MessageCreateHandler(this.api));
        this.handlers.put("MESSAGE_DELETE", new MessageDeleteHandler(this.api));
        this.handlers.put("MESSAGE_DELETE_BULK", new MessageBulkDeleteHandler(this.api));
        this.handlers.put("MESSAGE_REACTION_ADD", new MessageReactionHandler(this.api, true));
        this.handlers.put("MESSAGE_REACTION_REMOVE", new MessageReactionHandler(this.api, false));
        this.handlers.put("MESSAGE_REACTION_REMOVE_ALL", new MessageReactionBulkRemoveHandler(this.api));
        this.handlers.put("MESSAGE_UPDATE", new MessageUpdateHandler(this.api));
        this.handlers.put("PRESENCE_UPDATE", new PresenceUpdateHandler(this.api));
        this.handlers.put("READY", new ReadyHandler(this.api));
        this.handlers.put("TYPING_START", new TypingStartHandler(this.api));
        this.handlers.put("USER_UPDATE", new UserUpdateHandler(this.api));
        this.handlers.put("VOICE_SERVER_UPDATE", new VoiceServerUpdateHandler(this.api));
        this.handlers.put("VOICE_STATE_UPDATE", new VoiceStateUpdateHandler(this.api));
        this.handlers.put("CHANNEL_PINS_ACK", nopHandler);
        this.handlers.put("CHANNEL_PINS_UPDATE", nopHandler);
        this.handlers.put("GUILD_INTEGRATIONS_UPDATE", nopHandler);
        this.handlers.put("PRESENCES_REPLACE", nopHandler);
        this.handlers.put("WEBHOOKS_UPDATE", nopHandler);
        if (this.api.getAccountType() == AccountType.CLIENT) {
            this.handlers.put("CALL_CREATE", new CallCreateHandler(this.api));
            this.handlers.put("CALL_DELETE", new CallDeleteHandler(this.api));
            this.handlers.put("CALL_UPDATE", new CallUpdateHandler(this.api));
            this.handlers.put("CHANNEL_RECIPIENT_ADD", new ChannelRecipientAddHandler(this.api));
            this.handlers.put("CHANNEL_RECIPIENT_REMOVE", new ChannelRecipientRemoveHandler(this.api));
            this.handlers.put("RELATIONSHIP_ADD", new RelationshipAddHandler(this.api));
            this.handlers.put("RELATIONSHIP_REMOVE", new RelationshipRemoveHandler(this.api));
            this.handlers.put("MESSAGE_ACK", nopHandler);
        }
    }

    protected class ReconnectNode
    extends ConnectNode {
        protected ReconnectNode() {
        }

        @Override
        public boolean isReconnect() {
            return true;
        }

        @Override
        public void run(boolean isLast) throws InterruptedException {
            if (WebSocketClient.this.shutdown) {
                return;
            }
            WebSocketClient.this.reconnect(true);
            if (isLast) {
                return;
            }
            try {
                WebSocketClient.this.api.awaitStatus(JDA.Status.AWAITING_LOGIN_CONFIRMATION);
            }
            catch (IllegalStateException ex) {
                WebSocketClient.this.close();
                LOG.debug("Shutdown while trying to reconnect");
            }
        }
    }

    protected class StartingNode
    extends ConnectNode {
        protected StartingNode() {
        }

        @Override
        public boolean isReconnect() {
            return false;
        }

        @Override
        public void run(boolean isLast) throws InterruptedException {
            if (WebSocketClient.this.shutdown) {
                return;
            }
            WebSocketClient.this.setupSendingThread();
            WebSocketClient.this.connect();
            if (isLast) {
                return;
            }
            try {
                WebSocketClient.this.api.awaitStatus(JDA.Status.AWAITING_LOGIN_CONFIRMATION);
            }
            catch (IllegalStateException ex) {
                WebSocketClient.this.close();
                LOG.debug("Shutdown while trying to connect");
            }
        }
    }

    protected abstract class ConnectNode
    implements SessionController.SessionConnectNode {
        protected ConnectNode() {
        }

        @Override
        public JDA getJDA() {
            return WebSocketClient.this.api;
        }

        @Override
        public JDA.ShardInfo getShardInfo() {
            return WebSocketClient.this.api.getShardInfo();
        }
    }
}

