/*
 * Decompiled with CFR 0.152.
 */
package ml.denis3d.repack.net.dv8tion.jda.core.requests;

import java.util.Queue;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import ml.denis3d.repack.gnu.trove.map.TLongObjectMap;
import ml.denis3d.repack.net.dv8tion.jda.core.audio.ConnectionRequest;
import ml.denis3d.repack.net.dv8tion.jda.core.audio.ConnectionStage;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.Guild;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.GuildVoiceState;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.impl.JDAImpl;
import ml.denis3d.repack.net.dv8tion.jda.core.managers.AudioManager;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.WebSocketClient;
import ml.denis3d.repack.org.json.JSONObject;
import ml.denis3d.repack.org.slf4j.Logger;

class WebSocketSendingThread
implements Runnable {
    private static final Logger LOG = WebSocketClient.LOG;
    private final WebSocketClient client;
    private final JDAImpl api;
    private final ReentrantLock queueLock;
    private final Queue<String> chunkSyncQueue;
    private final Queue<String> ratelimitQueue;
    private final TLongObjectMap<ConnectionRequest> queuedAudioConnections;
    private final ScheduledExecutorService executor;
    private Future<?> handle;
    private boolean needRateLimit = false;
    private boolean attemptedToSend = false;
    private boolean shutdown = false;

    WebSocketSendingThread(WebSocketClient client) {
        this.client = client;
        this.api = client.api;
        this.queueLock = client.queueLock;
        this.chunkSyncQueue = client.chunkSyncQueue;
        this.ratelimitQueue = client.ratelimitQueue;
        this.queuedAudioConnections = client.queuedAudioConnections;
        this.executor = client.executor;
    }

    public void shutdown() {
        this.shutdown = true;
        if (this.handle != null) {
            this.handle.cancel(false);
        }
    }

    public void start() {
        this.shutdown = false;
        this.handle = this.executor.submit(this);
    }

    private void scheduleIdle() {
        if (this.shutdown) {
            return;
        }
        this.handle = this.executor.schedule(this, 500L, TimeUnit.MILLISECONDS);
    }

    private void scheduleSentMessage() {
        if (this.shutdown) {
            return;
        }
        this.handle = this.executor.schedule(this, 10L, TimeUnit.MILLISECONDS);
    }

    private void scheduleRateLimit() {
        if (this.shutdown) {
            return;
        }
        this.handle = this.executor.schedule(this, 1L, TimeUnit.MINUTES);
    }

    @Override
    public void run() {
        if (!this.client.sentAuthInfo) {
            this.scheduleIdle();
            return;
        }
        try {
            this.api.setContext();
            this.attemptedToSend = false;
            this.needRateLimit = false;
            this.queueLock.lockInterruptibly();
            ConnectionRequest audioRequest = this.client.getNextAudioConnectRequest();
            String chunkOrSyncRequest = this.chunkSyncQueue.peek();
            if (chunkOrSyncRequest != null) {
                this.handleChunkSync(chunkOrSyncRequest);
            } else if (audioRequest != null) {
                this.handleAudioRequest(audioRequest);
            } else {
                this.handleNormalRequest();
            }
            if (this.needRateLimit) {
                this.scheduleRateLimit();
            } else if (!this.attemptedToSend) {
                this.scheduleIdle();
            } else {
                this.scheduleSentMessage();
            }
        }
        catch (InterruptedException ignored) {
            LOG.debug("Main WS send thread interrupted. Most likely JDA is disconnecting the websocket.");
        }
        finally {
            this.client.maybeUnlock();
        }
    }

    private void handleChunkSync(String chunkOrSyncRequest) {
        LOG.debug("Sending chunk/sync request {}", (Object)chunkOrSyncRequest);
        if (this.send(chunkOrSyncRequest)) {
            this.chunkSyncQueue.remove();
        }
    }

    private void handleAudioRequest(ConnectionRequest audioRequest) {
        JSONObject packet;
        long channelId = audioRequest.getChannelId();
        long guildId = audioRequest.getGuildIdLong();
        Guild guild = this.api.getGuildById(guildId);
        if (guild == null) {
            LOG.debug("Discarding voice request due to null guild {}", (Object)guildId);
            this.queuedAudioConnections.remove(guildId);
            return;
        }
        ConnectionStage stage = audioRequest.getStage();
        AudioManager audioManager = guild.getAudioManager();
        switch (stage) {
            case RECONNECT: 
            case DISCONNECT: {
                packet = this.newVoiceClose(guildId);
                break;
            }
            default: {
                packet = this.newVoiceOpen(audioManager, channelId, guild.getIdLong());
            }
        }
        LOG.debug("Sending voice request {}", (Object)packet);
        if (this.send(packet.toString())) {
            audioRequest.setNextAttemptEpoch(System.currentTimeMillis() + 2000L);
            GuildVoiceState voiceState = guild.getSelfMember().getVoiceState();
            this.client.updateAudioConnection0(guild.getIdLong(), voiceState.getChannel());
        }
    }

    private void handleNormalRequest() {
        String message = this.ratelimitQueue.peek();
        if (message != null) {
            LOG.debug("Sending normal message {}", (Object)message);
            if (this.send(message)) {
                this.ratelimitQueue.remove();
            }
        }
    }

    private boolean send(String request) {
        this.needRateLimit = !this.client.send(request, false);
        this.attemptedToSend = true;
        return !this.needRateLimit;
    }

    protected JSONObject newVoiceClose(long guildId) {
        return new JSONObject().put("op", 4).put("d", new JSONObject().put("guild_id", Long.toUnsignedString(guildId)).put("channel_id", JSONObject.NULL).put("self_mute", false).put("self_deaf", false));
    }

    protected JSONObject newVoiceOpen(AudioManager manager, long channel, long guild) {
        return new JSONObject().put("op", 4).put("d", new JSONObject().put("guild_id", guild).put("channel_id", channel).put("self_mute", manager.isSelfMuted()).put("self_deaf", manager.isSelfDeafened()));
    }
}

