/*
 * Decompiled with CFR 0.152.
 */
package ml.denis3d.repack.net.dv8tion.jda.core.requests.restaction;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.CheckReturnValue;
import ml.denis3d.repack.net.dv8tion.jda.core.AccountType;
import ml.denis3d.repack.net.dv8tion.jda.core.JDA;
import ml.denis3d.repack.net.dv8tion.jda.core.Permission;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.Channel;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.ChannelType;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.Member;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.Message;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.MessageChannel;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.MessageEmbed;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.MessageType;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.TextChannel;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.impl.JDAImpl;
import ml.denis3d.repack.net.dv8tion.jda.core.exceptions.InsufficientPermissionException;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.Method;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.Request;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.Requester;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.Response;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.RestAction;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.Route;
import ml.denis3d.repack.net.dv8tion.jda.core.utils.Checks;
import ml.denis3d.repack.net.dv8tion.jda.core.utils.Helpers;
import ml.denis3d.repack.net.dv8tion.jda.core.utils.MiscUtil;
import ml.denis3d.repack.okhttp3.MultipartBody;
import ml.denis3d.repack.okhttp3.RequestBody;
import ml.denis3d.repack.org.json.JSONObject;

public class MessageAction
extends RestAction<Message>
implements Appendable {
    private static final String CONTENT_TOO_BIG = String.format("A message may not exceed %d characters. Please limit your input!", 2000);
    protected final Map<String, InputStream> files = new HashMap<String, InputStream>();
    protected final Set<InputStream> ownedResources = new HashSet<InputStream>();
    protected final StringBuilder content;
    protected final MessageChannel channel;
    protected MessageEmbed embed = null;
    protected String nonce = null;
    protected boolean tts = false;
    protected boolean override = false;

    public MessageAction(JDA api, Route.CompiledRoute route, MessageChannel channel) {
        super(api, route);
        this.content = new StringBuilder();
        this.channel = channel;
    }

    public MessageAction(JDA api, Route.CompiledRoute route, MessageChannel channel, StringBuilder contentBuilder) {
        super(api, route);
        Checks.check(contentBuilder.length() <= 2000, "Cannot build a Message with more than %d characters. Please limit your input.", (Object)2000);
        this.content = contentBuilder;
        this.channel = channel;
    }

    public boolean isEmpty() {
        return Helpers.isBlank(this.content) && (this.embed == null || this.embed.isEmpty() || !this.hasPermission(Permission.MESSAGE_EMBED_LINKS));
    }

    public boolean isEdit() {
        return this.finalizeRoute().getMethod() == Method.PATCH;
    }

    @CheckReturnValue
    public MessageAction apply(Message message) {
        if (message == null || message.getType() != MessageType.DEFAULT) {
            return this;
        }
        List<MessageEmbed> embeds = message.getEmbeds();
        if (embeds != null && !embeds.isEmpty()) {
            this.embed(embeds.get(0));
        }
        this.files.clear();
        return this.content(message.getContentRaw()).tts(message.isTTS());
    }

    @CheckReturnValue
    public MessageAction tts(boolean isTTS) {
        this.tts = isTTS;
        return this;
    }

    @CheckReturnValue
    public MessageAction reset() {
        return this.content(null).nonce(null).embed(null).tts(false).override(false).clearFiles();
    }

    @CheckReturnValue
    public MessageAction nonce(String nonce) {
        this.nonce = nonce;
        return this;
    }

    @CheckReturnValue
    public MessageAction content(String content) {
        if (content == null || content.isEmpty()) {
            this.content.setLength(0);
        } else if (content.length() <= 2000) {
            this.content.replace(0, this.content.length(), content);
        } else {
            throw new IllegalArgumentException(CONTENT_TOO_BIG);
        }
        return this;
    }

    @CheckReturnValue
    public MessageAction embed(MessageEmbed embed) {
        if (embed != null) {
            AccountType type = this.getJDA().getAccountType();
            Checks.check(embed.isSendable(type), "Provided Message contains an empty embed or an embed with a length greater than %d characters, which is the max for %s accounts!", new Object[]{type == AccountType.BOT ? 6000 : 2000, type});
        }
        this.embed = embed;
        return this;
    }

    @Override
    @CheckReturnValue
    public MessageAction append(CharSequence csq) {
        return this.append(csq, 0, csq.length());
    }

    @Override
    @CheckReturnValue
    public MessageAction append(CharSequence csq, int start, int end) {
        if (this.content.length() + end - start > 2000) {
            throw new IllegalArgumentException("A message may not exceed 2000 characters. Please limit your input!");
        }
        this.content.append(csq, start, end);
        return this;
    }

    @Override
    @CheckReturnValue
    public MessageAction append(char c) {
        if (this.content.length() == 2000) {
            throw new IllegalArgumentException("A message may not exceed 2000 characters. Please limit your input!");
        }
        this.content.append(c);
        return this;
    }

    @CheckReturnValue
    public MessageAction appendFormat(String format, Object ... args) {
        return this.append(String.format(format, args));
    }

    @CheckReturnValue
    public MessageAction addFile(InputStream data, String name) {
        this.checkEdit();
        Checks.notNull(data, "Data");
        Checks.notBlank(name, "Name");
        this.checkFileAmount();
        this.checkPermission(Permission.MESSAGE_ATTACH_FILES);
        this.files.put(name, data);
        return this;
    }

    @CheckReturnValue
    public MessageAction addFile(byte[] data, String name) {
        Checks.notNull(data, "Data");
        long maxSize = this.getJDA().getSelfUser().getAllowedFileSize();
        Checks.check((long)data.length <= maxSize, "File may not exceed the maximum file length of %d bytes!", (Object)maxSize);
        return this.addFile(new ByteArrayInputStream(data), name);
    }

    @CheckReturnValue
    public MessageAction addFile(File file) {
        Checks.notNull(file, "File");
        return this.addFile(file, file.getName());
    }

    @CheckReturnValue
    public MessageAction addFile(File file, String name) {
        Checks.notNull(file, "File");
        Checks.check(file.exists() && file.canRead(), "Provided file either does not exist or cannot be read from!");
        long maxSize = this.getJDA().getSelfUser().getAllowedFileSize();
        Checks.check(file.length() <= maxSize, "File may not exceed the maximum file length of %d bytes!", (Object)maxSize);
        try {
            FileInputStream data = new FileInputStream(file);
            this.ownedResources.add(data);
            return this.addFile(data, name);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @CheckReturnValue
    public MessageAction clearFiles() {
        this.files.clear();
        this.clearResources();
        return this;
    }

    @CheckReturnValue
    public MessageAction clearFiles(BiConsumer<String, InputStream> finalizer) {
        Checks.notNull(finalizer, "Finalizer");
        Iterator<Map.Entry<String, InputStream>> it = this.files.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, InputStream> entry = it.next();
            finalizer.accept(entry.getKey(), entry.getValue());
            it.remove();
        }
        this.clearResources();
        return this;
    }

    @CheckReturnValue
    public MessageAction clearFiles(Consumer<InputStream> finalizer) {
        Checks.notNull(finalizer, "Finalizer");
        Iterator<InputStream> it = this.files.values().iterator();
        while (it.hasNext()) {
            finalizer.accept(it.next());
            it.remove();
        }
        this.clearResources();
        return this;
    }

    @CheckReturnValue
    public MessageAction override(boolean bool) {
        this.override = this.isEdit() && bool;
        return this;
    }

    private void clearResources() {
        for (InputStream ownedResource : this.ownedResources) {
            try {
                ownedResource.close();
            }
            catch (IOException ex) {
                if (ex.getMessage().toLowerCase().contains("closed")) continue;
                LOG.error("Encountered IOException trying to close owned resource", ex);
            }
        }
        this.ownedResources.clear();
    }

    protected RequestBody asMultipart() {
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        int index = 0;
        for (Map.Entry<String, InputStream> entry : this.files.entrySet()) {
            RequestBody body = MiscUtil.createRequestBody(Requester.MEDIA_TYPE_OCTET, entry.getValue());
            builder.addFormDataPart("file" + index++, entry.getKey(), body);
        }
        if (!this.isEmpty()) {
            builder.addFormDataPart("payload_json", this.getJSON().toString());
        }
        this.files.clear();
        this.ownedResources.clear();
        return builder.build();
    }

    protected RequestBody asJSON() {
        return RequestBody.create(Requester.MEDIA_TYPE_JSON, this.getJSON().toString());
    }

    protected JSONObject getJSON() {
        JSONObject obj = new JSONObject();
        if (this.override) {
            if (this.embed == null) {
                obj.put("embed", JSONObject.NULL);
            } else {
                obj.put("embed", MessageAction.getJSONEmbed(this.embed));
            }
            if (this.content.length() == 0) {
                obj.put("content", JSONObject.NULL);
            } else {
                obj.put("content", this.content.toString());
            }
            if (this.nonce == null) {
                obj.put("nonce", JSONObject.NULL);
            } else {
                obj.put("nonce", this.nonce);
            }
            obj.put("tts", this.tts);
        } else {
            if (this.embed != null) {
                obj.put("embed", MessageAction.getJSONEmbed(this.embed));
            }
            if (this.content.length() > 0) {
                obj.put("content", this.content.toString());
            }
            if (this.nonce != null) {
                obj.put("nonce", this.nonce);
            }
            obj.put("tts", this.tts);
        }
        return obj;
    }

    protected static JSONObject getJSONEmbed(MessageEmbed embed) {
        return embed.toJSONObject();
    }

    protected void checkFileAmount() {
        if (this.files.size() >= 10) {
            throw new IllegalStateException("Cannot add more than 10 files!");
        }
    }

    protected void checkEdit() {
        if (this.isEdit()) {
            throw new IllegalStateException("Cannot add files to an existing message! Edit-Message does not support this operation!");
        }
    }

    protected void checkPermission(Permission perm) {
        if (!this.hasPermission(perm)) {
            throw new InsufficientPermissionException(perm);
        }
    }

    protected boolean hasPermission(Permission perm) {
        if (this.channel.getType() != ChannelType.TEXT) {
            return true;
        }
        TextChannel text = (TextChannel)this.channel;
        Member self = text.getGuild().getSelfMember();
        return self.hasPermission((Channel)text, perm);
    }

    @Override
    protected RequestBody finalizeData() {
        if (!this.files.isEmpty()) {
            return this.asMultipart();
        }
        if (!this.isEmpty()) {
            return this.asJSON();
        }
        throw new IllegalStateException("Cannot build a message without content!");
    }

    @Override
    protected void handleResponse(Response response, Request<Message> request) {
        if (response.isOk()) {
            request.onSuccess(((JDAImpl)this.api.get()).getEntityBuilder().createMessage(response.getObject(), this.channel, false));
        } else {
            request.onFailure(response);
        }
    }

    protected void finalize() {
        if (this.ownedResources.isEmpty()) {
            return;
        }
        LOG.warn("Found unclosed resources in MessageAction instance, closing on finalization step!");
        this.clearResources();
    }
}

