/*
 * Decompiled with CFR 0.152.
 */
package ml.denis3d.repack.net.dv8tion.jda.core.requests.restaction;

import java.awt.Color;
import java.util.Collection;
import java.util.function.BooleanSupplier;
import javax.annotation.CheckReturnValue;
import ml.denis3d.repack.net.dv8tion.jda.core.Permission;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.Guild;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.Role;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.impl.GuildImpl;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.impl.JDAImpl;
import ml.denis3d.repack.net.dv8tion.jda.core.exceptions.InsufficientPermissionException;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.Request;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.Response;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.Route;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.restaction.AuditableRestAction;
import ml.denis3d.repack.net.dv8tion.jda.core.utils.Checks;
import ml.denis3d.repack.okhttp3.RequestBody;
import ml.denis3d.repack.org.json.JSONObject;

public class RoleAction
extends AuditableRestAction<Role> {
    protected final Guild guild;
    protected Long permissions;
    protected String name = null;
    protected Integer color = null;
    protected Boolean hoisted = null;
    protected Boolean mentionable = null;

    public RoleAction(Route.CompiledRoute route, Guild guild) {
        super(guild.getJDA(), route);
        this.guild = guild;
    }

    @Override
    public RoleAction setCheck(BooleanSupplier checks) {
        return (RoleAction)super.setCheck(checks);
    }

    @CheckReturnValue
    public RoleAction setName(String name) {
        this.name = name;
        return this;
    }

    @CheckReturnValue
    public RoleAction setHoisted(Boolean hoisted) {
        this.hoisted = hoisted;
        return this;
    }

    @CheckReturnValue
    public RoleAction setMentionable(Boolean mentionable) {
        this.mentionable = mentionable;
        return this;
    }

    @CheckReturnValue
    public RoleAction setColor(Color color) {
        return this.setColor(color != null ? Integer.valueOf(color.getRGB()) : null);
    }

    @CheckReturnValue
    public RoleAction setColor(Integer rgb) {
        this.color = rgb;
        return this;
    }

    @CheckReturnValue
    public RoleAction setPermissions(Permission ... permissions) {
        if (permissions != null) {
            for (Permission p : permissions) {
                Checks.notNull((Object)p, "Permissions");
                this.checkPermission(p);
            }
        }
        this.permissions = permissions == null ? null : Long.valueOf(Permission.getRaw(permissions));
        return this;
    }

    @CheckReturnValue
    public RoleAction setPermissions(Collection<Permission> permissions) {
        if (permissions != null) {
            for (Permission p : permissions) {
                Checks.notNull((Object)p, "Permissions");
                this.checkPermission(p);
            }
        }
        this.permissions = permissions == null ? null : Long.valueOf(Permission.getRaw(permissions));
        return this;
    }

    @CheckReturnValue
    public RoleAction setPermissions(Long permissions) {
        if (permissions != null) {
            Checks.notNegative(permissions, "Raw Permissions");
            Checks.check(permissions <= Permission.ALL_PERMISSIONS, "Provided permissions may not be greater than a full permission set!");
            for (Permission p : Permission.toEnumSet(permissions)) {
                this.checkPermission(p);
            }
        }
        this.permissions = permissions;
        return this;
    }

    @Override
    protected RequestBody finalizeData() {
        JSONObject object = new JSONObject();
        if (this.name != null) {
            object.put("name", this.name);
        }
        if (this.color != null) {
            object.put("color", (int)(this.color & 0xFFFFFF));
        }
        if (this.permissions != null) {
            object.put("permissions", this.permissions);
        }
        if (this.hoisted != null) {
            object.put("hoist", this.hoisted);
        }
        if (this.mentionable != null) {
            object.put("mentionable", this.mentionable);
        }
        return this.getRequestBody(object);
    }

    @Override
    protected void handleResponse(Response response, Request<Role> request) {
        if (response.isOk()) {
            request.onSuccess(((JDAImpl)this.api.get()).getEntityBuilder().createRole((GuildImpl)this.guild, response.getObject(), this.guild.getIdLong()));
        } else {
            request.onFailure(response);
        }
    }

    private void checkPermission(Permission permission) {
        if (!this.guild.getSelfMember().hasPermission(permission)) {
            throw new InsufficientPermissionException(permission);
        }
    }
}

