/*
 * Decompiled with CFR 0.152.
 */
package ml.denis3d.repack.net.dv8tion.jda.core.requests.restaction.order;

import java.util.Collection;
import ml.denis3d.repack.net.dv8tion.jda.core.Permission;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.Channel;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.ChannelType;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.Guild;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.Member;
import ml.denis3d.repack.net.dv8tion.jda.core.exceptions.InsufficientPermissionException;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.Route;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.restaction.order.OrderAction;
import ml.denis3d.repack.net.dv8tion.jda.core.utils.Checks;
import ml.denis3d.repack.okhttp3.RequestBody;
import ml.denis3d.repack.org.json.JSONArray;
import ml.denis3d.repack.org.json.JSONObject;

public class ChannelOrderAction<T extends Channel>
extends OrderAction<T, ChannelOrderAction<T>> {
    protected final Guild guild;
    protected final ChannelType type;

    public ChannelOrderAction(Guild guild, ChannelType type) {
        this(guild, type, ChannelOrderAction.getChannelsOfType(guild, type));
    }

    public ChannelOrderAction(Guild guild, ChannelType type, Collection<T> channels) {
        super(guild.getJDA(), Route.Guilds.MODIFY_CHANNELS.compile(guild.getId()));
        Checks.notNull(channels, "Channels to order");
        Checks.notEmpty(channels, "Channels to order");
        Checks.check(channels.stream().allMatch(c -> guild.equals(c.getGuild())), "One or more channels are not from the correct guild");
        Checks.check(channels.stream().allMatch(c -> c.getType().equals((Object)type)), "One or more channels did not match the expected type of " + type.name());
        this.guild = guild;
        this.type = type;
        this.orderList.addAll(channels);
    }

    public Guild getGuild() {
        return this.guild;
    }

    public ChannelType getChannelType() {
        return this.type;
    }

    @Override
    protected RequestBody finalizeData() {
        Member self = this.guild.getSelfMember();
        if (!self.hasPermission(Permission.MANAGE_CHANNEL)) {
            throw new InsufficientPermissionException(Permission.MANAGE_CHANNEL);
        }
        JSONArray array = new JSONArray();
        for (int i = 0; i < this.orderList.size(); ++i) {
            Channel chan = (Channel)this.orderList.get(i);
            array.put(new JSONObject().put("id", chan.getId()).put("position", i));
        }
        return this.getRequestBody(array);
    }

    @Override
    protected void validateInput(T entity) {
        Checks.check(entity.getGuild().equals(this.guild), "Provided channel is not from this Guild!");
        Checks.check(this.orderList.contains(entity), "Provided channel is not in the list of orderable channels!");
    }

    private static Collection<? extends Channel> getChannelsOfType(Guild guild, ChannelType type) {
        switch (type) {
            case TEXT: {
                return guild.getTextChannels();
            }
            case VOICE: {
                return guild.getVoiceChannels();
            }
            case CATEGORY: {
                return guild.getCategories();
            }
        }
        throw new IllegalArgumentException("Cannot order specified channel type " + (Object)((Object)type));
    }
}

