/*
 * Decompiled with CFR 0.152.
 */
package ml.denis3d.repack.net.dv8tion.jda.core.requests.restaction.order;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.BooleanSupplier;
import ml.denis3d.repack.net.dv8tion.jda.core.JDA;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.Request;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.Response;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.RestAction;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.Route;
import ml.denis3d.repack.net.dv8tion.jda.core.utils.Checks;

public abstract class OrderAction<T, M extends OrderAction<T, M>>
extends RestAction<Void> {
    protected final List<T> orderList = new ArrayList<T>();
    protected final boolean ascendingOrder;
    protected int selectedPosition = -1;

    public OrderAction(JDA api, Route.CompiledRoute route) {
        this(api, true, route);
    }

    public OrderAction(JDA api, boolean ascendingOrder, Route.CompiledRoute route) {
        super(api, route);
        this.ascendingOrder = ascendingOrder;
    }

    public M setCheck(BooleanSupplier checks) {
        return (M)((OrderAction)super.setCheck(checks));
    }

    public List<T> getCurrentOrder() {
        return Collections.unmodifiableList(this.orderList);
    }

    public M selectPosition(int selectedPosition) {
        Checks.notNegative(selectedPosition, "Provided selectedPosition");
        Checks.check(selectedPosition < this.orderList.size(), "Provided selectedPosition is too big and is out of bounds. selectedPosition: " + selectedPosition);
        this.selectedPosition = selectedPosition;
        return (M)this;
    }

    public M selectPosition(T selectedEntity) {
        Checks.notNull(selectedEntity, "Channel");
        this.validateInput(selectedEntity);
        return this.selectPosition((T)this.orderList.indexOf(selectedEntity));
    }

    public int getSelectedPosition() {
        return this.selectedPosition;
    }

    public T getSelectedEntity() {
        if (this.selectedPosition == -1) {
            throw new IllegalStateException("No position has been selected yet");
        }
        return this.orderList.get(this.selectedPosition);
    }

    public M moveUp(int amount) {
        Checks.notNegative(amount, "Provided amount");
        if (this.selectedPosition == -1) {
            throw new IllegalStateException("Cannot move until an item has been selected. Use #selectPosition first.");
        }
        if (this.ascendingOrder) {
            Checks.check(this.selectedPosition - amount >= 0, "Amount provided to move up is too large and would be out of bounds.Selected position: " + this.selectedPosition + " Amount: " + amount + " Largest Position: " + this.orderList.size());
        } else {
            Checks.check(this.selectedPosition + amount < this.orderList.size(), "Amount provided to move up is too large and would be out of bounds.Selected position: " + this.selectedPosition + " Amount: " + amount + " Largest Position: " + this.orderList.size());
        }
        if (this.ascendingOrder) {
            return this.moveTo(this.selectedPosition - amount);
        }
        return this.moveTo(this.selectedPosition + amount);
    }

    public M moveDown(int amount) {
        Checks.notNegative(amount, "Provided amount");
        if (this.selectedPosition == -1) {
            throw new IllegalStateException("Cannot move until an item has been selected. Use #selectPosition first.");
        }
        if (this.ascendingOrder) {
            Checks.check(this.selectedPosition + amount < this.orderList.size(), "Amount provided to move down is too large and would be out of bounds.Selected position: " + this.selectedPosition + " Amount: " + amount + " Largest Position: " + this.orderList.size());
        } else {
            Checks.check(this.selectedPosition - amount >= this.orderList.size(), "Amount provided to move down is too large and would be out of bounds.Selected position: " + this.selectedPosition + " Amount: " + amount + " Largest Position: " + this.orderList.size());
        }
        if (this.ascendingOrder) {
            return this.moveTo(this.selectedPosition + amount);
        }
        return this.moveTo(this.selectedPosition - amount);
    }

    public M moveTo(int position) {
        Checks.notNegative(position, "Provided position");
        Checks.check(position < this.orderList.size(), "Provided position is too big and is out of bounds.");
        T selectedItem = this.orderList.remove(this.selectedPosition);
        this.orderList.add(position, selectedItem);
        return (M)this;
    }

    public M swapPosition(int swapPosition) {
        Checks.notNegative(swapPosition, "Provided swapPosition");
        Checks.check(swapPosition < this.orderList.size(), "Provided swapPosition is too big and is out of bounds. swapPosition: " + swapPosition);
        T selectedItem = this.orderList.get(this.selectedPosition);
        T swapItem = this.orderList.get(swapPosition);
        this.orderList.set(swapPosition, selectedItem);
        this.orderList.set(this.selectedPosition, swapItem);
        return (M)this;
    }

    public M swapPosition(T swapEntity) {
        Checks.notNull(swapEntity, "Provided swapEntity");
        this.validateInput(swapEntity);
        return this.swapPosition((T)this.orderList.indexOf(swapEntity));
    }

    public M reverseOrder() {
        Collections.reverse(this.orderList);
        return (M)this;
    }

    public M shuffleOrder() {
        Collections.shuffle(this.orderList);
        return (M)this;
    }

    public M sortOrder(Comparator<T> comparator) {
        Checks.notNull(comparator, "Provided comparator");
        this.orderList.sort(comparator);
        return (M)this;
    }

    @Override
    protected void handleResponse(Response response, Request<Void> request) {
        if (response.isOk()) {
            request.onSuccess(null);
        } else {
            request.onFailure(response);
        }
    }

    protected abstract void validateInput(T var1);
}

