/*
 * Decompiled with CFR 0.152.
 */
package ml.denis3d.repack.net.dv8tion.jda.core.requests.restaction.pagination;

import java.util.ArrayList;
import java.util.List;
import ml.denis3d.repack.net.dv8tion.jda.core.Permission;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.Channel;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.ChannelType;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.EntityBuilder;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.Message;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.MessageChannel;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.TextChannel;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.impl.JDAImpl;
import ml.denis3d.repack.net.dv8tion.jda.core.exceptions.InsufficientPermissionException;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.Request;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.Response;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.Route;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.restaction.pagination.PaginationAction;
import ml.denis3d.repack.org.json.JSONArray;
import ml.denis3d.repack.org.json.JSONException;

public class MessagePaginationAction
extends PaginationAction<Message, MessagePaginationAction> {
    private final MessageChannel channel;

    public MessagePaginationAction(MessageChannel channel) {
        super(channel.getJDA(), Route.Messages.GET_MESSAGE_HISTORY.compile(channel.getId()), 1, 100, 100);
        if (channel.getType() == ChannelType.TEXT) {
            TextChannel textChannel = (TextChannel)channel;
            if (!textChannel.getGuild().getSelfMember().hasPermission((Channel)textChannel, Permission.MESSAGE_HISTORY)) {
                throw new InsufficientPermissionException(Permission.MESSAGE_HISTORY);
            }
        }
        this.channel = channel;
    }

    public ChannelType getType() {
        return this.getChannel().getType();
    }

    public MessageChannel getChannel() {
        return this.channel;
    }

    @Override
    protected Route.CompiledRoute finalizeRoute() {
        Route.CompiledRoute route = super.finalizeRoute();
        String limit = String.valueOf(this.getLimit());
        Message last = (Message)this.last;
        route = route.withQueryParams("limit", limit);
        if (last != null) {
            route = route.withQueryParams("before", last.getId());
        }
        return route;
    }

    @Override
    protected void handleResponse(Response response, Request<List<Message>> request) {
        if (!response.isOk()) {
            request.onFailure(response);
            return;
        }
        JSONArray array = response.getArray();
        ArrayList<Message> messages = new ArrayList<Message>(array.length());
        EntityBuilder builder = ((JDAImpl)this.api.get()).getEntityBuilder();
        for (int i = 0; i < array.length(); ++i) {
            try {
                Message msg = builder.createMessage(array.getJSONObject(i), this.channel, false);
                messages.add(msg);
                if (this.useCache) {
                    this.cached.add(msg);
                }
                this.last = msg;
                continue;
            }
            catch (NullPointerException | JSONException e) {
                LOG.warn("Encountered an exception in MessagePagination", e);
            }
        }
        request.onSuccess(messages);
    }
}

