/*
 * Decompiled with CFR 0.152.
 */
package ml.denis3d.repack.net.dv8tion.jda.core.requests.restaction.pagination;

import java.util.LinkedList;
import java.util.List;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.EntityBuilder;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.MessageReaction;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.User;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.impl.JDAImpl;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.impl.UserImpl;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.Request;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.Response;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.Route;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.restaction.pagination.PaginationAction;
import ml.denis3d.repack.net.dv8tion.jda.core.utils.MiscUtil;
import ml.denis3d.repack.org.json.JSONArray;
import ml.denis3d.repack.org.json.JSONException;

public class ReactionPaginationAction
extends PaginationAction<User, ReactionPaginationAction> {
    protected final MessageReaction reaction;

    public ReactionPaginationAction(MessageReaction reaction) {
        super(reaction.getJDA(), Route.Messages.GET_REACTION_USERS.compile(reaction.getChannel().getId(), reaction.getMessageId(), ReactionPaginationAction.getCode(reaction)), 1, 100, 100);
        this.reaction = reaction;
    }

    protected static String getCode(MessageReaction reaction) {
        MessageReaction.ReactionEmote emote = reaction.getReactionEmote();
        return emote.isEmote() ? emote.getName() + ":" + emote.getId() : MiscUtil.encodeUTF8(emote.getName());
    }

    public MessageReaction getReaction() {
        return this.reaction;
    }

    @Override
    protected Route.CompiledRoute finalizeRoute() {
        Route.CompiledRoute route = super.finalizeRoute();
        String after = null;
        String limit = String.valueOf(this.getLimit());
        User last = (User)this.last;
        if (last != null) {
            after = last.getId();
        }
        route = route.withQueryParams("limit", limit);
        if (after != null) {
            route = route.withQueryParams("after", after);
        }
        return route;
    }

    @Override
    protected void handleResponse(Response response, Request<List<User>> request) {
        if (!response.isOk()) {
            request.onFailure(response);
            return;
        }
        EntityBuilder builder = ((JDAImpl)this.api.get()).getEntityBuilder();
        JSONArray array = response.getArray();
        LinkedList<UserImpl> users = new LinkedList<UserImpl>();
        for (int i = 0; i < array.length(); ++i) {
            try {
                UserImpl user = builder.createFakeUser(array.getJSONObject(i), false);
                users.add(user);
                if (this.useCache) {
                    this.cached.add(user);
                }
                this.last = user;
                continue;
            }
            catch (NullPointerException | JSONException e) {
                LOG.warn("Encountered exception in ReactionPagination", e);
            }
        }
        request.onSuccess(users);
    }
}

