/*
 * Decompiled with CFR 0.152.
 */
package ml.denis3d.repack.net.dv8tion.jda.core.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import ml.denis3d.repack.net.dv8tion.jda.core.utils.Checks;
import ml.denis3d.repack.org.json.JSONObject;

public final class Helpers {
    public static boolean isEmpty(CharSequence seq) {
        return seq == null || seq.length() == 0;
    }

    public static boolean containsWhitespace(CharSequence seq) {
        if (Helpers.isEmpty(seq)) {
            return false;
        }
        for (int i = 0; i < seq.length(); ++i) {
            if (!Character.isWhitespace(seq.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean isBlank(CharSequence seq) {
        if (Helpers.isEmpty(seq)) {
            return true;
        }
        for (int i = 0; i < seq.length(); ++i) {
            if (Character.isWhitespace(seq.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsIgnoreCase(String seq0, String seq1) {
        return Objects.equals(seq0, seq1) || seq0 != null && seq0.equalsIgnoreCase(seq1);
    }

    public static int countMatches(CharSequence seq, char c) {
        if (Helpers.isEmpty(seq)) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < seq.length(); ++i) {
            if (seq.charAt(i) != c) continue;
            ++count;
        }
        return count;
    }

    public static String truncate(String input, int maxWidth) {
        if (input == null) {
            return null;
        }
        Checks.notNegative(maxWidth, "maxWidth");
        if (input.length() <= maxWidth) {
            return input;
        }
        if (maxWidth == 0) {
            return "";
        }
        return input.substring(0, maxWidth);
    }

    public static String rightPad(String input, int size) {
        int pads = size - input.length();
        if (pads <= 0) {
            return input;
        }
        StringBuilder out = new StringBuilder(input);
        for (int i = pads; i > 0; --i) {
            out.append(' ');
        }
        return out.toString();
    }

    public static String leftPad(String input, int size) {
        int pads = size - input.length();
        if (pads <= 0) {
            return input;
        }
        StringBuilder out = new StringBuilder();
        for (int i = pads; i > 0; --i) {
            out.append(' ');
        }
        return out.append(input).toString();
    }

    public static boolean isNumeric(String input) {
        if (input.isEmpty()) {
            return false;
        }
        for (char c : input.toCharArray()) {
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        throwable.printStackTrace(pw);
        return sw.getBuffer().toString();
    }

    public static boolean deepEquals(Collection<?> first, Collection<?> second) {
        if (first != null) {
            if (second == null) {
                return false;
            }
            if (first.size() != second.size()) {
                return false;
            }
            Iterator<?> itFirst = first.iterator();
            Iterator<?> itSecond = second.iterator();
            while (itFirst.hasNext()) {
                Object elementSecond;
                Object elementFirst = itFirst.next();
                if (Objects.equals(elementFirst, elementSecond = itSecond.next())) continue;
                return false;
            }
        } else if (second != null) {
            return false;
        }
        return true;
    }

    public static boolean optBoolean(JSONObject object, String key) {
        return !object.isNull(key) && object.getBoolean(key);
    }

    public static int optInt(JSONObject object, String key, int defaultValue) {
        return object.isNull(key) ? defaultValue : object.getInt(key);
    }

    public static long optLong(JSONObject object, String key, long defaultValue) {
        return object.isNull(key) ? defaultValue : object.getLong(key);
    }
}

