/*
 * Decompiled with CFR 0.152.
 */
package ml.denis3d.repack.net.dv8tion.jda.core.utils.cache.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.Member;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.Role;
import ml.denis3d.repack.net.dv8tion.jda.core.utils.Checks;
import ml.denis3d.repack.net.dv8tion.jda.core.utils.cache.MemberCacheView;
import ml.denis3d.repack.net.dv8tion.jda.core.utils.cache.impl.AbstractCacheView;

public class MemberCacheViewImpl
extends AbstractCacheView<Member>
implements MemberCacheView {
    public MemberCacheViewImpl() {
        super(Member.class, Member::getEffectiveName);
    }

    @Override
    public Member getElementById(long id) {
        return (Member)this.elements.get(id);
    }

    @Override
    public List<Member> getElementsByUsername(String name, boolean ignoreCase) {
        Checks.notEmpty(name, "Name");
        ArrayList<Member> members = new ArrayList<Member>();
        for (Member member : this) {
            String nick = member.getUser().getName();
            if (!this.equals(ignoreCase, nick, name)) continue;
            members.add(member);
        }
        return Collections.unmodifiableList(members);
    }

    @Override
    public List<Member> getElementsByNickname(String name, boolean ignoreCase) {
        ArrayList<Member> members = new ArrayList<Member>();
        for (Member member : this) {
            String nick = member.getNickname();
            if (nick == null) {
                if (name != null) continue;
                members.add(member);
                continue;
            }
            if (!this.equals(ignoreCase, nick, name)) continue;
            members.add(member);
        }
        return Collections.unmodifiableList(members);
    }

    @Override
    public List<Member> getElementsByName(String name, boolean ignoreCase) {
        Checks.notEmpty(name, "Name");
        ArrayList<Member> members = new ArrayList<Member>();
        for (Member member : this) {
            String nick = member.getEffectiveName();
            if (!this.equals(ignoreCase, nick, name)) continue;
            members.add(member);
        }
        return Collections.unmodifiableList(members);
    }

    @Override
    public List<Member> getElementsWithRoles(Role ... roles) {
        Checks.notNull(roles, "Roles");
        for (Role role : roles) {
            Checks.notNull(role, "Roles");
        }
        ArrayList<Member> members = new ArrayList<Member>();
        List<Role> match = Arrays.asList(roles);
        for (Member member : this) {
            if (!member.getRoles().containsAll(match)) continue;
            members.add(member);
        }
        return members;
    }

    @Override
    public List<Member> getElementsWithRoles(Collection<Role> roles) {
        Checks.noneNull(roles, "Roles");
        ArrayList<Member> members = new ArrayList<Member>();
        for (Member member : this) {
            if (!member.getRoles().containsAll(roles)) continue;
            members.add(member);
        }
        return members;
    }
}

