/*
 * Decompiled with CFR 0.152.
 */
package ml.denis3d.repack.net.dv8tion.jda.core.utils.cache.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.ISnowflake;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.Member;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.Role;
import ml.denis3d.repack.net.dv8tion.jda.core.utils.cache.CacheView;
import ml.denis3d.repack.net.dv8tion.jda.core.utils.cache.MemberCacheView;
import ml.denis3d.repack.net.dv8tion.jda.core.utils.cache.SnowflakeCacheView;
import ml.denis3d.repack.net.dv8tion.jda.core.utils.cache.UnifiedMemberCacheView;

public class UnifiedCacheViewImpl<T, E extends CacheView<T>>
implements CacheView<T> {
    protected final Supplier<Stream<E>> generator;

    public UnifiedCacheViewImpl(Supplier<Stream<E>> generator) {
        this.generator = generator;
    }

    @Override
    public long size() {
        return this.distinctStream().mapToLong(CacheView::size).sum();
    }

    @Override
    public boolean isEmpty() {
        return this.distinctStream().allMatch(CacheView::isEmpty);
    }

    @Override
    public List<T> asList() {
        ArrayList list = new ArrayList();
        this.stream().forEach(list::add);
        return Collections.unmodifiableList(list);
    }

    @Override
    public Set<T> asSet() {
        HashSet set = new HashSet();
        this.generator.get().flatMap(CacheView::stream).forEach(set::add);
        return Collections.unmodifiableSet(set);
    }

    @Override
    public List<T> getElementsByName(String name, boolean ignoreCase) {
        return Collections.unmodifiableList(this.distinctStream().flatMap(view -> view.getElementsByName(name, ignoreCase).stream()).collect(Collectors.toList()));
    }

    @Override
    public Stream<T> stream() {
        return this.generator.get().flatMap(CacheView::stream).distinct();
    }

    @Override
    public Stream<T> parallelStream() {
        return this.generator.get().flatMap(CacheView::parallelStream).distinct();
    }

    @Override
    @Nonnull
    public Iterator<T> iterator() {
        return this.stream().iterator();
    }

    protected Stream<E> distinctStream() {
        return this.generator.get().distinct();
    }

    public static class UnifiedMemberCacheViewImpl
    extends UnifiedCacheViewImpl<Member, MemberCacheView>
    implements UnifiedMemberCacheView {
        public UnifiedMemberCacheViewImpl(Supplier<Stream<MemberCacheView>> generator) {
            super(generator);
        }

        @Override
        public List<Member> getElementsById(long id) {
            return Collections.unmodifiableList(this.distinctStream().map(view -> view.getElementById(id)).filter(Objects::nonNull).collect(Collectors.toList()));
        }

        @Override
        public List<Member> getElementsByUsername(String name, boolean ignoreCase) {
            return Collections.unmodifiableList(this.distinctStream().flatMap(view -> view.getElementsByUsername(name, ignoreCase).stream()).collect(Collectors.toList()));
        }

        @Override
        public List<Member> getElementsByNickname(String name, boolean ignoreCase) {
            return Collections.unmodifiableList(this.distinctStream().flatMap(view -> view.getElementsByNickname(name, ignoreCase).stream()).collect(Collectors.toList()));
        }

        @Override
        public List<Member> getElementsWithRoles(Role ... roles) {
            return Collections.unmodifiableList(this.distinctStream().flatMap(view -> view.getElementsWithRoles(roles).stream()).collect(Collectors.toList()));
        }

        @Override
        public List<Member> getElementsWithRoles(Collection<Role> roles) {
            return Collections.unmodifiableList(this.distinctStream().flatMap(view -> view.getElementsWithRoles(roles).stream()).collect(Collectors.toList()));
        }
    }

    public static class UnifiedSnowflakeCacheView<T extends ISnowflake>
    extends UnifiedCacheViewImpl<T, SnowflakeCacheView<T>>
    implements SnowflakeCacheView<T> {
        public UnifiedSnowflakeCacheView(Supplier<Stream<SnowflakeCacheView<T>>> generator) {
            super(generator);
        }

        @Override
        public T getElementById(long id) {
            return (T)((ISnowflake)((Stream)this.generator.get()).map(view -> view.getElementById(id)).filter(Objects::nonNull).findFirst().orElse(null));
        }
    }
}

