/*
 * Decompiled with CFR 0.152.
 */
package net.doubledoordev.mtrm.network;

import io.netty.buffer.ByteBuf;
import net.doubledoordev.mtrm.gui.MTRMGui;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageResponse
implements IMessage {
    private String message;

    public MessageResponse() {
    }

    public MessageResponse(Status status, Object ... args) {
        this.message = status.message == null ? null : String.format(status.message, args);
    }

    public void fromBytes(ByteBuf buf) {
        if (buf.readBoolean()) {
            this.message = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.message != null);
        if (this.message != null) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.message);
        }
    }

    public static enum Status {
        OK(null),
        NO_OUT("There is no output specified."),
        NO_IN("There is no input specified."),
        WRITE_ERROR("IOError: %s");

        private final String message;

        private Status(String message) {
            this.message = message;
        }
    }

    public static class Handler
    implements IMessageHandler<MessageResponse, IMessage> {
        public IMessage onMessage(MessageResponse message, MessageContext ctx) {
            if (Minecraft.func_71410_x().field_71462_r instanceof MTRMGui) {
                MTRMGui gui = (MTRMGui)Minecraft.func_71410_x().field_71462_r;
                gui.showMessage(message.message);
            }
            return null;
        }
    }
}

