/*
 * Decompiled with CFR 0.152.
 */
package nex.block;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nex.block.BlockNetherEx;
import nex.block.BlockNetherrack;
import nex.init.NetherExBlocks;
import nex.init.NetherExItems;

public class BlockEnokiMushroomStem
extends BlockNetherEx {
    private static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    private static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    private static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    private static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    private static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");
    private static final PropertyBool DOWN = PropertyBool.func_177716_a((String)"down");

    public BlockEnokiMushroomStem() {
        super("plant_mushroom_enoki_stem", Material.field_151585_k);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149711_c(0.4f);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!this.canSurviveAt(world, pos)) {
            world.func_175655_b(pos, true);
        }
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        Block block = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        Block block1 = world.func_180495_p(pos.func_177984_a()).func_177230_c();
        Block block2 = world.func_180495_p(pos.func_177978_c()).func_177230_c();
        Block block3 = world.func_180495_p(pos.func_177974_f()).func_177230_c();
        Block block4 = world.func_180495_p(pos.func_177968_d()).func_177230_c();
        Block block5 = world.func_180495_p(pos.func_177976_e()).func_177230_c();
        return state.func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(block == this || block == NetherExBlocks.PLANT_MUSHROOM_ENOKI_CAP)).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(block1 == this || block1 == Blocks.field_150424_aL || block1 == NetherExBlocks.BLOCK_NETHERRACK || block1 == NetherExBlocks.PLANT_MUSHROOM_ENOKI_CAP)).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(block2 == this || block2 == NetherExBlocks.PLANT_MUSHROOM_ENOKI_CAP)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(block3 == this || block3 == NetherExBlocks.PLANT_MUSHROOM_ENOKI_CAP)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(block4 == this || block4 == NetherExBlocks.PLANT_MUSHROOM_ENOKI_CAP)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(block5 == this || block5 == NetherExBlocks.PLANT_MUSHROOM_ENOKI_CAP));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        float f1 = (Boolean)(state = state.func_185899_b(source, pos)).func_177229_b((IProperty)WEST) != false ? 0.0f : 0.1875f;
        float f2 = (Boolean)state.func_177229_b((IProperty)DOWN) != false ? 0.0f : 0.1875f;
        float f3 = (Boolean)state.func_177229_b((IProperty)NORTH) != false ? 0.0f : 0.1875f;
        float f4 = (Boolean)state.func_177229_b((IProperty)EAST) != false ? 1.0f : 0.8125f;
        float f5 = (Boolean)state.func_177229_b((IProperty)UP) != false ? 1.0f : 0.8125f;
        float f6 = (Boolean)state.func_177229_b((IProperty)SOUTH) != false ? 1.0f : 0.8125f;
        return new AxisAlignedBB((double)f1, (double)f2, (double)f3, (double)f4, (double)f5, (double)f6);
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entity, boolean bool) {
        state = state.func_185899_b((IBlockAccess)world, pos);
        BlockEnokiMushroomStem.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(0.1875, 0.1875, 0.1875, 0.8125, 0.8125, 0.8125));
        if (((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue()) {
            BlockEnokiMushroomStem.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(0.0, 0.1875, 0.1875, 0.1875, 0.8125, 0.8125));
        }
        if (((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue()) {
            BlockEnokiMushroomStem.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(0.8125, 0.1875, 0.1875, 1.0, 0.8125, 0.8125));
        }
        if (((Boolean)state.func_177229_b((IProperty)UP)).booleanValue()) {
            BlockEnokiMushroomStem.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(0.1875, 0.8125, 0.1875, 0.8125, 1.0, 0.8125));
        }
        if (((Boolean)state.func_177229_b((IProperty)DOWN)).booleanValue()) {
            BlockEnokiMushroomStem.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.1875, 0.8125));
        }
        if (((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue()) {
            BlockEnokiMushroomStem.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(0.1875, 0.1875, 0.0, 0.8125, 0.8125, 0.1875));
        }
        if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue()) {
            BlockEnokiMushroomStem.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(0.1875, 0.1875, 0.8125, 0.8125, 0.8125, 1.0));
        }
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return super.func_176196_c(world, pos) && this.canSurviveAt(world, pos);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.canSurviveAt(world, pos)) {
            world.func_175684_a(pos, (Block)this, 1);
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        if (rand.nextInt(4) == 0) {
            return NetherExItems.FOOD_MUSHROOM_ENOKI;
        }
        return Items.field_190931_a;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{NORTH, EAST, SOUTH, WEST, UP, DOWN});
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public boolean func_176205_b(IBlockAccess world, BlockPos pos) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        Block block = blockAccess.func_180495_p(pos.func_177972_a(side)).func_177230_c();
        return block != this && side != EnumFacing.UP;
    }

    private boolean canSurviveAt(World wordIn, BlockPos pos) {
        boolean flag = wordIn.func_175623_d(pos.func_177984_a());
        boolean flag1 = wordIn.func_175623_d(pos.func_177977_b());
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            BlockPos blockpos = pos.func_177972_a(enumfacing);
            Block block = wordIn.func_180495_p(blockpos).func_177230_c();
            if (block != this) continue;
            if (!flag && !flag1) {
                return false;
            }
            IBlockState state1 = wordIn.func_180495_p(blockpos.func_177984_a());
            if (state1.func_177230_c() != this && state1.func_177230_c() != Blocks.field_150424_aL && state1 != NetherExBlocks.BLOCK_NETHERRACK.func_176223_P().func_177226_a(BlockNetherrack.TYPE, (Comparable)((Object)BlockNetherrack.EnumType.LIVELY))) continue;
            return true;
        }
        IBlockState state2 = wordIn.func_180495_p(pos.func_177984_a());
        return state2.func_177230_c() == this || state2.func_177230_c() == Blocks.field_150424_aL || state2 == NetherExBlocks.BLOCK_NETHERRACK.func_176223_P().func_177226_a(BlockNetherrack.TYPE, (Comparable)((Object)BlockNetherrack.EnumType.LIVELY));
    }
}

