/*
 * Decompiled with CFR 0.152.
 */
package nex.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nex.block.BlockIchor;
import nex.block.BlockNetherEx;
import nex.handler.ConfigHandler;
import nex.init.NetherExBlocks;

public class BlockTilledSoulSand
extends BlockNetherEx {
    public static final PropertyInteger MOISTURE = PropertyInteger.func_177719_a((String)"moisture", (int)0, (int)7);
    private static final AxisAlignedBB FARMLAND_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.9375, 1.0);

    public BlockTilledSoulSand() {
        super("block_sand_soul_tilled", Material.field_151578_c);
        this.func_149672_a(SoundType.field_185855_h);
        this.func_149713_g(255);
        this.func_149711_c(0.6f);
        this.func_149675_a(true);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return FARMLAND_AABB;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        int moisture = (Integer)state.func_177229_b((IProperty)MOISTURE);
        if (!this.hasFluid(world, pos)) {
            if (moisture > 0) {
                world.func_180501_a(pos, state.func_177226_a((IProperty)MOISTURE, (Comparable)Integer.valueOf(moisture - 1)), 2);
            } else if (!this.hasCrops(world, pos)) {
                this.turnToSoulSand(world, pos);
            }
        } else if (moisture < 7) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)MOISTURE, (Comparable)Integer.valueOf(7)), 2);
        } else if (moisture == 7) {
            world.func_175684_a(pos.func_177984_a(), world.func_180495_p(pos.func_177984_a()).func_177230_c(), 600);
            world.func_175684_a(pos, (Block)this, 600);
        }
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        return plantable.getPlantType(world, pos.func_177972_a(direction)) == EnumPlantType.Nether;
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float fallDistance) {
        if (!world.field_72995_K && entity.canTrample(world, (Block)this, pos, fallDistance)) {
            this.turnToSoulSand(world, pos);
        }
        super.func_180658_a(world, pos, entity, fallDistance);
    }

    private void turnToSoulSand(World world, BlockPos pos) {
        world.func_175656_a(pos, Blocks.field_150425_aM.func_176223_P());
        AxisAlignedBB boundingBox = Blocks.field_150425_aM.func_176223_P().func_185890_d((IBlockAccess)world, pos).func_186670_a(pos);
        for (Entity entity : world.func_72839_b(null, boundingBox)) {
            entity.func_70107_b(entity.field_70165_t, boundingBox.field_72337_e, entity.field_70161_v);
        }
    }

    private boolean hasCrops(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos.func_177984_a()).func_177230_c();
        return block instanceof IPlantable && this.canSustainPlant(world.func_180495_p(pos), (IBlockAccess)world, pos, EnumFacing.UP, (IPlantable)block);
    }

    private boolean hasFluid(World world, BlockPos pos) {
        BlockIchor block = ConfigHandler.block.soulSand.doesRequireIchor ? NetherExBlocks.FLUID_ICHOR : Blocks.field_150353_l;
        for (BlockPos.MutableBlockPos mutablePos : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-4, 0, -4), (BlockPos)pos.func_177982_a(4, 1, 4))) {
            if (world.func_180495_p((BlockPos)mutablePos).func_177230_c() != block) continue;
            return true;
        }
        return false;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        super.func_189540_a(state, world, pos, block, fromPos);
        if (world.func_180495_p(pos.func_177984_a()).func_185904_a().func_76220_a()) {
            this.turnToSoulSand(world, pos);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        switch (side) {
            case UP: {
                return true;
            }
            case NORTH: 
            case SOUTH: 
            case WEST: 
            case EAST: {
                IBlockState testState = blockAccess.func_180495_p(pos.func_177972_a(side));
                Block block = testState.func_177230_c();
                return !testState.func_185914_p() && block != Blocks.field_150458_ak && block != Blocks.field_185774_da && block != NetherExBlocks.BLOCK_SAND_SOUL_TILLED;
            }
        }
        return super.func_176225_a(state, blockAccess, pos, side);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)Blocks.field_150425_aM);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)MOISTURE, (Comparable)Integer.valueOf(meta & 7));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)MOISTURE);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{MOISTURE});
    }
}

