/*
 * Decompiled with CFR 0.152.
 */
package nex.entity.monster;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.World;
import nex.entity.monster.EntitySporeCreeper;
import nex.handler.ConfigHandler;
import nex.init.NetherExItems;
import nex.init.NetherExLootTables;
import nex.init.NetherExSoundEvents;

public class EntitySpore
extends EntityMob {
    private static final DataParameter<Integer> STAGE = EntityDataManager.func_187226_a(EntitySpore.class, (DataSerializer)DataSerializers.field_187192_b);
    private int counter;

    public EntitySpore(World world) {
        super(world);
        this.setRandomStage();
        this.field_70178_ae = true;
    }

    public EntitySpore(World world, int stage) {
        this(world);
        this.setStage(stage);
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return NetherExSoundEvents.ENTITY_HURT_SPORE;
    }

    protected SoundEvent func_184615_bR() {
        return NetherExSoundEvents.ENTITY_DEATH_SPORE;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STAGE, (Object)0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.updateSize();
        if (this.getStage() < 4) {
            this.setCounter(this.getCounter() + 1);
            if (this.getCounter() >= ConfigHandler.entity.spore.growthTime / (this.getStage() + 1) * 20) {
                this.setCounter(0);
                this.setStage(this.getStage() + 1);
            }
        } else if (this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_174813_aQ().func_72321_a(2.0, 2.0, 2.0)).size() > 0) {
            this.func_70106_y();
            if (!this.field_70170_p.field_72995_K) {
                int creeperSpawns = this.field_70146_Z.nextInt(ConfigHandler.entity.spore.creeperSpawns) + 1;
                for (int i = 0; i < creeperSpawns; ++i) {
                    EntitySporeCreeper creeper = new EntitySporeCreeper(this.field_70170_p);
                    creeper.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                    this.field_70170_p.func_72838_d((Entity)creeper);
                }
            }
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Counter", this.getCounter());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setCounter(compound.func_74762_e("Counter"));
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76346_g() != null && source.func_76346_g() instanceof EntityLivingBase && ((EntityLivingBase)source.func_76346_g()).func_184614_ca().func_77973_b() == NetherExItems.TOOL_SWORD_BONE) {
            amount *= 2.0f;
        }
        return super.func_70097_a(source, amount);
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected ResourceLocation func_184647_J() {
        return NetherExLootTables.ENTITY_SPORE;
    }

    public int getStage() {
        return (Integer)this.field_70180_af.func_187225_a(STAGE);
    }

    private int getCounter() {
        return this.counter;
    }

    private void setRandomStage() {
        WeightedRandom.Item one = new WeightedRandom.Item(10);
        WeightedRandom.Item two = new WeightedRandom.Item(8);
        WeightedRandom.Item three = new WeightedRandom.Item(6);
        WeightedRandom.Item four = new WeightedRandom.Item(4);
        WeightedRandom.Item five = new WeightedRandom.Item(2);
        WeightedRandom.Item stage = WeightedRandom.func_76271_a((Random)this.field_70146_Z, (List)Lists.newArrayList((Object[])new WeightedRandom.Item[]{one, two, three, four, five}));
        this.setStage(stage == one ? 0 : (stage == two ? 1 : (stage == three ? 2 : (stage == four ? 3 : 4))));
    }

    private void setStage(int stage) {
        if (stage < 0) {
            stage = 0;
        } else if (stage > 4) {
            stage = 4;
        }
        this.field_70180_af.func_187227_b(STAGE, (Object)stage);
    }

    private void setCounter(int i) {
        this.counter = i;
    }

    private void updateSize() {
        if (this.getStage() == 0 || this.getStage() == 1 && (this.field_70130_N != 0.65f || this.field_70131_O != 0.75f)) {
            this.func_70105_a(0.65f, 0.75f);
        } else if (this.getStage() == 2 && (this.field_70130_N != 0.78f || this.field_70131_O != 0.88f)) {
            this.func_70105_a(0.78f, 0.88f);
        } else if (this.getStage() == 3 || this.getStage() == 4 && (this.field_70130_N != 0.8f || this.field_70131_O != 1.48f)) {
            this.func_70105_a(0.8f, 1.48f);
        }
    }
}

