/*
 * Decompiled with CFR 0.152.
 */
package nex.entity.passive;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.INpc;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nex.entity.ai.EntityAIMoveInFenceGates;
import nex.entity.ai.EntityAIPigtificateFollowGoldGolem;
import nex.entity.ai.EntityAIPigtificateInteract;
import nex.entity.ai.EntityAIPigtificateLookAtTradePlayer;
import nex.entity.ai.EntityAIPigtificateMate;
import nex.entity.ai.EntityAIPigtificatePlay;
import nex.entity.ai.EntityAIPigtificateTradePlayer;
import nex.entity.ai.EntityAIRestrictFenceGateUse;
import nex.entity.ai.EntityAIUseFenceGate;
import nex.init.NetherExBlocks;
import nex.init.NetherExItems;
import nex.init.NetherExSoundEvents;
import nex.village.PigtificateVillage;
import nex.village.PigtificateVillageManager;
import nex.village.Trade;
import nex.village.TradeManager;

public class EntityPigtificate
extends EntityAgeable
implements INpc,
IMerchant {
    private static final DataParameter<Integer> CAREER = EntityDataManager.func_187226_a(EntityPigtificate.class, (DataSerializer)DataSerializers.field_187192_b);
    private int profession;
    private int careerLevel;
    private int randomTickDivider;
    PigtificateVillage village;
    private boolean needsInitialization;
    private boolean willingToMate;
    private boolean mating;
    private boolean playing;
    private boolean additionalTasksSet;
    private boolean lookingForHome;
    private int timeUntilRestock;
    private EntityPlayer customer;
    private MerchantRecipeList tradeList;
    private UUID lastCustomer;
    private final InventoryBasic inventory = new InventoryBasic("Items", false, 8);

    public EntityPigtificate(World world) {
        super(world);
        this.field_70178_ae = true;
        ((PathNavigateGround)this.func_70661_as()).func_179688_b(true);
        this.func_98053_h(true);
        this.func_70105_a(0.6f, 1.95f);
        this.setRandomProfession();
    }

    protected SoundEvent func_184639_G() {
        return NetherExSoundEvents.ENTITY_AMBIENT_PIGTIFICATE;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return NetherExSoundEvents.ENTITY_HURT_PIGTIFICATE;
    }

    protected SoundEvent func_184615_bR() {
        return NetherExSoundEvents.ENTITY_DEATH_PIGTIFICATE;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 12) {
            this.spawnParticles(EnumParticleTypes.HEART);
        } else if (id == 13) {
            this.spawnParticles(EnumParticleTypes.VILLAGER_ANGRY);
        } else if (id == 14) {
            this.spawnParticles(EnumParticleTypes.VILLAGER_HAPPY);
        } else {
            super.func_70103_a(id);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles(EnumParticleTypes particleType) {
        for (int i = 0; i < 5; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_175688_a(particleType, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 1.0 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
        }
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityZombie.class, 8.0f, 0.6, 0.6));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPigtificateTradePlayer(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPigtificateLookAtTradePlayer(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveInFenceGates((EntityCreature)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIRestrictFenceGateUse((EntityCreature)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIUseFenceGate((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIPigtificateMate(this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIPigtificateFollowGoldGolem(this));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIPigtificateInteract(this));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CAREER, (Object)0);
    }

    public float func_70047_e() {
        return this.func_70631_g_() ? 0.81f : 1.62f;
    }

    protected void func_70619_bc() {
        if (this.randomTickDivider-- <= 0) {
            BlockPos blockpos = new BlockPos((Entity)this);
            PigtificateVillageManager.getPigtificateVillages(this.func_190670_t_()).addToVillagerPositionList(blockpos);
            this.randomTickDivider = 70 + this.field_70146_Z.nextInt(50);
            this.village = PigtificateVillageManager.getPigtificateVillages(this.func_190670_t_()).getNearestVillage(blockpos, 32);
            if (this.village == null) {
                this.func_110177_bN();
            } else {
                BlockPos blockpos1 = this.village.getCenter();
                this.func_175449_a(blockpos1, this.village.getVillageRadius());
                if (this.lookingForHome) {
                    this.lookingForHome = false;
                    this.village.setDefaultPlayerReputation(5);
                }
            }
        }
        if (!this.isTrading() && this.timeUntilRestock > 0) {
            --this.timeUntilRestock;
            if (this.timeUntilRestock <= 0) {
                if (this.needsInitialization) {
                    for (MerchantRecipe merchantrecipe : this.tradeList) {
                        if (!merchantrecipe.func_82784_g()) continue;
                        merchantrecipe.func_82783_a(this.field_70146_Z.nextInt(6) + this.field_70146_Z.nextInt(6) + 2);
                    }
                    this.populateTradeList();
                    this.needsInitialization = false;
                    if (this.village != null && this.lastCustomer != null) {
                        this.field_70170_p.func_72960_a((Entity)this, (byte)14);
                        this.village.modifyPlayerReputation(this.lastCustomer, 1);
                    }
                }
                this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 200, 0));
            }
        }
        super.func_70619_bc();
    }

    protected void func_175445_a(EntityItem itemEntity) {
        ItemStack stack = itemEntity.func_92059_d();
        Item item = stack.func_77973_b();
        if (this.canPickupItem(item)) {
            ItemStack stack1 = this.inventory.func_174894_a(stack);
            if (stack1.func_190926_b()) {
                itemEntity.func_70106_y();
            } else {
                stack.func_190920_e(stack1.func_190916_E());
            }
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Profession", this.getProfession());
        compound.func_74768_a("Career", this.getCareer());
        compound.func_74768_a("CareerLevel", this.getCareerLevel());
        compound.func_74757_a("Willing", this.willingToMate);
        if (this.tradeList != null) {
            compound.func_74782_a("Trades", (NBTBase)this.tradeList.func_77202_a());
        }
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            ItemStack stack = this.inventory.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            list.func_74742_a((NBTBase)stack.func_77955_b(new NBTTagCompound()));
        }
        compound.func_74782_a("Inventory", (NBTBase)list);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setProfession(compound.func_74762_e("Profession"));
        this.setCareer(compound.func_74762_e("Career"));
        this.setCareerLevel(compound.func_74762_e("CareerLevel"));
        this.setWillingToMate(compound.func_74767_n("Willing"));
        if (compound.func_150297_b("Trades", 10)) {
            NBTTagCompound trades = compound.func_74775_l("Trades");
            this.tradeList = new MerchantRecipeList(trades);
        }
        NBTTagList list = compound.func_150295_c("Inventory", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            ItemStack stack = new ItemStack(list.func_150305_b(i));
            if (stack.func_190926_b()) continue;
            this.inventory.func_174894_a(stack);
        }
        this.func_98053_h(true);
        this.setAdditionalAITasks();
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() == Items.field_151057_cb) {
            stack.func_111282_a(player, (EntityLivingBase)this, hand);
            return true;
        }
        if (!this.func_190669_a(stack, ((Object)((Object)this)).getClass()) && this.func_70089_S() && !this.isTrading() && !this.func_70631_g_()) {
            if (this.tradeList == null) {
                this.populateTradeList();
            }
            if (!this.field_70170_p.field_72995_K && !this.tradeList.isEmpty()) {
                this.func_70932_a_(player);
                player.func_180472_a((IMerchant)this);
            } else if (this.tradeList.isEmpty()) {
                return super.func_184645_a(player, hand);
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        EntityPigtificate pigtificate = new EntityPigtificate(this.field_70170_p);
        pigtificate.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)pigtificate)), null);
        return pigtificate;
    }

    public void func_70604_c(EntityLivingBase livingBase) {
        super.func_70604_c(livingBase);
        if (this.village != null && livingBase != null) {
            this.village.addOrRenewAggressor(livingBase);
            if (livingBase instanceof EntityPlayer) {
                int i = -1;
                if (this.func_70631_g_()) {
                    i = -3;
                }
                this.village.modifyPlayerReputation(livingBase.func_110124_au(), i);
                if (this.func_70089_S()) {
                    this.field_70170_p.func_72960_a((Entity)this, (byte)13);
                }
            }
        }
    }

    public void func_70645_a(DamageSource cause) {
        if (this.village != null) {
            Entity entity = cause.func_76346_g();
            if (entity != null) {
                if (entity instanceof EntityPlayer) {
                    this.village.modifyPlayerReputation(entity.func_110124_au(), -2);
                } else if (entity instanceof IMob) {
                    this.village.endMatingSeason();
                }
            } else {
                EntityPlayer entityplayer = this.field_70170_p.func_72890_a((Entity)this, 16.0);
                if (entityplayer != null) {
                    this.village.endMatingSeason();
                }
            }
        }
        super.func_70645_a(cause);
    }

    public boolean func_184652_a(EntityPlayer player) {
        return false;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public boolean func_174820_d(int inventorySlot, ItemStack stack) {
        if (super.func_174820_d(inventorySlot, stack)) {
            return true;
        }
        int i = inventorySlot - 300;
        if (i >= 0 && i < this.inventory.func_70302_i_()) {
            this.inventory.func_70299_a(i, stack);
            return true;
        }
        return false;
    }

    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        String entityName = EntityList.func_75621_b((Entity)this);
        return I18n.func_74838_a((String)("entity." + entityName + "." + Trade.Career.EnumType.fromIndex(this.getCareer()).name().toLowerCase() + ".name"));
    }

    protected ResourceLocation func_184647_J() {
        return Trade.Career.EnumType.fromIndex(this.getCareer()).getLootTable();
    }

    public void func_70932_a_(EntityPlayer player) {
        this.customer = player;
    }

    public EntityPlayer func_70931_l_() {
        return this.customer;
    }

    public MerchantRecipeList func_70934_b(EntityPlayer player) {
        if (this.tradeList == null) {
            this.populateTradeList();
        }
        return this.tradeList;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70930_a(MerchantRecipeList tradeList) {
    }

    public void func_70933_a(MerchantRecipe recipe) {
        recipe.func_77399_f();
        this.field_70757_a = -this.func_70627_aG();
        int i = 3 + this.field_70146_Z.nextInt(4);
        if (recipe.func_180321_e() == 1 || this.field_70146_Z.nextInt(5) == 0) {
            this.timeUntilRestock = 40;
            this.needsInitialization = true;
            this.willingToMate = true;
            this.lastCustomer = this.func_70931_l_() != null ? this.func_70931_l_().func_110124_au() : null;
            i += 5;
        }
        if (recipe.func_180322_j()) {
            this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, i));
        }
    }

    public void func_110297_a_(ItemStack stack) {
    }

    public World func_190670_t_() {
        return this.field_70170_p;
    }

    public BlockPos func_190671_u_() {
        return new BlockPos((Entity)this);
    }

    private void populateTradeList() {
        List<Trade> trades;
        if (this.getCareerLevel() != 0) {
            this.setCareerLevel(this.getCareerLevel() + 1);
        } else {
            this.setCareerLevel(1);
        }
        if (this.tradeList == null) {
            this.tradeList = new MerchantRecipeList();
        }
        if ((trades = TradeManager.getTrades(Trade.Career.EnumType.fromIndex(this.getCareer()), this.getCareerLevel())).size() > 0) {
            Collections.shuffle(trades, this.field_70146_Z);
            if (this.getCareerLevel() == 1 && trades.size() > 1) {
                for (Trade trade : trades.subList(0, 2)) {
                    this.tradeList.add((Object)trade.getRandomTrade(this.field_70146_Z));
                }
            } else {
                this.tradeList.add((Object)trades.get(0).getRandomTrade(this.field_70146_Z));
            }
        }
    }

    public boolean isTrading() {
        return this.customer != null;
    }

    public boolean isMating() {
        return this.mating;
    }

    private boolean canPickupItem(Item itemIn) {
        return itemIn == Item.func_150898_a((Block)NetherExBlocks.PLANT_MUSHROOM_ELDER) || itemIn == NetherExItems.FOOD_MUSHROOM_ENOKI;
    }

    private boolean hasEnoughItems(int multiplier) {
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            ItemStack stack = this.inventory.func_70301_a(i);
            if (stack.func_190926_b() || (stack.func_77973_b() != Item.func_150898_a((Block)NetherExBlocks.PLANT_MUSHROOM_ELDER) || stack.func_190916_E() < 4 * multiplier) && (stack.func_77973_b() != NetherExItems.FOOD_MUSHROOM_ENOKI || stack.func_190916_E() < 32 * multiplier)) continue;
            return true;
        }
        return false;
    }

    public boolean canAbandonItems() {
        return this.hasEnoughItems(2);
    }

    public boolean wantsMoreFood() {
        boolean flag;
        boolean bl = flag = this.getProfession() == 0;
        return flag ? !this.hasEnoughItems(5) : !this.hasEnoughItems(1);
    }

    public int getProfession() {
        return this.profession;
    }

    public int getCareer() {
        return (Integer)this.field_70180_af.func_187225_a(CAREER);
    }

    public int getCareerLevel() {
        return this.careerLevel;
    }

    public boolean getWillingToMate(boolean updateFirst) {
        if (!this.willingToMate && updateFirst && this.hasEnoughItems(1)) {
            boolean flag = false;
            for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
                ItemStack stack = this.inventory.func_70301_a(i);
                if (!stack.func_190926_b()) {
                    if (stack.func_77973_b() == Item.func_150898_a((Block)NetherExBlocks.PLANT_MUSHROOM_ELDER) && stack.func_190916_E() >= 4) {
                        flag = true;
                        this.inventory.func_70298_a(i, 3);
                    } else if (stack.func_77973_b() == NetherExItems.FOOD_MUSHROOM_ENOKI && stack.func_190916_E() >= 24) {
                        flag = true;
                        this.inventory.func_70298_a(i, 12);
                    }
                }
                if (!flag) continue;
                this.field_70170_p.func_72960_a((Entity)this, (byte)18);
                this.willingToMate = true;
                break;
            }
        }
        return this.willingToMate;
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public InventoryBasic getInventory() {
        return this.inventory;
    }

    protected void setRandomProfession() {
        this.setProfession(Trade.Profession.EnumType.getRandom(this.field_70146_Z, false).ordinal());
        this.setRandomCareer();
    }

    protected void setRandomCareer() {
        ArrayList careers = Lists.newArrayList();
        for (Trade.Career.EnumType type : Trade.Career.EnumType.values()) {
            if (type.getProfession() != Trade.Profession.EnumType.fromIndex(this.getProfession())) continue;
            careers.add(new Trade.Career.Weighted(type));
        }
        Trade.Career.Weighted career = (Trade.Career.Weighted)WeightedRandom.func_76271_a((Random)this.field_70146_Z, (List)careers);
        this.setCareer(career.getType().ordinal());
    }

    public void setProfession(int i) {
        if (i < 0) {
            i = 0;
        } else if (i > Trade.Profession.EnumType.values().length) {
            i = Trade.Profession.EnumType.values().length;
        }
        this.profession = i;
    }

    public void setCareer(int i) {
        if (i < 0) {
            i = 0;
        }
        this.field_70180_af.func_187227_b(CAREER, (Object)i);
    }

    public void setCareerLevel(int i) {
        if (i < 0) {
            i = 0;
        }
        this.careerLevel = i;
    }

    private void setAdditionalAITasks() {
        if (!this.additionalTasksSet) {
            this.additionalTasksSet = true;
            if (this.func_70631_g_()) {
                this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIPigtificatePlay(this, 0.32));
            }
        }
    }

    public void setWillingToMate(boolean willingToMateIn) {
        this.willingToMate = willingToMateIn;
    }

    public void setMating(boolean matingIn) {
        this.mating = matingIn;
    }

    public void setPlaying(boolean playingIn) {
        this.playing = playingIn;
    }
}

