/*
 * Decompiled with CFR 0.152.
 */
package nex.init;

import com.google.common.base.CaseFormat;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import nex.NetherEx;
import nex.entity.boss.EntityGhastQueen;
import nex.entity.item.EntityObsidianBoat;
import nex.entity.monster.EntityBoneSpider;
import nex.entity.monster.EntityBrute;
import nex.entity.monster.EntityEmber;
import nex.entity.monster.EntityGhastling;
import nex.entity.monster.EntityNethermite;
import nex.entity.monster.EntitySpinout;
import nex.entity.monster.EntitySpore;
import nex.entity.monster.EntitySporeCreeper;
import nex.entity.monster.EntityWight;
import nex.entity.neutral.EntityGoldGolem;
import nex.entity.neutral.EntityMogus;
import nex.entity.neutral.EntitySalamander;
import nex.entity.passive.EntityPigtificate;
import nex.entity.passive.EntityPigtificateLeader;
import nex.entity.projectile.EntityGhastQueenFireball;
import nex.entity.projectile.EntityGhastlingFireball;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NetherExEntities {
    private static int entityId = -1;
    private static final Logger LOGGER = LogManager.getLogger((String)"NetherEx|NetherExEntities");

    public static void init() {
        LOGGER.info("Entity registration started.");
        NetherExEntities.registerEntity("projectile_ghast_queen_fireball", EntityGhastQueenFireball.class, entityId++);
        NetherExEntities.registerEntity("projectile_ghastling_fireball", EntityGhastlingFireball.class, entityId++);
        NetherExEntities.registerEntity("item_boat_obsidian", EntityObsidianBoat.class, entityId++);
        NetherExEntities.registerEntity("passive_pigtificate_leader", EntityPigtificateLeader.class, entityId++, 12422002, 15771042);
        NetherExEntities.registerEntity("passive_pigtificate", EntityPigtificate.class, entityId++, 15771042, 12422002);
        NetherExEntities.registerEntity("neutral_gold_golem", EntityGoldGolem.class, entityId++, 16773448, 14520344);
        NetherExEntities.registerEntity("neutral_mogus", EntityMogus.class, entityId++, 6770482, 5114119);
        NetherExEntities.registerEntity("neutral_salamander", EntitySalamander.class, entityId++, 15949838, 394758);
        NetherExEntities.registerEntity("monster_wight", EntityWight.class, entityId++, 0xF9F9F9, 9484735);
        NetherExEntities.registerEntity("monster_ember", EntityEmber.class, entityId++, 0xFF0000, 16762880);
        NetherExEntities.registerEntity("monster_nethermite", EntityNethermite.class, entityId++, 3344642, 8992279);
        NetherExEntities.registerEntity("monster_spinout", EntitySpinout.class, entityId++, 3279879, 0xEFEFEF);
        NetherExEntities.registerEntity("monster_spore_creeper", EntitySporeCreeper.class, entityId++, 0x551616, 15721297);
        NetherExEntities.registerEntity("monster_spore", EntitySpore.class, entityId++, 15721297, 0x551616);
        NetherExEntities.registerEntity("monster_ghastling", EntityGhastling.class, entityId++, 16447992, 14077883);
        NetherExEntities.registerEntity("monster_bone_spider", EntityBoneSpider.class, entityId++, 13750221, 0xCC0000);
        NetherExEntities.registerEntity("monster_brute", EntityBrute.class, entityId++, 11045525, 4793626);
        NetherExEntities.registerEntity("boss_ghast_queen", EntityGhastQueen.class, entityId++, 0xF0F0F0, 13546448);
        LOGGER.info("Entity registration Ended.");
    }

    private static void registerEntity(String name, Class<? extends Entity> cls, int id) {
        ResourceLocation registryName = new ResourceLocation("nex:" + name);
        EntityRegistry.registerModEntity((ResourceLocation)registryName, cls, (String)CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, registryName.toString()), (int)id, (Object)NetherEx.instance, (int)64, (int)1, (boolean)true);
    }

    private static void registerEntity(String name, Class<? extends Entity> cls, int id, int primaryEggColor, int secondaryEggColor) {
        ResourceLocation registryName = new ResourceLocation("nex:" + name);
        EntityRegistry.registerModEntity((ResourceLocation)registryName, cls, (String)CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, registryName.toString()), (int)id, (Object)NetherEx.instance, (int)64, (int)1, (boolean)true, (int)primaryEggColor, (int)secondaryEggColor);
    }
}

