/*
 * Decompiled with CFR 0.152.
 */
package nex.init;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import nex.block.BlockBasalt;
import nex.block.BlockNetherrack;
import nex.init.NetherExBlocks;
import nex.init.NetherExItems;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NetherExOreDict {
    private static final Logger LOGGER = LogManager.getLogger((String)"NetherEx|NetherExOreDict");

    public static void init() {
        LOGGER.info("Ore Dictionary registration started.");
        for (BlockBasalt.EnumType enumType : BlockBasalt.EnumType.values()) {
            NetherExOreDict.addOreDictEntry("stoneBasalt", new ItemStack((Block)NetherExBlocks.BLOCK_BASALT, 1, enumType.ordinal()));
            if (enumType.ordinal() == 1) {
                NetherExOreDict.addOreDictEntry("stoneBasaltPolished", new ItemStack((Block)NetherExBlocks.BLOCK_BASALT, 1, enumType.ordinal()));
                continue;
            }
            if (enumType.ordinal() != 2 && enumType.ordinal() != 3) continue;
            NetherExOreDict.addOreDictEntry("stoneBasaltBrick", new ItemStack((Block)NetherExBlocks.BLOCK_BASALT, 1, enumType.ordinal()));
        }
        NetherExOreDict.addOreDictEntry("blockGlass", new ItemStack((Block)NetherExBlocks.BLOCK_GLASS_SOUL, 1, 0));
        NetherExOreDict.addOreDictEntry("paneGlass", new ItemStack((Block)NetherExBlocks.BLOCK_GLASS_PANE_SOUL, 1, 0));
        for (Enum enum_ : BlockNetherrack.EnumType.values()) {
            NetherExOreDict.addOreDictEntry("netherrack", new ItemStack((Block)NetherExBlocks.BLOCK_NETHERRACK, 1, enum_.ordinal()));
            NetherExOreDict.addOreDictEntry("ingotBrickNether", new ItemStack((Item)NetherExItems.ITEM_BRICK_NETHER, 1, enum_.ordinal()));
            NetherExOreDict.addOreDictEntry("oreQuartz", new ItemStack((Block)NetherExBlocks.ORE_QUARTZ, 1, enum_.ordinal()));
        }
        NetherExOreDict.addOreDictEntry("oreAmethyst", new ItemStack((Block)NetherExBlocks.ORE_AMETHYST, 1, 0));
        NetherExOreDict.addOreDictEntry("blockAmethyst", new ItemStack((Block)NetherExBlocks.BLOCK_AMETHYST, 1, 0));
        NetherExOreDict.addOreDictEntry("gemAmethyst", new ItemStack((Item)NetherExItems.ITEM_CRYSTAL_AMETHYST, 1, 0));
        NetherExOreDict.addOreDictEntry("oreRime", new ItemStack((Block)NetherExBlocks.ORE_RIME, 1, 0));
        NetherExOreDict.addOreDictEntry("blockRime", new ItemStack((Block)NetherExBlocks.BLOCK_RIME, 1, 0));
        NetherExOreDict.addOreDictEntry("gemRime", new ItemStack((Item)NetherExItems.ITEM_CRYSTAL_RIME, 1, 0));
        NetherExOreDict.addOreDictEntry("dyeBlack", new ItemStack((Item)NetherExItems.ITEM_DUST_WITHER, 1, 0));
        LOGGER.info("Ore Dictionary registration completed.");
    }

    private static void addOreDictEntry(String name, ItemStack stack) {
        OreDictionary.registerOre((String)name, (ItemStack)stack);
    }
}

