/*
 * Decompiled with CFR 0.152.
 */
package nex.tileentity;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityInventory
extends TileEntity {
    private ItemStackHandler inventory;
    private Random rand;

    public TileEntityInventory(int size) {
        this.inventory = new ItemStackHandler(size);
        this.rand = new Random();
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("Inventory", (NBTBase)this.inventory.serializeNBT());
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.inventory.deserializeNBT(compound.func_74775_l("Inventory"));
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound compound = new NBTTagCompound();
        this.func_189515_b(compound);
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, compound);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this.inventory : null);
    }

    public void dropInventoryItems(World world, BlockPos pos) {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            this.spawnItemStack(world, pos, stack);
        }
    }

    public void spawnItemStack(World world, BlockPos pos, ItemStack stack) {
        double offsetX = this.rand.nextFloat() * 0.8f + 0.1f;
        double offsetY = this.rand.nextFloat() * 0.8f + 0.1f;
        double offsetZ = this.rand.nextFloat() * 0.8f + 0.1f;
        while (!stack.func_190926_b()) {
            EntityItem entityItem = new EntityItem(world, (double)pos.func_177958_n() + offsetX, (double)pos.func_177956_o() + offsetY, (double)pos.func_177952_p() + offsetZ, stack.func_77979_a(this.rand.nextInt(21) + 10));
            entityItem.field_70159_w = this.rand.nextGaussian() * (double)0.05f;
            entityItem.field_70181_x = this.rand.nextGaussian() * (double)0.05f + (double)0.2f;
            entityItem.field_70179_y = this.rand.nextGaussian() * (double)0.05f;
            world.func_72838_d((Entity)entityItem);
        }
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public Random getRand() {
        return this.rand;
    }
}

