/*
 * Decompiled with CFR 0.152.
 */
package nex.util;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class RecipeUtil {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static File RECIPE_DIR = null;
    private static final Set<String> USED_ORE_DICTIONARY_NAMES = new TreeSet<String>();
    private static final Set<String> USED_REGISTRY_NAMES = new TreeSet<String>();

    public static void setupDir(File file) {
        if (RECIPE_DIR == null) {
            RECIPE_DIR = file;
        }
        if (!RECIPE_DIR.exists()) {
            RECIPE_DIR.mkdir();
        }
    }

    private static void addShaped(ItemStack result, Object ... components) {
        int i;
        LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
        ArrayList<String> pattern = new ArrayList<String>();
        for (i = 0; i < components.length && components[i] instanceof String; ++i) {
            pattern.add((String)components[i]);
        }
        boolean isOreDict = false;
        HashMap<String, Map<String, Object>> key = new HashMap<String, Map<String, Object>>();
        Character curKey = null;
        while (i < components.length) {
            Object o = components[i];
            if (o instanceof Character) {
                if (curKey != null) {
                    throw new IllegalArgumentException("Provided two char keys in a row");
                }
                curKey = (Character)o;
            } else {
                if (curKey == null) {
                    throw new IllegalArgumentException("Providing object without a char key");
                }
                if (o instanceof String) {
                    isOreDict = true;
                }
                key.put(Character.toString(curKey.charValue()), RecipeUtil.serializeItem(o));
                curKey = null;
            }
            ++i;
        }
        json.put("type", isOreDict ? "forge:ore_shaped" : "minecraft:crafting_shaped");
        json.put("pattern", pattern);
        json.put("key", key);
        json.put("result", RecipeUtil.serializeItem(result));
        String registryName = result.func_77973_b().getRegistryName().func_110623_a() + "_" + result.func_77952_i();
        File f = new File(RECIPE_DIR, registryName + ".json");
        while (f.exists()) {
            registryName = RecipeUtil.findSuitableName(registryName);
            f = new File(RECIPE_DIR, registryName + ".json");
        }
        try (FileWriter w = new FileWriter(f);){
            GSON.toJson(json, (Appendable)w);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        USED_REGISTRY_NAMES.add(registryName);
    }

    private static void addShapeless(ItemStack result, Object ... components) {
        LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
        boolean isOreDict = false;
        ArrayList<Map<String, Object>> ingredients = new ArrayList<Map<String, Object>>();
        for (Object o : components) {
            if (o instanceof String) {
                isOreDict = true;
            }
            ingredients.add(RecipeUtil.serializeItem(o));
        }
        json.put("type", isOreDict ? "forge:ore_shapeless" : "minecraft:crafting_shapeless");
        json.put("ingredients", ingredients);
        json.put("result", RecipeUtil.serializeItem(result));
        String registryName = result.func_77973_b().getRegistryName().func_110623_a() + "_" + result.func_77952_i();
        File f = new File(RECIPE_DIR, registryName + ".json");
        while (f.exists()) {
            registryName = RecipeUtil.findSuitableName(registryName);
            f = new File(RECIPE_DIR, registryName + ".json");
        }
        try (FileWriter w = new FileWriter(f);){
            GSON.toJson(json, (Appendable)w);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        USED_REGISTRY_NAMES.add(registryName);
    }

    private static String findSuitableName(String registryName) {
        if (registryName.contains("nex:")) {
            registryName = registryName.replace("nex:", "");
        }
        if (registryName.contains("minecraft:")) {
            registryName = registryName.replace("minecraft:", "");
        }
        if (USED_REGISTRY_NAMES.contains(registryName)) {
            registryName = registryName + "_alt";
        }
        if (USED_REGISTRY_NAMES.contains(registryName)) {
            registryName = registryName.replace("_alt", "_alt_2");
        }
        if (USED_REGISTRY_NAMES.contains(registryName)) {
            registryName = registryName.replace("_alt_2", "_alt_3");
        }
        if (USED_REGISTRY_NAMES.contains(registryName)) {
            registryName = registryName.replace("_alt_3", "_alt_4");
        }
        if (USED_REGISTRY_NAMES.contains(registryName)) {
            registryName = registryName.replace("_alt_4", "_alt_5");
        }
        if (USED_REGISTRY_NAMES.contains(registryName)) {
            registryName = registryName.replace("_alt_5", "_alt_6");
        }
        if (USED_REGISTRY_NAMES.contains(registryName)) {
            registryName = registryName.replace("_alt_6", "_alt_7");
        }
        if (USED_REGISTRY_NAMES.contains(registryName)) {
            registryName = registryName.replace("_alt_7", "_alt_8");
        }
        if (USED_REGISTRY_NAMES.contains(registryName)) {
            registryName = registryName.replace("_alt_8", "_alt_9");
        }
        if (USED_REGISTRY_NAMES.contains(registryName)) {
            registryName = registryName.replace("_alt_9", "_alt_10");
        }
        return registryName;
    }

    private static Map<String, Object> serializeItem(Object thing) {
        if (thing instanceof Item) {
            return RecipeUtil.serializeItem(new ItemStack((Item)thing));
        }
        if (thing instanceof Block) {
            return RecipeUtil.serializeItem(new ItemStack((Block)thing));
        }
        if (thing instanceof ItemStack) {
            ItemStack stack = (ItemStack)thing;
            HashMap<String, Object> ret = new HashMap<String, Object>();
            ret.put("item", stack.func_77973_b().getRegistryName().toString());
            if (stack.func_77973_b().func_77614_k() || stack.func_77952_i() != 0) {
                ret.put("data", stack.func_77952_i());
            }
            if (stack.func_190916_E() > 1) {
                ret.put("count", stack.func_190916_E());
            }
            if (stack.func_77942_o()) {
                ret.put("nbt", stack.func_77978_p().toString());
            }
            return ret;
        }
        if (thing instanceof String) {
            HashMap<String, Object> ret = new HashMap<String, Object>();
            USED_ORE_DICTIONARY_NAMES.add((String)thing);
            ret.put("item", "#" + ((String)thing).toUpperCase(Locale.ROOT));
            return ret;
        }
        throw new IllegalArgumentException("Not a block, item, stack, or od name");
    }

    private static void generateConstants() {
        ArrayList json = new ArrayList();
        for (String s : USED_ORE_DICTIONARY_NAMES) {
            HashMap<String, String> entry = new HashMap<String, String>();
            entry.put("name", s.toUpperCase(Locale.ROOT));
            entry.put("ingredient", (String)ImmutableMap.of((Object)"type", (Object)"forge:ore_dict", (Object)"ore", (Object)s));
            json.add(entry);
        }
        try (FileWriter w = new FileWriter(new File(RECIPE_DIR, "_constants.json"));){
            GSON.toJson(json, (Appendable)w);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

