/*
 * Decompiled with CFR 0.152.
 */
package nex.village;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.storage.WorldSavedData;
import nex.village.PigtificateVillage;
import nex.village.PigtificateVillageFenceGateInfo;

public class PigtificateVillageCollection
extends WorldSavedData {
    private World world;
    private final List<BlockPos> villagerPositionsList = Lists.newArrayList();
    private final List<PigtificateVillageFenceGateInfo> newFenceGates = Lists.newArrayList();
    private final List<PigtificateVillage> villageList = Lists.newArrayList();
    private int tickCounter;

    public PigtificateVillageCollection(String name) {
        super(name);
    }

    public PigtificateVillageCollection(World worldIn) {
        super(PigtificateVillageCollection.fileNameForProvider(worldIn.field_73011_w));
        this.world = worldIn;
        this.func_76185_a();
    }

    public void setWorldsForAll(World worldIn) {
        this.world = worldIn;
        for (PigtificateVillage village : this.villageList) {
            village.setWorld(worldIn);
        }
    }

    public void addToVillagerPositionList(BlockPos pos) {
        if (this.villagerPositionsList.size() <= 64 && !this.positionInList(pos)) {
            this.villagerPositionsList.add(pos);
        }
    }

    public void tick() {
        ++this.tickCounter;
        for (PigtificateVillage village : this.villageList) {
            village.tick(this.tickCounter);
        }
        this.removeAnnihilatedVillages();
        this.dropOldestVillagerPosition();
        this.addNewFenceGatesToVillageOrCreateVillage();
        if (this.tickCounter % 400 == 0) {
            this.func_76185_a();
        }
    }

    private void removeAnnihilatedVillages() {
        Iterator<PigtificateVillage> iterator = this.villageList.iterator();
        while (iterator.hasNext()) {
            PigtificateVillage village = iterator.next();
            if (!village.isAnnihilated()) continue;
            iterator.remove();
            this.func_76185_a();
        }
    }

    public List<PigtificateVillage> getVillageList() {
        return this.villageList;
    }

    public PigtificateVillage getNearestVillage(BlockPos fenceGateBlock, int radius) {
        PigtificateVillage village = null;
        double d0 = 3.4028234663852886E38;
        for (PigtificateVillage village1 : this.villageList) {
            float f;
            double d1 = village1.getCenter().func_177951_i((Vec3i)fenceGateBlock);
            if (!(d1 < d0) || !(d1 <= (double)((f = (float)(radius + village1.getVillageRadius())) * f))) continue;
            village = village1;
            d0 = d1;
        }
        return village;
    }

    private void dropOldestVillagerPosition() {
        if (!this.villagerPositionsList.isEmpty()) {
            this.addFenceGatesAround(this.villagerPositionsList.remove(0));
        }
    }

    private void addNewFenceGatesToVillageOrCreateVillage() {
        for (PigtificateVillageFenceGateInfo villagefenceGateinfo : this.newFenceGates) {
            PigtificateVillage village = this.getNearestVillage(villagefenceGateinfo.getFenceGateBlockPos(), 32);
            if (village == null) {
                village = new PigtificateVillage(this.world);
                this.villageList.add(village);
                this.func_76185_a();
            }
            village.addVillageFenceGateInfo(villagefenceGateinfo);
        }
        this.newFenceGates.clear();
    }

    private void addFenceGatesAround(BlockPos central) {
        for (int l = -16; l < 16; ++l) {
            for (int i1 = -4; i1 < 4; ++i1) {
                for (int j1 = -16; j1 < 16; ++j1) {
                    BlockPos blockpos = central.func_177982_a(l, i1, j1);
                    EnumFacing outside = this.getOutside(blockpos);
                    if (outside == null) continue;
                    PigtificateVillageFenceGateInfo villagefenceGateinfo = this.checkFenceGateExistence(blockpos);
                    if (villagefenceGateinfo == null) {
                        this.addToNewFenceGatesList(blockpos, outside);
                        continue;
                    }
                    villagefenceGateinfo.setLastActivityTimestamp(this.tickCounter);
                }
            }
        }
    }

    private PigtificateVillageFenceGateInfo checkFenceGateExistence(BlockPos fenceGateBlock) {
        for (PigtificateVillageFenceGateInfo villagefenceGateinfo : this.newFenceGates) {
            if (villagefenceGateinfo.getFenceGateBlockPos().func_177958_n() != fenceGateBlock.func_177958_n() || villagefenceGateinfo.getFenceGateBlockPos().func_177952_p() != fenceGateBlock.func_177952_p() || Math.abs(villagefenceGateinfo.getFenceGateBlockPos().func_177956_o() - fenceGateBlock.func_177956_o()) > 1) continue;
            return villagefenceGateinfo;
        }
        for (PigtificateVillage village : this.villageList) {
            PigtificateVillageFenceGateInfo villagefenceGateinfo1 = village.getExistedFenceGate(fenceGateBlock);
            if (villagefenceGateinfo1 == null) continue;
            return villagefenceGateinfo1;
        }
        return null;
    }

    private void addToNewFenceGatesList(BlockPos fenceGateBlock, EnumFacing facing) {
        this.newFenceGates.add(new PigtificateVillageFenceGateInfo(fenceGateBlock, facing, this.tickCounter));
    }

    private boolean positionInList(BlockPos pos) {
        for (BlockPos blockpos : this.villagerPositionsList) {
            if (!blockpos.equals((Object)pos)) continue;
            return true;
        }
        return false;
    }

    private EnumFacing getOutside(BlockPos fenceGatePos) {
        IBlockState fenceGateState = this.world.func_180495_p(fenceGatePos);
        IBlockState stairState = this.world.func_180495_p(fenceGatePos.func_177981_b(2));
        if (fenceGateState.func_177230_c() instanceof BlockFenceGate && stairState.func_177230_c() instanceof BlockStairs) {
            EnumFacing fenceGateFacing = (EnumFacing)fenceGateState.func_177229_b((IProperty)BlockFenceGate.field_185512_D);
            EnumFacing stairFacing = (EnumFacing)stairState.func_177229_b((IProperty)BlockStairs.field_176309_a);
            if (stairFacing == fenceGateFacing || stairFacing == fenceGateFacing.func_176734_d()) {
                return stairFacing;
            }
            return null;
        }
        return null;
    }

    public void func_76184_a(NBTTagCompound nbt) {
        this.tickCounter = nbt.func_74762_e("Tick");
        NBTTagList nbttaglist = nbt.func_150295_c("NetherVillages", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            PigtificateVillage village = new PigtificateVillage();
            village.readVillageDataFromNBT(nbttagcompound);
            this.villageList.add(village);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        compound.func_74768_a("Tick", this.tickCounter);
        NBTTagList nbttaglist = new NBTTagList();
        for (PigtificateVillage village : this.villageList) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            village.writeVillageDataToNBT(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        compound.func_74782_a("NetherVillages", (NBTBase)nbttaglist);
        return compound;
    }

    public static String fileNameForProvider(WorldProvider provider) {
        return "villages.pigtificate" + provider.func_186058_p().func_186067_c();
    }
}

