/*
 * Decompiled with CFR 0.152.
 */
package nex.village;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import nex.NetherEx;
import nex.util.FileUtil;
import nex.util.NBTUtil;
import nex.village.Trade;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TradeManager {
    private static HashMap<Trade.Career.EnumType, HashMap<Integer, List<Trade>>> offerLists = Maps.newHashMap();
    private static final Logger LOGGER = LogManager.getLogger((String)"NetherEx|TradeManager");

    public static void init(File directory) {
        for (Trade.Career.EnumType career : Trade.Career.EnumType.values()) {
            offerLists.put(career, Maps.newHashMap());
        }
        try {
            if (!directory.exists()) {
                directory.mkdirs();
            }
            LOGGER.info("Copying the Trade. List Directory to the config folder.");
            if (NetherEx.IS_DEV_ENV) {
                FileUtils.copyDirectory((File)new File(NetherEx.class.getResource("/assets/nex/trade_lists").getFile()), (File)directory);
            } else {
                FileUtil.extractFromJar("/assets/nex/trade_lists", directory.getPath());
            }
        }
        catch (IOException e) {
            LOGGER.fatal("The attempt to copy the Trade. List Directory to the config folder was unsuccessful.");
            LOGGER.fatal((Object)e);
        }
        try {
            Gson gson = new Gson();
            ArrayList tradeFiles = Lists.newArrayList((Object[])directory.listFiles());
            for (File tradeFile : tradeFiles) {
                String jsonText = Files.toString((File)tradeFile, (Charset)Charsets.UTF_8);
                Trade.TradeList tradeList = (Trade.TradeList)gson.fromJson(jsonText, Trade.TradeList.class);
                LOGGER.info("Adding trades from the " + tradeList.getName() + ".");
                for (Trade.Profession profession : tradeList.getProfessions()) {
                    for (Trade.Career career : profession.getCareers()) {
                        for (Trade.Offer offer : career.getTrades()) {
                            ItemStack inputStackB;
                            ItemStack inputStackA;
                            ItemStack outputStack;
                            Trade.Offer.Output output = offer.getOutput();
                            String outputId = output.getId();
                            int outputMeta = output.getMeta();
                            ArrayList outputEnchantments = output.getEnchantments();
                            Trade.Offer.Display outputDisplay = output.getDisplay();
                            if (Item.func_111206_d((String)outputId) != null) {
                                outputStack = new ItemStack(Item.func_111206_d((String)outputId), 1, outputMeta);
                            } else {
                                if (Block.func_149684_b((String)outputId) == null) continue;
                                outputStack = new ItemStack(Block.func_149684_b((String)outputId), 1, outputMeta);
                            }
                            if (outputEnchantments == null) {
                                outputEnchantments = Lists.newArrayList();
                            }
                            if (outputDisplay != null) {
                                if (!Strings.isNullOrEmpty((String)outputDisplay.getName())) {
                                    outputStack.func_151001_c(outputDisplay.getName());
                                }
                                if (outputDisplay.getLore().size() > 0) {
                                    NBTUtil.setTag(outputStack);
                                    NBTTagList loreList = new NBTTagList();
                                    for (String lore : outputDisplay.getLore()) {
                                        loreList.func_74742_a((NBTBase)new NBTTagString(lore));
                                    }
                                    NBTTagCompound displayCompound = new NBTTagCompound();
                                    displayCompound.func_74782_a("Lore", (NBTBase)loreList);
                                    NBTTagCompound compound = new NBTTagCompound();
                                    compound.func_74782_a("display", (NBTBase)displayCompound);
                                    NBTUtil.setTag(outputStack, compound);
                                }
                            }
                            Trade.Offer.Input inputA = offer.getInputA();
                            String inputAId = inputA.getId();
                            int inputAMeta = inputA.getMeta();
                            if (Item.func_111206_d((String)inputAId) != null) {
                                inputStackA = new ItemStack(Item.func_111206_d((String)inputAId), 1, inputAMeta);
                            } else {
                                if (Block.func_149684_b((String)inputAId) == null) continue;
                                inputStackA = new ItemStack(Block.func_149684_b((String)inputAId), 1, inputAMeta);
                            }
                            Trade.Offer.Input inputB = offer.getInputB();
                            if (inputB == null) {
                                inputB = new Trade.Offer.Input();
                            }
                            String inputBId = inputB.getId();
                            int inputBMeta = inputB.getMeta();
                            if (Item.func_111206_d((String)inputBId) != null) {
                                inputStackB = new ItemStack(Item.func_111206_d((String)inputBId), 1, inputBMeta);
                            } else {
                                if (Block.func_149684_b((String)inputBId) == null) continue;
                                inputStackB = new ItemStack(Block.func_149684_b((String)inputBId), 1, inputBMeta);
                            }
                            Trade trade = new Trade(outputStack, output.getMinStackSize(), output.getMaxStackSize(), inputStackA, inputA.getMinStackSize(), inputA.getMaxStackSize(), inputStackB, inputB.getMinStackSize(), inputB.getMaxStackSize(), offer.getMinTradesAvailable(), offer.getMaxTradesAvailable(), outputEnchantments);
                            offerLists.get((Object)Trade.Career.EnumType.fromCareer(career)).computeIfAbsent(offer.getLevel(), k -> Lists.newArrayList()).add(trade);
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            LOGGER.fatal("NetherEx was unable to read the Trade. lists.");
            LOGGER.fatal((Object)e);
        }
    }

    public static List<Trade> getTrades(Trade.Career.EnumType type, int level) {
        ArrayList trades = Lists.newArrayList();
        if (offerLists.get((Object)type).containsKey(level)) {
            trades.addAll((Collection)offerLists.get((Object)type).get(level));
        }
        return trades;
    }
}

