/*
 * Decompiled with CFR 0.152.
 */
package nex.world.gen.feature;

import com.google.common.base.Strings;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import nex.world.biome.NetherBiome;

public abstract class Feature {
    private final Biome biome;
    private final int rarity;
    private final int minHeight;
    private final int maxHeight;
    private final boolean randomRarity;
    private final boolean superRare;

    public Feature(Biome biomeIn, NetherBiome.BiomeFeature feature) {
        this.biome = biomeIn;
        this.rarity = feature.getRarity() <= 0 ? 10 : feature.getRarity();
        this.minHeight = feature.getMinHeight() <= 0 || feature.getMinHeight() >= 128 ? 4 : feature.getMinHeight();
        this.maxHeight = feature.getMaxHeight() >= 120 || feature.getMaxHeight() <= 0 ? 108 : feature.getMaxHeight();
        this.randomRarity = feature.useRandomRarity();
        this.superRare = feature.isSuperRare();
    }

    public abstract boolean generate(World var1, BlockPos var2, Random var3);

    public abstract boolean canGenerate();

    public abstract FeatureType getType();

    public Biome getBiome() {
        return this.biome;
    }

    public int getRarity() {
        return this.rarity;
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public boolean useRandomRarity() {
        return this.randomRarity;
    }

    public boolean isSuperRare() {
        return this.superRare;
    }

    public static enum FeatureType {
        SCATTERED,
        CLUMPED,
        ORE,
        FLUID,
        POOL,
        STRUCTURE,
        UNKNOWN;


        public static FeatureType getFromString(String string) {
            if (!Strings.isNullOrEmpty((String)string)) {
                for (FeatureType type : FeatureType.values()) {
                    if (!type.name().equalsIgnoreCase(string)) continue;
                    return type;
                }
            }
            return UNKNOWN;
        }
    }
}

