/*
 * Decompiled with CFR 0.152.
 */
package nex.world.gen.feature;

import java.util.Random;
import net.minecraft.block.BlockBush;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import nex.util.BlockUtil;
import nex.world.biome.NetherBiome;
import nex.world.gen.feature.Feature;

public class FeatureScattered
extends Feature {
    private final IBlockState blockToSpawn;
    private final IBlockState targetBlock;

    public FeatureScattered(Biome biome, NetherBiome.BiomeFeature feature) {
        super(biome, feature);
        this.blockToSpawn = BlockUtil.getBlock(feature.getBlockToSpawn(), "minecraft:air");
        this.targetBlock = BlockUtil.getBlock(feature.getTargetBlock(), "minecraft:air");
    }

    @Override
    public boolean generate(World world, BlockPos pos, Random rand) {
        for (int i = 0; i < 64; ++i) {
            BlockPos newPos = pos.func_177982_a(rand.nextInt(8) - rand.nextInt(8), rand.nextInt(4) - rand.nextInt(4), rand.nextInt(8) - rand.nextInt(8));
            if (!world.func_175623_d(newPos) || world.func_180495_p(newPos.func_177977_b()) != this.targetBlock) continue;
            if (this.blockToSpawn instanceof BlockBush) {
                if (!((BlockBush)this.blockToSpawn).func_180671_f(world, newPos, ((BlockBush)this.blockToSpawn).func_176223_P())) continue;
                world.func_180501_a(newPos, this.blockToSpawn, 2);
                continue;
            }
            world.func_180501_a(newPos, this.blockToSpawn, 2);
        }
        return true;
    }

    @Override
    public boolean canGenerate() {
        return this.blockToSpawn != Blocks.field_150350_a.func_176223_P() && this.targetBlock != Blocks.field_150350_a.func_176223_P();
    }

    @Override
    public Feature.FeatureType getType() {
        return Feature.FeatureType.SCATTERED;
    }
}

