/*
 * Decompiled with CFR 0.152.
 */
package nex.world.gen.feature;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraftforge.common.IPlantable;
import nex.init.NetherExBlocks;
import nex.util.WeightedUtil;

public class WorldGenElderMushroom
extends WorldGenerator {
    private final List<WeightedUtil.NamedItem> variants;
    private final boolean isWorldGen;
    public static List<WeightedUtil.NamedItem> brownVariants = Lists.newArrayList((Object[])new WeightedUtil.NamedItem[]{new WeightedUtil.NamedItem("nex:plant_mushroom_elder_brown_tiny", 6), new WeightedUtil.NamedItem("nex:plant_mushroom_elder_brown_tiny_variant", 6), new WeightedUtil.NamedItem("nex:plant_mushroom_elder_brown_small", 5), new WeightedUtil.NamedItem("nex:plant_mushroom_elder_brown_small_variant", 5), new WeightedUtil.NamedItem("nex:plant_mushroom_elder_brown_medium", 4), new WeightedUtil.NamedItem("nex:plant_mushroom_elder_brown_medium_variant", 4), new WeightedUtil.NamedItem("nex:plant_mushroom_elder_brown_large", 3), new WeightedUtil.NamedItem("nex:plant_mushroom_elder_brown_huge", 2), new WeightedUtil.NamedItem("nex:plant_mushroom_elder_brown_gigantic", 1)});
    public static List<WeightedUtil.NamedItem> redVariants = Lists.newArrayList((Object[])new WeightedUtil.NamedItem[]{new WeightedUtil.NamedItem("nex:plant_mushroom_elder_red_tiny", 6), new WeightedUtil.NamedItem("nex:plant_mushroom_elder_red_tiny_variant", 6), new WeightedUtil.NamedItem("nex:plant_mushroom_elder_red_small", 5), new WeightedUtil.NamedItem("nex:plant_mushroom_elder_red_small_variant", 5), new WeightedUtil.NamedItem("nex:plant_mushroom_elder_red_small_variant_2", 5), new WeightedUtil.NamedItem("nex:plant_mushroom_elder_red_medium", 4), new WeightedUtil.NamedItem("nex:plant_mushroom_elder_red_large", 3), new WeightedUtil.NamedItem("nex:plant_mushroom_elder_red_huge", 2), new WeightedUtil.NamedItem("nex:plant_mushroom_elder_red_gigantic", 1)});
    public static List<WeightedUtil.NamedItem> allVariants = Lists.newArrayList((Object[])new WeightedUtil.NamedItem[]{new WeightedUtil.NamedItem("nex:plant_mushroom_elder_brown_tiny", 6), new WeightedUtil.NamedItem("nex:plant_mushroom_elder_brown_tiny_variant", 6), new WeightedUtil.NamedItem("nex:plant_mushroom_elder_brown_small", 5), new WeightedUtil.NamedItem("nex:plant_mushroom_elder_brown_small_variant", 5), new WeightedUtil.NamedItem("nex:plant_mushroom_elder_brown_medium", 4), new WeightedUtil.NamedItem("nex:plant_mushroom_elder_brown_medium_variant", 4), new WeightedUtil.NamedItem("nex:plant_mushroom_elder_brown_large", 3), new WeightedUtil.NamedItem("nex:plant_mushroom_elder_brown_huge", 2), new WeightedUtil.NamedItem("nex:plant_mushroom_elder_brown_gigantic", 1), new WeightedUtil.NamedItem("nex:plant_mushroom_elder_red_tiny", 6), new WeightedUtil.NamedItem("nex:plant_mushroom_elder_red_tiny_variant", 6), new WeightedUtil.NamedItem("nex:plant_mushroom_elder_red_small", 5), new WeightedUtil.NamedItem("nex:plant_mushroom_elder_red_small_variant", 5), new WeightedUtil.NamedItem("nex:plant_mushroom_elder_red_small_variant_2", 5), new WeightedUtil.NamedItem("nex:plant_mushroom_elder_red_medium", 4), new WeightedUtil.NamedItem("nex:plant_mushroom_elder_red_large", 3), new WeightedUtil.NamedItem("nex:plant_mushroom_elder_red_huge", 2), new WeightedUtil.NamedItem("nex:plant_mushroom_elder_red_gigantic", 1)});

    public WorldGenElderMushroom(List<WeightedUtil.NamedItem> variantsIn, boolean isWorldGenIn) {
        this.variants = variantsIn;
        this.isWorldGen = isWorldGenIn;
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        while (this.isWorldGen && world.func_175623_d(pos) && pos.func_177956_o() > 32) {
            pos = pos.func_177977_b();
        }
        for (int posX = -1; posX < 2; ++posX) {
            for (int posZ = -1; posZ < 2; ++posZ) {
                BlockPos newPos = pos.func_177982_a(posX, 0, posZ);
                IBlockState state = world.func_180495_p(newPos);
                if (state.func_177230_c().canSustainPlant(state, (IBlockAccess)world, newPos, EnumFacing.UP, (IPlantable)NetherExBlocks.PLANT_MUSHROOM_ELDER) || state.func_177230_c() == Blocks.field_150425_aM) continue;
                return false;
            }
        }
        pos = pos.func_177984_a();
        Mirror[] mirrors = Mirror.values();
        Mirror mirror = mirrors[rand.nextInt(mirrors.length)];
        Rotation[] rotations = Rotation.values();
        Rotation rotation = rotations[rand.nextInt(rotations.length)];
        MinecraftServer minecraftServer = world.func_73046_m();
        TemplateManager templateManager = world.func_72860_G().func_186340_h();
        Template template = templateManager.func_186237_a(minecraftServer, new ResourceLocation(WeightedUtil.getRandomNamedItem((Random)rand, this.variants).name));
        PlacementSettings placementSettings = new PlacementSettings().func_186214_a(mirror).func_186220_a(rotation).func_186225_a(Blocks.field_150350_a);
        BlockPos structureSize = Template.func_186266_a((PlacementSettings)placementSettings.func_186217_a(), (BlockPos)template.func_186259_a());
        float airAmount = 0.0f;
        float blockAmount = MathHelper.func_76130_a((int)((structureSize.func_177958_n() + 2) * (structureSize.func_177956_o() + 1) * (structureSize.func_177952_p() + 2)));
        for (int posX = -1; posX < structureSize.func_177958_n() + 1; ++posX) {
            for (int posZ = -1; posZ < structureSize.func_177952_p() + 1; ++posZ) {
                for (int posY = 0; posY < structureSize.func_177956_o() + 1; ++posY) {
                    BlockPos newPos = pos.func_177982_a(-(posX / 2), posY, -(posZ / 2));
                    Block block = world.func_180495_p(newPos).func_177230_c();
                    if (world.func_175623_d(newPos)) {
                        airAmount += 1.0f;
                        continue;
                    }
                    if (block != Blocks.field_150424_aL && block != Blocks.field_150426_aN && block != NetherExBlocks.BLOCK_NETHERRACK && block != NetherExBlocks.PLANT_MUSHROOM_ELDER_CAP && block != NetherExBlocks.PLANT_MUSHROOM_ELDER_STEM) continue;
                    return false;
                }
            }
        }
        if (MathHelper.func_76135_e((float)airAmount) / MathHelper.func_76135_e((float)blockAmount) >= 0.75f) {
            if (!this.isWorldGen) {
                world.func_175698_g(pos);
            }
            template.func_186253_b(world, pos.func_177982_a(-(structureSize.func_177958_n() / 2), 0, -(structureSize.func_177952_p() / 2)), placementSettings.func_186217_a());
            return true;
        }
        return false;
    }
}

