/*
 * Decompiled with CFR 0.152.
 */
package com.nhave.nhintegration.integration;

import com.nhave.nhwrench.api.IWrenchHandler;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Random;
import jds.bibliocraft.BiblioCraft;
import jds.bibliocraft.items.ItemDrill;
import jds.bibliocraft.items.ItemLoader;
import jds.bibliocraft.tileentities.TileEntityArmorStand;
import jds.bibliocraft.tileentities.TileEntityBookcase;
import jds.bibliocraft.tileentities.TileEntityClock;
import jds.bibliocraft.tileentities.TileEntityDinnerPlate;
import jds.bibliocraft.tileentities.TileEntityDiscRack;
import jds.bibliocraft.tileentities.TileEntityFancySign;
import jds.bibliocraft.tileentities.TileEntityFancyWorkbench;
import jds.bibliocraft.tileentities.TileEntityFramedChest;
import jds.bibliocraft.tileentities.TileEntityGenericShelf;
import jds.bibliocraft.tileentities.TileEntityLamp;
import jds.bibliocraft.tileentities.TileEntityLantern;
import jds.bibliocraft.tileentities.TileEntityMapFrame;
import jds.bibliocraft.tileentities.TileEntityPainting;
import jds.bibliocraft.tileentities.TileEntityPotionShelf;
import jds.bibliocraft.tileentities.TileEntityPrintPress;
import jds.bibliocraft.tileentities.TileEntitySeat;
import jds.bibliocraft.tileentities.TileEntitySwordPedestal;
import jds.bibliocraft.tileentities.TileEntityTable;
import jds.bibliocraft.tileentities.TileEntityTypeMachine;
import jds.bibliocraft.tileentities.TileEntityTypewriter;
import jds.bibliocraft.tileentities.TileEntityWeaponCase;
import jds.bibliocraft.tileentities.TileEntityWeaponRack;
import jds.bibliocraft.tileentities.TileEntityWritingDesk;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class BiblioHandler
implements IWrenchHandler {
    private TileEntity tile1;
    private TileEntity tile2;

    public boolean handleWrench(String mode, ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        ItemDrill drill = (ItemDrill)ItemLoader.screwgun;
        TileEntity tile = world.func_147438_o(x, y, z);
        boolean returnValue = false;
        if (mode.equals("wrmode.wrench") && !world.field_72995_K && tile != null) {
            if (player.func_70093_af()) {
                if (tile instanceof TileEntitySeat) {
                    returnValue = side == 1 ? drill.connectChairs(player, world, x, y, z) : drill.rotateSeat(tile);
                }
                if (tile instanceof TileEntityDiscRack) {
                    returnValue = drill.discRackAngle(player, world, x, y, z);
                }
                if (tile instanceof TileEntityBookcase) {
                    returnValue = drill.rotateBookcase(tile);
                }
                if (tile instanceof TileEntityDinnerPlate) {
                    returnValue = drill.rotateDinnerPlate(tile);
                }
                if (tile instanceof TileEntityGenericShelf) {
                    returnValue = drill.rotateGenericShelf(tile);
                }
                if (tile instanceof TileEntityLamp) {
                    returnValue = drill.rotateLamp(tile);
                }
                if (tile instanceof TileEntityLantern) {
                    returnValue = drill.rotateLantern(tile);
                }
                if (tile instanceof TileEntityMapFrame) {
                    returnValue = drill.rotateMapFrame(tile);
                }
                if (tile instanceof TileEntityPotionShelf) {
                    returnValue = drill.rotatePotionShelf(tile);
                }
                if (tile instanceof TileEntityWeaponCase) {
                    returnValue = drill.rotateDisplayCase(tile);
                }
                if (tile instanceof TileEntityWeaponRack) {
                    returnValue = drill.rotateWeaponRack(tile);
                }
                if (tile instanceof TileEntityWritingDesk) {
                    returnValue = drill.rotateDesk(tile);
                }
                if (tile instanceof TileEntityTypeMachine) {
                    returnValue = drill.rotate4baseMeta(world, x, y, z);
                    world.func_147471_g(x, y, z);
                }
                if (tile instanceof TileEntityPrintPress) {
                    returnValue = drill.rotate4baseMeta(world, x, y, z);
                    world.func_147471_g(x, y, z);
                }
                if (tile instanceof TileEntityArmorStand) {
                    returnValue = drill.rotateArmorStand(world, tile, x, y, z);
                }
                if (tile instanceof TileEntityTable) {
                    returnValue = drill.removeTableCarpet(world, tile, x, y, z);
                }
                if (tile instanceof TileEntityPainting) {
                    returnValue = this.connectTwoPaintings(world, tile, player, x, y, z);
                }
                if (tile instanceof TileEntityClock) {
                    returnValue = this.connectTwoClocks(world, tile, player, x, y, z);
                }
                if (tile instanceof TileEntitySwordPedestal) {
                    returnValue = this.rotateSwordPedestal((TileEntitySwordPedestal)tile);
                }
                if (tile instanceof TileEntityTypewriter) {
                    returnValue = this.rotateTypewriter((TileEntityTypewriter)tile);
                }
                if (tile instanceof TileEntityFancySign) {
                    returnValue = this.rotateFancySign((TileEntityFancySign)tile);
                }
                if (tile instanceof TileEntityFancyWorkbench) {
                    returnValue = this.rotateFancyWorkbench((TileEntityFancyWorkbench)tile);
                }
                if (tile instanceof TileEntityFramedChest) {
                    returnValue = this.connectTwoChests(world, tile, player);
                }
            } else {
                if (tile instanceof TileEntityDiscRack) {
                    returnValue = drill.discRackRotate(player, world, x, y, z);
                }
                if (tile instanceof TileEntityLamp) {
                    returnValue = drill.setLampStyle(tile);
                }
                if (tile instanceof TileEntityLantern) {
                    returnValue = drill.setLanternStyle(tile);
                }
                if (tile instanceof TileEntityWeaponCase) {
                    returnValue = drill.setDisplayCaseStyle(tile);
                }
                if (tile instanceof TileEntityBookcase) {
                    returnValue = drill.setBookcaseShift(tile);
                }
                if (tile instanceof TileEntityFancySign) {
                    returnValue = drill.setFancySignShift(tile);
                }
                if (tile instanceof TileEntityTable) {
                    returnValue = this.removeTableCloth(world, x, y, z);
                }
                if (tile instanceof TileEntitySeat) {
                    returnValue = this.removeSeatPart(world, x, y, z);
                }
                if (tile instanceof TileEntityPainting) {
                    returnValue = this.rotatePaintingCanvas((TileEntityPainting)tile);
                }
                if (tile instanceof TileEntityClock) {
                    returnValue = this.setClockShift(world, (TileEntityClock)tile);
                }
                if (tile instanceof TileEntityGenericShelf) {
                    returnValue = this.setShelfShift((TileEntityGenericShelf)tile);
                }
                if (tile instanceof TileEntityPotionShelf) {
                    returnValue = this.setPotionShelfShift((TileEntityPotionShelf)tile);
                }
                if (tile instanceof TileEntityWeaponRack) {
                    returnValue = this.setToolRackShift((TileEntityWeaponRack)tile);
                }
                if (tile instanceof TileEntityFramedChest) {
                    returnValue = this.rotateFramedChest((TileEntityFramedChest)tile);
                }
            }
            if (!returnValue) {
                // empty if block
            }
        }
        return returnValue;
    }

    private void playSound(EntityPlayer player) {
        player.func_85030_a("dig.stone", 1.0f, 0.8f);
    }

    public boolean removeTableCloth(World world, int x, int y, int z) {
        TileEntityTable tabletile = (TileEntityTable)world.func_147438_o(x, y, z);
        this.dropTableItem(world, x, y, z, 1);
        tabletile.setTableCloth(null);
        return true;
    }

    private void dropTableItem(World world, int x, int y, int z, int slot) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (!(tileEntity instanceof IInventory)) {
            return;
        }
        IInventory inventory = (IInventory)tileEntity;
        TileEntityTable tableTile = (TileEntityTable)tileEntity;
        ItemStack stuff = tableTile.isSlotFull() && slot == 0 ? inventory.func_70301_a(0) : (tableTile.isClothSlotFull() && slot == 1 ? inventory.func_70301_a(1) : null);
        if (stuff != null && stuff.field_77994_a > 0) {
            float iAdjust = 0.0f;
            EntityItem entityItem = new EntityItem(world, (double)((float)x + 0.5f), (double)((float)y + 1.4f), (double)((float)z + 0.5f), new ItemStack(stuff.func_77973_b(), stuff.field_77994_a, stuff.func_77960_j()));
            if (stuff.func_77942_o()) {
                entityItem.func_92059_d().func_77982_d((NBTTagCompound)stuff.func_77978_p().func_74737_b());
            }
            entityItem.field_70159_w = 0.0;
            entityItem.field_70181_x = 0.0;
            entityItem.field_70179_y = 0.0;
            world.func_72838_d((Entity)entityItem);
            stuff.field_77994_a = 0;
        }
    }

    public boolean removeSeatPart(World world, int x, int y, int z) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        IInventory inventory = (IInventory)tileEntity;
        TileEntitySeat seatTile = (TileEntitySeat)tileEntity;
        if (inventory.func_70301_a(0) != null) {
            this.dropSeatSlot(world, x, y, z, 0);
            seatTile.removeCover();
            return true;
        }
        if (seatTile.hasBack > 0) {
            this.dropSeatSlot(world, x, y, z, 1);
            seatTile.removeBack();
            return true;
        }
        return true;
    }

    private void dropSeatSlot(World world, int x, int y, int z, int slot) {
        Random rando = new Random();
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (!(tileEntity instanceof IInventory)) {
            return;
        }
        IInventory inventory = (IInventory)tileEntity;
        ItemStack item = inventory.func_70301_a(slot);
        if (item != null && item.field_77994_a > 0) {
            EntityItem entityItem = new EntityItem(world, (double)((float)x + 0.5f), (double)((float)y + 1.0f), (double)z + 0.5, new ItemStack(item.func_77973_b(), item.field_77994_a, item.func_77960_j()));
            if (item.func_77942_o()) {
                entityItem.func_92059_d().func_77982_d((NBTTagCompound)item.func_77978_p().func_74737_b());
            }
            entityItem.field_70159_w = 0.0;
            entityItem.field_70181_x = 0.0;
            entityItem.field_70179_y = 0.0;
            world.func_72838_d((Entity)entityItem);
        }
    }

    private boolean connectTwoClocks(World world, TileEntity tile, EntityPlayer player, int i, int j, int k) {
        if (this.tile1 == null || !(this.tile1 instanceof TileEntityClock)) {
            this.tile1 = tile;
            this.sendPacketToClient(StatCollector.func_74838_a((String)"screwgun.selected.clock1"), (EntityPlayerMP)player);
            return true;
        }
        if (this.tile2 == null || !(this.tile2 instanceof TileEntityClock)) {
            this.tile2 = tile;
            this.sendPacketToClient(StatCollector.func_74838_a((String)"screwgun.selected.clock2"), (EntityPlayerMP)player);
        }
        if (this.tile1 != null && this.tile1 instanceof TileEntityClock && this.tile2 != null && this.tile2 instanceof TileEntityClock) {
            if (this.tile1.field_145848_d == this.tile2.field_145848_d + 1) {
                TileEntityClock clockTop = (TileEntityClock)this.tile1;
                TileEntityClock clockBottom = (TileEntityClock)this.tile2;
                if (!this.configureClocks(clockTop, clockBottom)) {
                    this.sendPacketToClient(StatCollector.func_74838_a((String)"drill.failed"), (EntityPlayerMP)player);
                }
                this.tile1 = null;
                this.tile2 = null;
                return true;
            }
            if (this.tile1.field_145848_d == this.tile2.field_145848_d - 1) {
                TileEntityClock clockTop = (TileEntityClock)this.tile2;
                TileEntityClock clockBottom = (TileEntityClock)this.tile1;
                if (!this.configureClocks(clockTop, clockBottom)) {
                    this.sendPacketToClient(StatCollector.func_74838_a((String)"drill.failed"), (EntityPlayerMP)player);
                }
                this.tile1 = null;
                this.tile2 = null;
                return true;
            }
            this.sendPacketToClient(StatCollector.func_74838_a((String)"drill.failed"), (EntityPlayerMP)player);
            this.tile1 = null;
            this.tile2 = null;
        }
        return false;
    }

    public boolean configureClocks(TileEntityClock top, TileEntityClock bottom) {
        if (top.getClockType() == 0 && bottom.getClockType() == 0) {
            top.setClockType(1);
            bottom.setClockType(2);
            return true;
        }
        if (top.getClockType() == 1 && bottom.getClockType() == 2) {
            top.setClockType(0);
            bottom.setClockType(0);
            return true;
        }
        return false;
    }

    private boolean setClockShift(World world, TileEntityClock tile) {
        TileEntityClock otherClockTile;
        TileEntity otherClock;
        tile.setShift(!tile.getShift());
        if (tile.getClockType() == 1 && (otherClock = world.func_147438_o(tile.field_145851_c, tile.field_145848_d - 1, tile.field_145849_e)) != null && otherClock instanceof TileEntityClock) {
            otherClockTile.setShift(!(otherClockTile = (TileEntityClock)otherClock).getShift());
        }
        if (tile.getClockType() == 2 && (otherClock = world.func_147438_o(tile.field_145851_c, tile.field_145848_d + 1, tile.field_145849_e)) != null && otherClock instanceof TileEntityClock) {
            otherClockTile.setShift(!(otherClockTile = (TileEntityClock)otherClock).getShift());
        }
        return true;
    }

    private void sendPacketToClient(String displayString, EntityPlayerMP player) {
        ByteBuf buffer = Unpooled.buffer();
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)displayString);
        BiblioCraft.ch_BiblioDrillText.sendTo(new FMLProxyPacket(buffer, "BiblioDrillText"), player);
    }

    private boolean setShelfShift(TileEntityGenericShelf tile) {
        tile.setShift(!tile.getShift());
        return true;
    }

    private boolean setPotionShelfShift(TileEntityPotionShelf tile) {
        tile.setShift(!tile.getShift());
        return true;
    }

    private boolean setToolRackShift(TileEntityWeaponRack tile) {
        tile.setShift(!tile.getShift());
        return true;
    }

    private boolean rotateSwordPedestal(TileEntitySwordPedestal pedestalTile) {
        if (pedestalTile.getAngle() < 3) {
            pedestalTile.setAngle(pedestalTile.getAngle() + 1);
        } else {
            pedestalTile.setAngle(0);
        }
        return true;
    }

    private boolean rotateFancySign(TileEntityFancySign tile) {
        if (tile.getAngle() < 3) {
            tile.setAngle(tile.getAngle() + 1);
        } else {
            tile.setAngle(0);
        }
        return true;
    }

    private boolean rotateFancyWorkbench(TileEntityFancyWorkbench tile) {
        if (tile.getAngle() < 3) {
            tile.setAngle(tile.getAngle() + 1);
        } else {
            tile.setAngle(0);
        }
        return true;
    }

    private boolean connectTwoPaintings(World world, TileEntity tile, EntityPlayer player, int x, int y, int z) {
        if (this.tile1 == null || !(this.tile1 instanceof TileEntityPainting)) {
            this.tile1 = tile;
            this.sendPacketToClient(StatCollector.func_74838_a((String)"screwgun.selected.painting1"), (EntityPlayerMP)player);
            return true;
        }
        if (this.tile2 == null || !(this.tile2 instanceof TileEntityPainting)) {
            this.tile2 = tile;
            this.sendPacketToClient(StatCollector.func_74838_a((String)"screwgun.selected.painting2"), (EntityPlayerMP)player);
        }
        if (this.tile1 != null && this.tile1 instanceof TileEntityPainting && this.tile2 != null && this.tile2 instanceof TileEntityPainting) {
            TileEntityPainting painting1 = (TileEntityPainting)this.tile1;
            TileEntityPainting painting2 = (TileEntityPainting)this.tile2;
            if (painting1.getAngle() == painting2.getAngle()) {
                if (this.tile1.field_145848_d == this.tile2.field_145848_d + 1) {
                    if (painting1.getConnectBottom() && painting2.getConnectTop()) {
                        painting1.setConnectBottom(false);
                        painting2.setConnectTop(false);
                    } else {
                        painting1.setConnectBottom(true);
                        painting2.setConnectTop(true);
                    }
                    this.completedPaintingConnect(player);
                } else if (this.tile1.field_145848_d == this.tile2.field_145848_d - 1) {
                    if (painting1.getConnectTop() && painting2.getConnectBottom()) {
                        painting1.setConnectTop(false);
                        painting2.setConnectBottom(false);
                    } else {
                        painting1.setConnectTop(true);
                        painting2.setConnectBottom(true);
                    }
                    this.completedPaintingConnect(player);
                } else if (this.checkLeftSidePainting(painting1, painting2)) {
                    if (painting1.getConnectLeft() && painting2.getConnectRight()) {
                        painting1.setConnectLeft(false);
                        painting2.setConnectRight(false);
                    } else {
                        painting1.setConnectLeft(true);
                        painting2.setConnectRight(true);
                    }
                    this.completedPaintingConnect(player);
                } else if (this.checkRightSidePainting(painting1, painting2)) {
                    if (painting1.getConnectRight() && painting2.getConnectLeft()) {
                        painting1.setConnectRight(false);
                        painting2.setConnectLeft(false);
                    } else {
                        painting1.setConnectRight(true);
                        painting2.setConnectLeft(true);
                    }
                    this.completedPaintingConnect(player);
                } else {
                    this.sendPacketToClient(StatCollector.func_74838_a((String)"drill.failed"), (EntityPlayerMP)player);
                    this.tile1 = null;
                    this.tile2 = null;
                }
            } else {
                this.sendPacketToClient(StatCollector.func_74838_a((String)"drill.failed"), (EntityPlayerMP)player);
                this.tile1 = null;
                this.tile2 = null;
            }
        }
        return false;
    }

    private void completedPaintingConnect(EntityPlayer player) {
        this.tile1 = null;
        this.tile2 = null;
    }

    private boolean checkLeftSidePainting(TileEntityPainting centerPainting, TileEntityPainting otherPainting) {
        switch (centerPainting.getAngle()) {
            case 0: {
                if (centerPainting.field_145849_e != otherPainting.field_145849_e + 1) break;
                return true;
            }
            case 1: {
                if (centerPainting.field_145851_c != otherPainting.field_145851_c - 1) break;
                return true;
            }
            case 2: {
                if (centerPainting.field_145849_e != otherPainting.field_145849_e - 1) break;
                return true;
            }
            case 3: {
                if (centerPainting.field_145851_c != otherPainting.field_145851_c + 1) break;
                return true;
            }
        }
        return false;
    }

    private boolean checkRightSidePainting(TileEntityPainting centerPainting, TileEntityPainting otherPainting) {
        switch (centerPainting.getAngle()) {
            case 0: {
                if (centerPainting.field_145849_e != otherPainting.field_145849_e - 1) break;
                return true;
            }
            case 1: {
                if (centerPainting.field_145851_c != otherPainting.field_145851_c + 1) break;
                return true;
            }
            case 2: {
                if (centerPainting.field_145849_e != otherPainting.field_145849_e + 1) break;
                return true;
            }
            case 3: {
                if (centerPainting.field_145851_c != otherPainting.field_145851_c - 1) break;
                return true;
            }
        }
        return false;
    }

    private boolean rotatePaintingCanvas(TileEntityPainting painting) {
        if (painting.getPaintingRotation() < 3) {
            painting.setPaintingRotation(painting.getPaintingRotation() + 1);
        } else {
            painting.setPaintingRotation(0);
        }
        return true;
    }

    private boolean rotateTypewriter(TileEntityTypewriter tile) {
        if (tile.getAngle() < 3) {
            tile.setAngle(tile.getAngle() + 1);
        } else {
            tile.setAngle(0);
        }
        return true;
    }

    private boolean connectTwoChests(World world, TileEntity tile, EntityPlayer player) {
        if (this.tile1 == null || !(this.tile1 instanceof TileEntityFramedChest)) {
            this.tile1 = tile;
            this.sendPacketToClient(StatCollector.func_74838_a((String)"screwgun.selected.chest1"), (EntityPlayerMP)player);
            return true;
        }
        if (this.tile2 == null || !(this.tile2 instanceof TileEntityFramedChest)) {
            this.tile2 = tile;
            this.sendPacketToClient(StatCollector.func_74838_a((String)"screwgun.selected.chest2"), (EntityPlayerMP)player);
        }
        if (this.tile1 != null && this.tile1 instanceof TileEntityFramedChest && this.tile2 != null && this.tile2 instanceof TileEntityFramedChest) {
            TileEntityFramedChest chest1 = (TileEntityFramedChest)this.tile1;
            TileEntityFramedChest chest2 = (TileEntityFramedChest)this.tile2;
            if (chest1.getAngle() == chest2.getAngle()) {
                int test = this.isValidChestConnect(chest1.getAngle(), this.tile1.field_145851_c, this.tile1.field_145848_d, this.tile1.field_145849_e, this.tile2.field_145851_c, this.tile2.field_145848_d, this.tile2.field_145849_e);
                if (test == 1) {
                    if (chest1.getIsDouble() && chest1.getIsLeft() && chest2.getIsDouble() && !chest2.getIsLeft()) {
                        chest1.setIsDouble(false, false, null);
                        chest2.setIsDouble(false, false, null);
                    } else if (!chest1.getIsDouble() && !chest2.getIsDouble()) {
                        chest1.setIsDouble(true, true, chest2);
                        chest2.setIsDouble(true, false, chest1);
                    } else {
                        this.sendPacketToClient(StatCollector.func_74838_a((String)"drill.failed"), (EntityPlayerMP)player);
                    }
                } else if (test == 2) {
                    if (chest1.getIsDouble() && !chest1.getIsLeft() && chest2.getIsDouble() && chest2.getIsLeft()) {
                        chest1.setIsDouble(false, false, null);
                        chest2.setIsDouble(false, false, null);
                    } else if (!chest1.getIsDouble() && !chest2.getIsDouble()) {
                        chest1.setIsDouble(true, false, chest2);
                        chest2.setIsDouble(true, true, chest1);
                    } else {
                        this.sendPacketToClient(StatCollector.func_74838_a((String)"drill.failed"), (EntityPlayerMP)player);
                    }
                } else {
                    this.sendPacketToClient(StatCollector.func_74838_a((String)"drill.failed"), (EntityPlayerMP)player);
                }
            } else {
                this.sendPacketToClient(StatCollector.func_74838_a((String)"drill.failed"), (EntityPlayerMP)player);
            }
            this.tile1 = null;
            this.tile2 = null;
            return true;
        }
        return false;
    }

    private int isValidChestConnect(int angle, int x1, int y1, int z1, int x2, int y2, int z2) {
        if (y1 == y2) {
            switch (angle) {
                case 0: {
                    if (x1 == x2 && z1 == z2 + 1) {
                        return 2;
                    }
                    if (x1 == x2 && z1 == z2 - 1) {
                        return 1;
                    }
                }
                case 1: {
                    if (z1 == z2 && x1 == x2 - 1) {
                        return 2;
                    }
                    if (z1 == z2 && x1 == x2 + 1) {
                        return 1;
                    }
                }
                case 2: {
                    if (x1 == x2 && z1 == z2 - 1) {
                        return 2;
                    }
                    if (x1 == x2 && z1 == z2 + 1) {
                        return 1;
                    }
                }
                case 3: {
                    if (z1 == z2 && x1 == x2 + 1) {
                        return 2;
                    }
                    if (z1 != z2 || x1 != x2 - 1) break;
                    return 1;
                }
            }
        }
        return 0;
    }

    private boolean rotateFramedChest(TileEntityFramedChest chest) {
        if (!chest.getIsDouble()) {
            int currAngle = chest.getAngle();
            if (currAngle >= 3) {
                chest.setAngle(0);
            } else {
                chest.setAngle(currAngle + 1);
            }
        }
        return true;
    }
}

