/*
 * Decompiled with CFR 0.152.
 */
package org.dave.ocrsdriver;

import com.raoulvdberge.refinedstorage.api.IRSAPI;
import com.raoulvdberge.refinedstorage.api.RSAPIInject;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingTask;
import com.raoulvdberge.refinedstorage.api.network.INetworkMaster;
import com.raoulvdberge.refinedstorage.api.network.INetworkNode;
import java.util.Map;
import li.cil.oc.api.Network;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Visibility;
import li.cil.oc.api.prefab.DriverSidedTileEntity;
import li.cil.oc.api.prefab.ManagedEnvironment;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class DriverNetworkNode
extends DriverSidedTileEntity {
    @RSAPIInject
    public static IRSAPI rsAPI;

    public Class<?> getTileEntityClass() {
        return INetworkNode.class;
    }

    public ManagedEnvironment createEnvironment(World world, BlockPos pos, EnumFacing side) {
        return new Environment((INetworkNode)world.func_175625_s(pos));
    }

    public static final class Environment
    extends ManagedEnvironment {
        protected final INetworkNode node;

        public Environment(INetworkNode node) {
            this.node = node;
            this.setNode(Network.newNode((li.cil.oc.api.network.Environment)this, (Visibility)Visibility.Network).withComponent("rs_interface").create());
        }

        @Callback
        public Object[] isConnected(Context context, Arguments args) {
            if (this.node.getNetwork() == null) {
                return new Object[]{null, "not connected"};
            }
            return new Object[]{this.node.isConnected()};
        }

        @Callback
        public Object[] getEnergyUsage(Context context, Arguments args) {
            if (this.node.getNetwork() == null) {
                return new Object[]{null, "not connected"};
            }
            return new Object[]{this.node.getNetwork().getEnergyUsage()};
        }

        @Callback
        public Object[] getTasks(Context context, Arguments args) {
            if (this.node.getNetwork() == null) {
                return new Object[]{null, "not connected"};
            }
            return new Object[]{this.node.getNetwork().getCraftingTasks()};
        }

        @Callback
        public Object[] getPatterns(Context context, Arguments args) {
            if (this.node.getNetwork() == null) {
                return new Object[]{null, "not connected"};
            }
            return new Object[]{this.node.getNetwork().getPatterns()};
        }

        @Callback
        public Object[] hasPattern(Context context, Arguments args) {
            if (this.node.getNetwork() == null) {
                return new Object[]{null, "not connected"};
            }
            ItemStack stack = args.checkItemStack(0);
            return new Object[]{this.node.getNetwork().hasPattern(stack)};
        }

        @Callback
        public Object[] getMissingItems(Context context, Arguments args) {
            if (this.node.getNetwork() == null) {
                return new Object[]{null, "not connected"};
            }
            ItemStack stack = args.checkItemStack(0);
            if (!this.node.getNetwork().hasPattern(stack)) {
                throw new IllegalArgumentException("No pattern for this item stack exists");
            }
            int count = args.optInteger(1, 1);
            ICraftingPattern pattern = this.node.getNetwork().getPattern(stack);
            ICraftingTask task = this.node.getNetwork().createCraftingTask(stack, pattern, count);
            task.calculate();
            return new Object[]{task.getMissing().getStacks()};
        }

        @Callback
        public Object[] craftItem(Context context, Arguments args) {
            if (this.node.getNetwork() == null) {
                return new Object[]{null, "not connected"};
            }
            ItemStack stack = args.checkItemStack(0);
            if (!this.node.getNetwork().hasPattern(stack)) {
                throw new IllegalArgumentException("No pattern for this item stack exists");
            }
            int count = args.optInteger(1, 1);
            ICraftingPattern pattern = this.node.getNetwork().getPattern(stack);
            ICraftingTask task = this.node.getNetwork().createCraftingTask(stack, pattern, count);
            task.calculate();
            this.node.getNetwork().addCraftingTask(task);
            return new Object[0];
        }

        @Callback
        public Object[] cancelCrafting(Context context, Arguments args) {
            if (this.node.getNetwork() == null) {
                return new Object[]{null, "not connected"};
            }
            ItemStack stack = args.checkItemStack(0);
            INetworkMaster grid = this.node.getNetwork();
            int count = 0;
            for (ICraftingTask task : grid.getCraftingTasks()) {
                if (!rsAPI.getComparer().isEqual(task.getRequested(), stack, 3)) continue;
                grid.cancelCraftingTask(task);
                ++count;
            }
            return new Object[]{count};
        }

        @Callback
        public Object[] extractFluid(Context context, Arguments args) {
            int amount;
            if (this.node.getNetwork() == null) {
                return new Object[]{null, "not connected"};
            }
            Map fluidMap = args.checkTable(0);
            if (!fluidMap.containsKey("name") || !(fluidMap.get("name") instanceof String) || ((String)fluidMap.get("name")).length() == 0) {
                throw new IllegalArgumentException("no fluid name");
            }
            String fluid = (String)fluidMap.get("name");
            FluidStack stack = FluidRegistry.getFluidStack((String)fluid, (int)(amount = Math.max(1, args.checkInteger(1))));
            if (stack == null) {
                throw new IllegalArgumentException("invalid fluid stack, does not exist");
            }
            EnumFacing facing = EnumFacing.func_82600_a((int)args.optInteger(2, 0));
            TileEntity targetEntity = this.node.getNetwork().getNetworkWorld().func_175625_s(this.node.getPosition().func_177972_a(facing));
            if (targetEntity == null || !targetEntity.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d())) {
                throw new IllegalArgumentException("No fluid tank on the given side");
            }
            FluidStack extractedSim = this.node.getNetwork().extractFluid(stack, amount, true);
            if (extractedSim == null || extractedSim.amount <= 0) {
                return new Object[]{null, "could not extract the specified fluid"};
            }
            IFluidHandler handler = (IFluidHandler)targetEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d());
            int filledAmountSim = handler.fill(extractedSim, false);
            if (filledAmountSim <= 0) {
                return new Object[]{0};
            }
            FluidStack extracted = this.node.getNetwork().extractFluid(stack, amount, false);
            handler.fill(extracted, true);
            return new Object[]{filledAmountSim};
        }

        @Callback
        public Object[] extractItem(Context context, Arguments args) {
            if (this.node.getNetwork() == null) {
                return new Object[]{null, "not connected"};
            }
            ItemStack stack = args.checkItemStack(0);
            int count = Math.max(1, args.optInteger(1, 1));
            count = Math.min(count, stack.func_77976_d());
            EnumFacing facing = EnumFacing.func_82600_a((int)args.optInteger(2, 0));
            TileEntity targetEntity = this.node.getNodeWorld().func_175625_s(this.node.getPosition().func_177972_a(facing));
            if (targetEntity == null || !targetEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d())) {
                throw new IllegalArgumentException("No inventory on the given side");
            }
            IItemHandler handler = (IItemHandler)targetEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d());
            ItemStack extractedSim = this.node.getNetwork().extractItem(stack, count, true);
            if (extractedSim == null || extractedSim.field_77994_a == 0) {
                throw new IllegalArgumentException("Could not extract the specified item. Does it exist?");
            }
            int transferableAmount = extractedSim.field_77994_a;
            ItemStack insertedSim = ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)extractedSim, (boolean)true);
            if (insertedSim != null && insertedSim.field_77994_a > 0) {
                transferableAmount -= insertedSim.field_77994_a;
            }
            if (transferableAmount <= 0) {
                return new Object[]{0};
            }
            ItemStack extracted = this.node.getNetwork().extractItem(stack, transferableAmount, false);
            ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)extracted, (boolean)false);
            return new Object[]{transferableAmount};
        }

        @Callback
        public Object[] getFluid(Context context, Arguments args) {
            if (this.node.getNetwork() == null) {
                return new Object[]{null, "not connected"};
            }
            Map fluidMap = args.checkTable(0);
            if (!fluidMap.containsKey("name") || !(fluidMap.get("name") instanceof String) || ((String)fluidMap.get("name")).length() == 0) {
                throw new IllegalArgumentException("no fluid name");
            }
            String fluid = (String)fluidMap.get("name");
            FluidStack needle = FluidRegistry.getFluidStack((String)fluid, (int)1000);
            if (needle == null) {
                throw new IllegalArgumentException("invalid fluid stack, does not exist");
            }
            return new Object[]{this.node.getNetwork().getFluidStorageCache().getList().get(needle)};
        }

        @Callback
        public Object[] getFluids(Context context, Arguments args) {
            if (this.node.getNetwork() == null) {
                return new Object[]{null, "not connected"};
            }
            return new Object[]{this.node.getNetwork().getFluidStorageCache().getList().getStacks()};
        }

        @Callback
        public Object[] getItem(Context context, Arguments args) {
            if (this.node.getNetwork() == null) {
                return new Object[]{null, "not connected"};
            }
            ItemStack stack = args.checkItemStack(0);
            boolean compareMeta = args.optBoolean(1, false);
            boolean compareNBT = args.optBoolean(2, false);
            boolean compareOreDict = args.optBoolean(3, true);
            int flag = 0;
            if (compareMeta) {
                flag |= 1;
            }
            if (compareNBT) {
                flag |= 2;
            }
            if (compareOreDict) {
                flag |= 8;
            }
            return new Object[]{this.node.getNetwork().getItemStorageCache().getList().get(stack, flag)};
        }

        @Callback
        public Object[] getItems(Context context, Arguments args) {
            if (this.node.getNetwork() == null) {
                return new Object[]{null, "not connected"};
            }
            return new Object[]{this.node.getNetwork().getItemStorageCache().getList().getStacks()};
        }
    }
}

