/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn;

import com.mcmoddev.orespawn.EventHandlers;
import com.mcmoddev.orespawn.api.os3.ISpawnBuilder;
import com.mcmoddev.orespawn.api.os3.OS3API;
import com.mcmoddev.orespawn.api.plugin.PluginLoader;
import com.mcmoddev.orespawn.commands.AddOreCommand;
import com.mcmoddev.orespawn.commands.ClearChunkCommand;
import com.mcmoddev.orespawn.commands.DumpBiomesCommand;
import com.mcmoddev.orespawn.commands.WriteConfigsCommand;
import com.mcmoddev.orespawn.data.Config;
import com.mcmoddev.orespawn.data.FeatureRegistry;
import com.mcmoddev.orespawn.impl.os3.OS3APIImpl;
import com.mcmoddev.orespawn.worldgen.FlatBedrock;
import com.mcmoddev.orespawn.worldgen.OreSpawnWorldGen;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="orespawn", name="MMD OreSpawn", version="3.3.1", acceptedMinecraftVersions="[1.12,)", certificateFingerprint="d476d1b22b218a10d845928d1665d45fce301b27")
public class OreSpawn {
    @Mod.Instance
    public static OreSpawn instance;
    public static final Logger LOGGER;
    public static final OS3API API;
    static final EventHandlers eventHandlers;
    public static final FeatureRegistry FEATURES;
    protected static final Map<Integer, List<ISpawnBuilder>> spawns;
    static final FlatBedrock flatBedrock;

    public static Map<Integer, List<ISpawnBuilder>> getSpawns() {
        return spawns;
    }

    @Mod.EventHandler
    public void onFingerprintViolation(FMLFingerprintViolationEvent event) {
        LOGGER.warn("Invalid fingerprint detected!");
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent ev) {
        Config.loadConfig();
        PluginLoader.INSTANCE.load(ev);
        if (Config.getBoolean("Flatten Bedrock")) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)flatBedrock, (int)100);
        }
        GameRegistry.registerWorldGenerator((IWorldGenerator)new OreSpawnWorldGen(), (int)100);
        if (Config.getBoolean("Retrogen") || Config.getBoolean("Replace Vanilla Oregen") || Config.getBoolean("Retrogen Flat Bedrock")) {
            MinecraftForge.EVENT_BUS.register((Object)eventHandlers);
            MinecraftForge.ORE_GEN_BUS.register((Object)eventHandlers);
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent ev) {
        PluginLoader.INSTANCE.register();
        API.loadConfigFiles();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent ev) {
        Config.saveConfig();
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent ev) {
        ev.registerServerCommand((ICommand)new ClearChunkCommand());
        ev.registerServerCommand((ICommand)new DumpBiomesCommand());
        ev.registerServerCommand((ICommand)new AddOreCommand());
        ev.registerServerCommand((ICommand)new WriteConfigsCommand());
    }

    static {
        LOGGER = LogManager.getFormatterLogger((String)"orespawn");
        API = new OS3APIImpl();
        eventHandlers = new EventHandlers();
        FEATURES = new FeatureRegistry();
        spawns = new HashMap<Integer, List<ISpawnBuilder>>();
        flatBedrock = new FlatBedrock();
    }
}

