/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn.api.os3;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mcmoddev.orespawn.util.StateUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;

public class OreSpawnBlockMatcher
implements Predicate<IBlockState> {
    private final List<IBlockState> possibles;

    public OreSpawnBlockMatcher(IBlockState ... matches) {
        this.possibles = Arrays.asList(matches);
    }

    public OreSpawnBlockMatcher(List<IBlockState> matches) {
        this.possibles = new ArrayList<IBlockState>();
        this.possibles.addAll(matches);
    }

    private boolean has(IBlockState bs) {
        return this.possibles.stream().filter(bs::equals).count() > 0L;
    }

    @Override
    public boolean test(IBlockState other) {
        return !other.func_177230_c().equals(Blocks.field_150350_a) && this.has(other);
    }

    public JsonArray serialize() {
        JsonArray rv = new JsonArray();
        this.possibles.stream().forEach(bs -> {
            JsonObject t = new JsonObject();
            t.addProperty("name", bs.func_177230_c().getRegistryName().toString());
            if (!bs.equals(bs.func_177230_c().func_176223_P())) {
                String state = StateUtil.serializeState(bs);
                t.addProperty("state", state);
            }
            rv.add((JsonElement)t);
        });
        return rv;
    }
}

