/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn.api.plugin;

import com.mcmoddev.orespawn.OreSpawn;
import com.mcmoddev.orespawn.api.plugin.IOreSpawnPlugin;
import com.mcmoddev.orespawn.api.plugin.OreSpawnPlugin;
import com.mcmoddev.orespawn.data.Config;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;
import net.minecraft.crash.CrashReport;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public enum PluginLoader {
    INSTANCE;

    private static List<PluginData> dataStore;

    private String getAnnotationItem(String item, ASMDataTable.ASMData asmData) {
        if (asmData.getAnnotationInfo().get(item) != null) {
            return asmData.getAnnotationInfo().get(item).toString();
        }
        return "";
    }

    public void load(FMLPreInitializationEvent event) {
        for (ASMDataTable.ASMData asmDataItem : event.getAsmData().getAll(OreSpawnPlugin.class.getCanonicalName())) {
            String modId = this.getAnnotationItem("modid", asmDataItem);
            String resourceBase = this.getAnnotationItem("resourcePath", asmDataItem);
            String clazz = asmDataItem.getClassName();
            try {
                IOreSpawnPlugin integration = Class.forName(clazz).asSubclass(IOreSpawnPlugin.class).newInstance();
                PluginData pd = new PluginData(modId, resourceBase, integration);
                dataStore.add(pd);
            }
            catch (Exception ex) {
                OreSpawn.LOGGER.error("Couldn't load integrations for " + modId, (Throwable)ex);
            }
        }
    }

    public void register() {
        dataStore.forEach(pd -> {
            this.scanResources((PluginData)pd);
            pd.plugin.register(OreSpawn.API);
        });
    }

    public void scanResources(PluginData pd) {
        URI uri;
        if (Config.getKnownMods().contains(pd.modId)) {
            return;
        }
        String base = String.format(Locale.ENGLISH, "assets/%s/%s", pd.modId, pd.resourcePath);
        URL resURL = ((Object)((Object)this)).getClass().getClassLoader().getResource(base);
        if (resURL == null) {
            OreSpawn.LOGGER.warn("Unable to access file %s: got 'null' when trying to resolve it", (Object)base);
            return;
        }
        try {
            uri = resURL.toURI();
        }
        catch (URISyntaxException ex) {
            CrashReport report = CrashReport.func_85055_a((Throwable)ex, (String)String.format(Locale.ENGLISH, "Failed to get URI for %s", new ResourceLocation(pd.modId, pd.resourcePath).toString()));
            report.func_85056_g().func_71507_a("OreSpawn Version", (Object)"3.3.1");
            return;
        }
        if (uri.getScheme().equals("jar")) {
            try (FileSystem fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap());){
                this.copyout(fileSystem.getPath(base, new String[0]), pd.modId);
            }
            catch (IOException exc) {
                CrashReport report = CrashReport.func_85055_a((Throwable)exc, (String)String.format(Locale.ENGLISH, "Failed in getting FileSystem handler set up for %s", uri.getPath()));
                report.func_85056_g().func_71507_a("OreSpawn Version", (Object)"3.3.1");
                OreSpawn.LOGGER.info(report.func_71502_e());
            }
        } else {
            this.copyout(Paths.get(uri), pd.modId);
        }
        Config.addKnownMod(pd.modId);
    }

    private void copyout(Path myPath, String modId) {
        try (Stream<Path> walk = Files.walk(myPath, 1, new FileVisitOption[0]);){
            Iterator it = walk.iterator();
            while (it.hasNext()) {
                Path p = (Path)it.next();
                String name = p.getFileName().toString();
                if (!"json".equals(FilenameUtils.getExtension((String)name))) continue;
                InputStream reader = null;
                Path target = "_features".equals(FilenameUtils.getBaseName((String)name)) ? Paths.get("config", "orespawn3", "sysconf", String.format(Locale.ENGLISH, "features-%s.json", modId)) : ("_replacements".equals(FilenameUtils.getBaseName((String)name)) ? Paths.get("config", "orespawn3", "sysconf", String.format(Locale.ENGLISH, "replacements-%s.json", modId)) : Paths.get("config", "orespawn3", String.format(Locale.ENGLISH, "%s.json", modId)));
                if (target.toFile().exists()) continue;
                reader = Files.newInputStream(p, new OpenOption[0]);
                FileUtils.copyInputStreamToFile((InputStream)reader, (File)target.toFile());
                IOUtils.closeQuietly((InputStream)reader);
            }
        }
        catch (IOException exc) {
            CrashReport report = CrashReport.func_85055_a((Throwable)exc, (String)String.format(Locale.ENGLISH, "Faulted while iterating %s for config files or copying them out", myPath));
            report.func_85056_g().func_71507_a("OreSpawn Version", (Object)"3.3.1");
            OreSpawn.LOGGER.error(report.func_71502_e());
        }
    }

    static {
        dataStore = new ArrayList<PluginData>();
    }

    private class PluginData {
        public final String modId;
        public final String resourcePath;
        public final IOreSpawnPlugin plugin;

        PluginData(String modId, String resourcePath, IOreSpawnPlugin plugin) {
            this.modId = modId;
            this.resourcePath = resourcePath;
            this.plugin = plugin;
        }
    }
}

