/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mcmoddev.orespawn.OreSpawn;
import com.mcmoddev.orespawn.api.IFeature;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.crash.CrashReport;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringEscapeUtils;

public class FeatureRegistry {
    private static final String ORE_SPAWN_VERSION = "OreSpawn Version";
    private static final IForgeRegistry<IFeature> registry = new RegistryBuilder().setName(new ResourceLocation("orespawn", "feature_registry")).setType(IFeature.class).setMaxID(4096).create();

    public Map<String, IFeature> getFeatures() {
        TreeMap tempMap = new TreeMap();
        registry.getEntries().stream().forEach(e -> {
            IFeature cfr_ignored_0 = (IFeature)tempMap.put(((ResourceLocation)e.getKey()).toString(), e.getValue());
        });
        return Collections.unmodifiableMap(tempMap);
    }

    public String getFeatureName(IFeature feature) {
        return feature.getRegistryName().toString();
    }

    public IFeature getFeature(String name) {
        return this.getFeature(new ResourceLocation(name));
    }

    public IFeature getFeature(ResourceLocation featureResourceLocation) {
        ResourceLocation defaultGen = new ResourceLocation("default");
        if (registry.containsKey(featureResourceLocation)) {
            return (IFeature)registry.getValue(featureResourceLocation);
        }
        return (IFeature)registry.getValue(defaultGen);
    }

    public boolean hasFeature(String name) {
        return this.hasFeature(new ResourceLocation(name));
    }

    public boolean hasFeature(ResourceLocation featureResourceLocation) {
        return registry.containsKey(featureResourceLocation);
    }

    public boolean hasFeature(IFeature feature) {
        return registry.containsKey(feature.getRegistryName());
    }

    public void addFeature(String name, IFeature feature) {
        feature.setRegistryName(new ResourceLocation("orespawn", name));
        registry.register((IForgeRegistryEntry)feature);
    }

    public void addFeature(JsonObject entry) {
        this.addFeature(entry.get("name").getAsString(), entry.get("class").getAsString());
    }

    public void addFeature(String name, String className) {
        IFeature feature = FeatureRegistry.getInstance(className);
        if (feature != null && !this.hasFeature(name)) {
            this.addFeature(name, feature);
        }
    }

    private static IFeature getInstance(String className) {
        IFeature feature;
        try {
            Class<?> featureClazz = Class.forName(className);
            Constructor<?> featureCons = featureClazz.getConstructor(new Class[0]);
            feature = (IFeature)featureCons.newInstance(new Object[0]);
        }
        catch (Exception e) {
            CrashReport report = CrashReport.func_85055_a((Throwable)e, (String)("Failed to load and instantiate an instance of the feature generator named " + className + " that was specified as a feature generator"));
            report.func_85056_g().func_71507_a(ORE_SPAWN_VERSION, (Object)"3.3.1");
            OreSpawn.LOGGER.info(report.func_71502_e());
            return null;
        }
        return feature;
    }

    public void loadFeaturesFile(File file) {
        String rawJson;
        JsonParser parser = new JsonParser();
        try {
            rawJson = FileUtils.readFileToString((File)file, (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            CrashReport report = CrashReport.func_85055_a((Throwable)e, (String)("Failed reading config " + file.getName()));
            report.func_85056_g().func_71507_a(ORE_SPAWN_VERSION, (Object)"3.3.1");
            OreSpawn.LOGGER.info(report.func_71502_e());
            return;
        }
        JsonArray elements = parser.parse(rawJson).getAsJsonArray();
        for (JsonElement elem : elements) {
            this.addFeature(elem.getAsJsonObject());
        }
    }

    public void writeFeatures(File file) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        JsonArray root = new JsonArray();
        registry.getEntries().stream().map(ent -> {
            JsonObject e = new JsonObject();
            e.addProperty("name", ((ResourceLocation)ent.getKey()).func_110623_a());
            e.addProperty("class", ((IFeature)ent.getValue()).getClass().getName());
            return e;
        }).forEach(arg_0 -> ((JsonArray)root).add(arg_0));
        String json = gson.toJson((JsonElement)root);
        try {
            FileUtils.writeStringToFile((File)file, (String)StringEscapeUtils.unescapeJson((String)json), (String)"UTF-8");
        }
        catch (IOException e) {
            CrashReport report = CrashReport.func_85055_a((Throwable)e, (String)("Failed writing config " + file.getName()));
            report.func_85056_g().func_71507_a(ORE_SPAWN_VERSION, (Object)"3.3.1");
            OreSpawn.LOGGER.info(report.func_71502_e());
        }
    }
}

