/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn.impl.os3;

import com.google.common.collect.ImmutableSet;
import com.mcmoddev.orespawn.api.BiomeLocation;
import com.mcmoddev.orespawn.api.os3.IBiomeBuilder;
import com.mcmoddev.orespawn.impl.location.BiomeLocationAcceptAny;
import com.mcmoddev.orespawn.impl.location.BiomeLocationComposition;
import com.mcmoddev.orespawn.impl.location.BiomeLocationEmpty;
import com.mcmoddev.orespawn.impl.location.BiomeLocationList;
import com.mcmoddev.orespawn.impl.location.BiomeLocationSingle;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class BiomeBuilder
implements IBiomeBuilder {
    private final List<Biome> whitelist = new LinkedList<Biome>();
    private final List<Biome> blacklist = new LinkedList<Biome>();
    private boolean acceptAll = false;

    @Override
    public IBiomeBuilder addWhitelistEntry(Biome biome) {
        this.whitelist.add(biome);
        return this;
    }

    @Override
    public IBiomeBuilder addWhitelistEntry(String biomeName) {
        return this.addWhitelistEntry(new ResourceLocation(biomeName));
    }

    @Override
    public IBiomeBuilder addWhitelistEntry(ResourceLocation biomeResourceLocation) {
        return this.addWhitelistEntry((Biome)ForgeRegistries.BIOMES.getValue(biomeResourceLocation));
    }

    @Override
    public IBiomeBuilder addBlacklistEntry(Biome biome) {
        this.blacklist.add(biome);
        return this;
    }

    @Override
    public IBiomeBuilder addBlacklistEntry(String biomeName) {
        return this.addBlacklistEntry(new ResourceLocation(biomeName));
    }

    @Override
    public IBiomeBuilder addBlacklistEntry(ResourceLocation biomeResourceLocation) {
        return this.addBlacklistEntry((Biome)ForgeRegistries.BIOMES.getValue(biomeResourceLocation));
    }

    @Override
    public IBiomeBuilder setAcceptAll() {
        this.acceptAll = true;
        return this;
    }

    @Override
    public BiomeLocation create() {
        if (this.acceptAll) {
            return new BiomeLocationAcceptAny();
        }
        BiomeLocation whitelistI = this.whitelist.isEmpty() ? (!this.blacklist.isEmpty() ? new BiomeLocationAcceptAny() : new BiomeLocationEmpty()) : new BiomeLocationList((ImmutableSet<BiomeLocation>)ImmutableSet.copyOf((Collection)this.whitelist.stream().map(biome -> new BiomeLocationSingle((Biome)biome)).collect(Collectors.toList())));
        BiomeLocation blacklistI = this.blacklist.isEmpty() ? new BiomeLocationEmpty() : new BiomeLocationList((ImmutableSet<BiomeLocation>)ImmutableSet.copyOf((Collection)this.blacklist.stream().map(biome -> new BiomeLocationSingle((Biome)biome)).collect(Collectors.toList())));
        return new BiomeLocationComposition(whitelistI, blacklistI);
    }
}

