/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn.impl.os3;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mcmoddev.orespawn.OreSpawn;
import com.mcmoddev.orespawn.api.IFeature;
import com.mcmoddev.orespawn.api.os3.IFeatureBuilder;
import com.mcmoddev.orespawn.api.os3.IFeatureEntry;
import com.mcmoddev.orespawn.impl.os3.FeatureEntry;
import java.util.Locale;
import net.minecraft.util.ResourceLocation;

public class FeatureBuilder
implements IFeatureBuilder {
    private IFeature feature;
    private JsonObject parameters = new JsonObject();
    private boolean useDefaults = false;

    @Override
    public IFeatureBuilder setFeature(String featureName) {
        String actName = featureName;
        if (!actName.contains(":")) {
            actName = String.format(Locale.ENGLISH, "orespawn:%s", featureName);
        }
        return this.setFeature(new ResourceLocation(actName));
    }

    @Override
    public IFeatureBuilder setFeature(ResourceLocation featureResourceLocation) {
        if (!OreSpawn.API.featureExists(featureResourceLocation)) {
            OreSpawn.LOGGER.warn("Feature %s is not known, feature for this will be set to the default feature", (Object)featureResourceLocation.func_110623_a());
        }
        return this.setFeature(OreSpawn.API.getFeature(featureResourceLocation));
    }

    @Override
    public IFeatureBuilder setFeature(IFeature feature) {
        this.feature = feature;
        return this;
    }

    @Override
    public IFeatureBuilder setParameter(String parameterName, String parameterValue) {
        this.parameters.addProperty(parameterName, parameterValue);
        return this;
    }

    @Override
    public IFeatureBuilder setParameter(String parameterName, int parameterValue) {
        this.parameters.addProperty(parameterName, (Number)parameterValue);
        return this;
    }

    @Override
    public IFeatureBuilder setParameter(String parameterName, float parameterValue) {
        this.parameters.addProperty(parameterName, (Number)Float.valueOf(parameterValue));
        return this;
    }

    @Override
    public IFeatureBuilder setParameter(String parameterName, boolean parameterValue) {
        this.parameters.addProperty(parameterName, Boolean.valueOf(parameterValue));
        return this;
    }

    @Override
    public IFeatureBuilder setParameter(String parameterName, JsonElement parameterValue) {
        this.parameters.add(parameterName, parameterValue);
        return this;
    }

    private void setFeatureParameter(String parameterName, JsonElement parameterValue, FeatureEntry feat) {
        if (parameterValue.getAsJsonPrimitive().isBoolean()) {
            feat.setParameter(parameterName, parameterValue.getAsBoolean());
        } else if (parameterValue.getAsJsonPrimitive().isString()) {
            feat.setParameter(parameterName, parameterValue.getAsString());
        } else {
            float paramAsFloat = parameterValue.getAsFloat();
            if ((double)paramAsFloat - Math.floor(paramAsFloat) > 0.0) {
                feat.setParameter(parameterName, parameterValue.getAsFloat());
            } else {
                feat.setParameter(parameterName, parameterValue.getAsInt());
            }
        }
    }

    @Override
    public IFeatureBuilder setUseFeatureDefaults() {
        this.useDefaults = true;
        return this;
    }

    @Override
    public IFeatureEntry create() {
        FeatureEntry res = new FeatureEntry(this.feature);
        if (!this.useDefaults) {
            this.feature.getDefaultParameters().entrySet().stream().filter(ent -> !this.parameters.has((String)ent.getKey())).forEach(ent -> this.parameters.add((String)ent.getKey(), (JsonElement)ent.getValue()));
        } else {
            this.feature.getDefaultParameters().entrySet().stream().forEach(ent -> this.parameters.add((String)ent.getKey(), (JsonElement)ent.getValue()));
        }
        this.parameters.entrySet().stream().forEach(ent -> this.setFeatureParameter((String)ent.getKey(), (JsonElement)ent.getValue(), res));
        return res;
    }
}

