/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn.impl.os3;

import com.mcmoddev.orespawn.OreSpawn;
import com.mcmoddev.orespawn.api.os3.IReplacementBuilder;
import com.mcmoddev.orespawn.api.os3.IReplacementEntry;
import com.mcmoddev.orespawn.impl.os3.ReplacementEntry;
import com.mcmoddev.orespawn.util.StateUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.lang3.RandomStringUtils;

public class ReplacementBuilder
implements IReplacementBuilder {
    private String replacementName = null;
    private List<IBlockState> entries = new LinkedList<IBlockState>();

    @Override
    public IReplacementBuilder setFromName(String entryName) {
        this.replacementName = entryName;
        this.entries.addAll(OreSpawn.API.getReplacement(entryName).getEntries());
        return this;
    }

    @Override
    public IReplacementBuilder setName(String name) {
        this.replacementName = name;
        return this;
    }

    @Override
    public IReplacementBuilder addEntry(IBlockState blockState) {
        this.entries.add(blockState);
        return this;
    }

    @Override
    public IReplacementBuilder addEntry(String blockName) {
        return this.addEntry(new ResourceLocation(blockName));
    }

    @Override
    public IReplacementBuilder addEntry(String blockName, String state) {
        return this.addEntry(new ResourceLocation(blockName), state);
    }

    @Override
    @Deprecated
    public IReplacementBuilder addEntry(String blockName, int metadata) {
        return this.addEntry(new ResourceLocation(blockName), metadata);
    }

    @Override
    public IReplacementBuilder addEntry(ResourceLocation blockResourceLocation) {
        return this.addEntry(((Block)ForgeRegistries.BLOCKS.getValue(blockResourceLocation)).func_176223_P());
    }

    @Override
    public IReplacementBuilder addEntry(ResourceLocation blockResourceLocation, String state) {
        try {
            return this.addEntry(StateUtil.deserializeState((Block)ForgeRegistries.BLOCKS.getValue(blockResourceLocation), state));
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.addEntry(((Block)ForgeRegistries.BLOCKS.getValue(blockResourceLocation)).func_176223_P());
        }
    }

    @Override
    @Deprecated
    public IReplacementBuilder addEntry(ResourceLocation blockResourceLocation, int metadata) {
        return this.addEntry(((Block)ForgeRegistries.BLOCKS.getValue(blockResourceLocation)).func_176203_a(metadata));
    }

    @Override
    public boolean hasEntries() {
        return !this.entries.isEmpty();
    }

    @Override
    public IReplacementEntry create() {
        if (this.replacementName == null) {
            this.replacementName = String.format(Locale.ENGLISH, "replacement_%s", RandomStringUtils.randomAlphanumeric((int)8, (int)16));
        }
        return new ReplacementEntry(this.replacementName, this.entries);
    }
}

