/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn.json;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.mcmoddev.orespawn.OreSpawn;
import com.mcmoddev.orespawn.api.exceptions.BadValueException;
import com.mcmoddev.orespawn.api.exceptions.MissingVersionException;
import com.mcmoddev.orespawn.api.exceptions.NotAProperConfigException;
import com.mcmoddev.orespawn.api.exceptions.OldVersionException;
import com.mcmoddev.orespawn.api.exceptions.UnknownFieldException;
import com.mcmoddev.orespawn.api.exceptions.UnknownNameException;
import com.mcmoddev.orespawn.api.exceptions.UnknownVersionException;
import com.mcmoddev.orespawn.api.os3.IBiomeBuilder;
import com.mcmoddev.orespawn.api.os3.IBlockBuilder;
import com.mcmoddev.orespawn.api.os3.IDimensionBuilder;
import com.mcmoddev.orespawn.api.os3.IFeatureBuilder;
import com.mcmoddev.orespawn.api.os3.IReplacementBuilder;
import com.mcmoddev.orespawn.api.os3.ISpawnBuilder;
import com.mcmoddev.orespawn.data.PresetsStorage;
import com.mcmoddev.orespawn.util.StateUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;

public class OreSpawnReader {
    private static final String ORE_SPAWN_VERSION = "OreSpawn Version";
    private static final String WHITELIST_ERROR = "Skipping entry (%s) in whitelist, not a proper value";
    private static final String BLACKLIST_ERROR = "Skipping entry (%s) in blacklist, not a proper value";

    private OreSpawnReader() {
    }

    private static JsonElement doPresetFix(JsonElement value, PresetsStorage configPresets) {
        if (value.isJsonObject()) {
            return OreSpawnReader.doPresetForObject(value.getAsJsonObject(), configPresets);
        }
        if (value.isJsonArray()) {
            return OreSpawnReader.doPresetForArray(value.getAsJsonArray(), configPresets);
        }
        if (value.isJsonPrimitive() && !value.isJsonNull()) {
            if (value.getAsJsonPrimitive().isString() && value.getAsString().matches("^\\$.*")) {
                return configPresets.get(value.getAsString());
            }
            return value;
        }
        OreSpawn.LOGGER.error("Error handling presets for config, unknown value type for item " + value.toString());
        return value;
    }

    public static void tryReadFile(Path conf) throws MissingVersionException, NotAProperConfigException, OldVersionException, UnknownVersionException {
        JsonParser parser = new JsonParser();
        try (BufferedReader data = Files.newBufferedReader(conf);){
            JsonElement json = parser.parse((Reader)data);
            if (!json.isJsonObject()) {
                throw new NotAProperConfigException();
            }
            JsonObject root = json.getAsJsonObject();
            if (!root.has("version")) {
                throw new MissingVersionException();
            }
            float version = root.get("version").getAsFloat();
            if (version < 2.0f) {
                throw new OldVersionException();
            }
            if (version != 2.0f) {
                throw new UnknownVersionException();
            }
            if (!root.has("spawns")) {
                throw new NotAProperConfigException();
            }
            JsonObject spawnData = OreSpawnReader.doHandlePresets(root).get("spawns").getAsJsonObject();
            spawnData.entrySet().stream().forEach(e -> {
                try {
                    OreSpawn.API.mapEntryToFile(conf, (String)e.getKey());
                    OreSpawnReader.loadSingleEntry(e);
                }
                catch (BadValueException | UnknownFieldException | UnknownNameException e1) {
                    CrashReport report = CrashReport.func_85055_a((Throwable)e1, (String)("Error parsing an entry " + (String)e.getKey() + " in " + conf.toString()));
                    report.func_85056_g().func_71507_a(ORE_SPAWN_VERSION, (Object)"3.3.1");
                    OreSpawn.LOGGER.info(report.func_71502_e());
                }
            });
        }
        catch (IOException e2) {
            CrashReport report = CrashReport.func_85055_a((Throwable)e2, (String)("Failed reading config data " + conf.toString()));
            report.func_85056_g().func_71507_a(ORE_SPAWN_VERSION, (Object)"3.3.1");
            OreSpawn.LOGGER.info(report.func_71502_e());
        }
        catch (JsonIOException | JsonSyntaxException e3) {
            CrashReport report = CrashReport.func_85055_a((Throwable)e3, (String)("JSON Parsing Error in " + conf.toString()));
            report.func_85056_g().func_71507_a(ORE_SPAWN_VERSION, (Object)"3.3.1");
            OreSpawn.LOGGER.info(report.func_71502_e());
        }
    }

    private static JsonObject doHandlePresets(JsonObject spawnData) {
        PresetsStorage configPresets = OreSpawn.API.copyPresets();
        if (spawnData.has("presets")) {
            spawnData.get("presets").getAsJsonObject().entrySet().stream().forEach(entry -> {
                String section = (String)entry.getKey();
                ((JsonElement)entry.getValue()).getAsJsonObject().entrySet().stream().forEach(sect -> configPresets.setSymbolSection(section, (String)sect.getKey(), (JsonElement)sect.getValue()));
            });
        }
        JsonObject spawnDataFixed = new JsonObject();
        for (Map.Entry elem : spawnData.get("spawns").getAsJsonObject().entrySet()) {
            spawnDataFixed.add((String)elem.getKey(), OreSpawnReader.doPresetFix((JsonElement)elem.getValue(), configPresets));
        }
        return spawnData;
    }

    private static JsonElement doPresetForArray(JsonArray value, PresetsStorage configPresets) {
        JsonArray rv = new JsonArray();
        value.forEach(it -> rv.add(OreSpawnReader.doPresetFix(it, configPresets)));
        return rv;
    }

    private static JsonElement doPresetForObject(JsonObject value, PresetsStorage configPresets) {
        JsonObject rv = new JsonObject();
        value.entrySet().stream().forEach(entry -> rv.add((String)entry.getKey(), OreSpawnReader.doPresetFix((JsonElement)entry.getValue(), configPresets)));
        return rv;
    }

    public static void loadFromJson(String name, JsonElement json) {
        AbstractMap.SimpleEntry<String, JsonElement> t = new AbstractMap.SimpleEntry<String, JsonElement>(name, json);
        try {
            OreSpawnReader.loadSingleEntry(t);
        }
        catch (BadValueException | UnknownFieldException | UnknownNameException e) {
            CrashReport report = CrashReport.func_85055_a((Throwable)e, (String)("Error parsing an manual JSON read for " + name));
            report.func_85056_g().func_71507_a(ORE_SPAWN_VERSION, (Object)"3.3.1");
            OreSpawn.LOGGER.info(report.func_71502_e());
        }
    }

    private static void loadSingleEntry(Map.Entry<String, JsonElement> entry) throws UnknownFieldException, BadValueException, UnknownNameException {
        ISpawnBuilder sb = OreSpawn.API.getSpawnBuilder();
        IFeatureBuilder fb = OreSpawn.API.getFeatureBuilder();
        sb.setName(entry.getKey());
        block20: for (Map.Entry ent : entry.getValue().getAsJsonObject().entrySet()) {
            switch ((String)ent.getKey()) {
                case "retrogen": {
                    sb.setRetrogen(((JsonElement)ent.getValue()).getAsBoolean());
                    continue block20;
                }
                case "enabled": {
                    sb.setEnabled(((JsonElement)ent.getValue()).getAsBoolean());
                    continue block20;
                }
                case "dimensions": {
                    IDimensionBuilder db = OreSpawn.API.getDimensionBuilder();
                    OreSpawnReader.loadDimensionEntry(db, ent);
                    sb.setDimensions(db.create());
                    continue block20;
                }
                case "biomes": {
                    if (!((JsonElement)ent.getValue()).isJsonObject()) {
                        throw new BadValueException("biomes", ((JsonElement)ent.getValue()).toString());
                    }
                    IBiomeBuilder bb = OreSpawn.API.getBiomeBuilder();
                    OreSpawnReader.loadBiomes(bb, ((JsonElement)ent.getValue()).getAsJsonObject());
                    sb.setBiomes(bb.create());
                    continue block20;
                }
                case "feature": {
                    fb.setFeature(OreSpawnReader.loadFeatureEntry(ent));
                    continue block20;
                }
                case "replaces": {
                    IReplacementBuilder rb = OreSpawn.API.getReplacementBuilder();
                    OreSpawnReader.loadReplacements(rb, ent);
                    if (!rb.hasEntries()) continue block20;
                    sb.setReplacement(rb.create());
                    continue block20;
                }
                case "blocks": {
                    OreSpawnReader.loadBlocks(sb, ent);
                    continue block20;
                }
                case "parameters": {
                    if (!((JsonElement)ent.getValue()).isJsonObject()) continue block20;
                    ((JsonElement)ent.getValue()).getAsJsonObject().entrySet().stream().forEach(e -> fb.setParameter((String)e.getKey(), (JsonElement)e.getValue()));
                    continue block20;
                }
            }
            throw new UnknownFieldException((String)ent.getKey());
        }
        sb.setFeature(fb.create());
        OreSpawn.API.addSpawn(sb.create());
    }

    private static String loadFeatureEntry(Map.Entry<String, JsonElement> ent) throws BadValueException, UnknownNameException {
        if (ent.getValue().isJsonPrimitive() && !ent.getValue().getAsJsonPrimitive().isString()) {
            throw new BadValueException("feature", ent.getValue().toString());
        }
        String featureName = ent.getValue().getAsString();
        if (!OreSpawn.API.featureExists(featureName)) {
            throw new UnknownNameException("feature", featureName);
        }
        return featureName;
    }

    private static void loadBlocks(ISpawnBuilder sb, Map.Entry<String, JsonElement> ent) throws BadValueException {
        if (ent.getValue().isJsonArray()) {
            for (JsonElement elem : ent.getValue().getAsJsonArray()) {
                IBlockBuilder block = OreSpawn.API.getBlockBuilder();
                if (elem.isJsonObject()) {
                    JsonObject bl = elem.getAsJsonObject();
                    if (bl.has("state")) {
                        block.setFromNameWithChance(bl.get("name").getAsString(), bl.get("state").getAsString(), bl.get("chance").getAsInt());
                    } else if (bl.has("metaData")) {
                        block.setFromNameWithChance(bl.get("name").getAsString(), bl.get("metaData").getAsInt(), bl.get("chance").getAsInt());
                    } else {
                        block.setFromNameWithChance(bl.get("name").getAsString(), bl.get("chance").getAsInt());
                    }
                    sb.addBlock(block.create());
                    continue;
                }
                OreSpawn.LOGGER.error("Skipping value %s in blocks list as it is not the correct format", (Object)elem.toString());
            }
        } else {
            throw new BadValueException("blocks", ent.getValue().toString());
        }
    }

    private static void loadReplacements(IReplacementBuilder rb, Map.Entry<String, JsonElement> ent) throws BadValueException {
        if (!ent.getValue().isJsonArray() && !ent.getValue().getAsJsonPrimitive().isString()) {
            throw new BadValueException("replaces", ent.getValue().toString());
        }
        if (ent.getValue().isJsonPrimitive() && ent.getValue().getAsJsonPrimitive().isString()) {
            if (OreSpawn.API.hasReplacement(ent.getValue().getAsString())) {
                rb.setFromName(ent.getValue().getAsString());
            }
        } else {
            for (JsonElement e : ent.getValue().getAsJsonArray()) {
                if (e.isJsonObject()) {
                    OreSpawnReader.loadBlock(e.getAsJsonObject()).stream().forEach(rb::addEntry);
                    continue;
                }
                OreSpawn.LOGGER.error("Skipping value %s in replacements list as it is not the correct format", (Object)e.toString());
            }
        }
    }

    private static void loadDimensionEntry(IDimensionBuilder db, Map.Entry<String, JsonElement> ent) throws BadValueException {
        if (ent.getValue().isJsonArray()) {
            JsonArray dims = ent.getValue().getAsJsonArray();
            if (dims.size() == 0) {
                db.setAcceptAllOverworld();
            } else {
                dims.forEach(item -> {
                    if (item.isJsonPrimitive() && item.getAsJsonPrimitive().isNumber()) {
                        db.addWhitelistEntry(item.getAsInt());
                    }
                });
            }
        } else if (ent.getValue().isJsonObject()) {
            OreSpawnReader.loadDimensions(db, ent.getValue().getAsJsonObject());
        } else {
            throw new BadValueException("dimensions", ent.getValue().toString());
        }
    }

    private static List<IBlockState> loadBlock(JsonObject json) {
        String blockName = json.get("name").getAsString();
        if (json.has("state")) {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockName));
            try {
                return Arrays.asList(StateUtil.deserializeState(block, json.get("state").getAsString()));
            }
            catch (Exception e) {
                e.printStackTrace();
                return Arrays.asList(block.func_176223_P());
            }
        }
        if (json.has("metaData")) {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockName));
            return Arrays.asList(block.func_176203_a(json.get("metaData").getAsInt()));
        }
        if (blockName.startsWith("ore:")) {
            String entry = blockName.split(":")[1];
            return ImmutableList.copyOf((Collection)OreDictionary.getOres((String)entry, (boolean)false).stream().map(is -> {
                Block b = Block.func_149634_a((Item)is.func_77973_b());
                return b.func_176203_a(is.func_77960_j());
            }).collect(Collectors.toList()));
        }
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockName));
        return Arrays.asList(block.func_176223_P());
    }

    private static void loadBiomes(IBiomeBuilder bb, JsonObject biomeList) {
        boolean emptyWhitelist = false;
        if (biomeList.has("includes") && biomeList.get("includes").getAsJsonArray().size() > 0) {
            OreSpawnReader.loadBiomeWhitelist(bb, biomeList.get("includes").getAsJsonArray());
        } else {
            emptyWhitelist = true;
        }
        if (biomeList.has("excludes") && biomeList.get("excludes").getAsJsonArray().size() > 0) {
            OreSpawnReader.loadBiomeBlacklist(bb, biomeList.get("excludes").getAsJsonArray());
        } else if (emptyWhitelist) {
            bb.setAcceptAll();
        }
    }

    private static void loadBiomeBlacklist(IBiomeBuilder bb, JsonArray blacklist) {
        for (JsonElement elem : blacklist) {
            if (elem.isJsonPrimitive() && elem.getAsJsonPrimitive().isString()) {
                String xN = elem.getAsString();
                if (xN.contains(":")) {
                    bb.addBlacklistEntry(xN);
                    continue;
                }
                BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.getType((String)xN, (BiomeDictionary.Type[])new BiomeDictionary.Type[0])).stream().forEach(bb::addBlacklistEntry);
                continue;
            }
            OreSpawn.LOGGER.error(BLACKLIST_ERROR, (Object)elem.getAsString());
        }
    }

    private static void loadBiomeWhitelist(IBiomeBuilder bb, JsonArray whitelist) {
        for (JsonElement elem : whitelist) {
            if (elem.isJsonPrimitive() && elem.getAsJsonPrimitive().isString()) {
                String xN = elem.getAsString();
                if (xN.contains(":")) {
                    bb.addWhitelistEntry(xN);
                    continue;
                }
                BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.getType((String)xN, (BiomeDictionary.Type[])new BiomeDictionary.Type[0])).stream().forEach(bb::addWhitelistEntry);
                continue;
            }
            OreSpawn.LOGGER.error(WHITELIST_ERROR, (Object)elem.getAsString());
        }
    }

    private static void loadDimensions(IDimensionBuilder db, JsonObject dimensionList) {
        boolean emptyWhitelist = false;
        if (dimensionList.has("includes") && dimensionList.get("includes").getAsJsonArray().size() > 0) {
            OreSpawnReader.loadDimensionWhitelist(db, dimensionList.get("includes").getAsJsonArray());
        } else {
            emptyWhitelist = true;
        }
        if (dimensionList.has("excludes") && dimensionList.get("excludes").getAsJsonArray().size() > 0) {
            OreSpawnReader.loadDimensionBlacklist(db, dimensionList.get("excludes").getAsJsonArray());
        } else if (emptyWhitelist) {
            db.setAcceptAllOverworld();
        }
    }

    private static void loadDimensionBlacklist(IDimensionBuilder db, JsonArray blacklist) {
        for (JsonElement elem : blacklist) {
            if (elem.isJsonPrimitive() && elem.getAsJsonPrimitive().isNumber()) {
                db.addBlacklistEntry(elem.getAsInt());
                continue;
            }
            OreSpawn.LOGGER.error(WHITELIST_ERROR, (Object)elem.getAsString());
        }
    }

    private static void loadDimensionWhitelist(IDimensionBuilder db, JsonArray whitelist) {
        for (JsonElement elem : whitelist) {
            if (elem.isJsonPrimitive() && elem.getAsJsonPrimitive().isNumber()) {
                db.addWhitelistEntry(elem.getAsInt());
                continue;
            }
            OreSpawn.LOGGER.error(BLACKLIST_ERROR, (Object)elem.getAsString());
        }
    }
}

