/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn.util;

import com.google.common.base.Optional;
import com.mcmoddev.orespawn.OreSpawn;
import com.mcmoddev.orespawn.api.exceptions.BadStateValueException;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;

public class StateUtil {
    private StateUtil() {
        throw new InstantiationError("This class cannot be instantiated!");
    }

    public static String serializeState(IBlockState state) {
        String string = state.toString();
        if ((string = string.substring(string.indexOf(91) + 1, string.length() - (string.endsWith("]") ? 1 : 0))).equals(state.func_177230_c().getRegistryName().toString())) {
            string = "normal";
        }
        OreSpawn.LOGGER.debug("State is %s (for block %s)", (Object)string, (Object)state.func_177230_c().getRegistryName());
        return string;
    }

    public static IBlockState deserializeState(Block block, String state) throws Exception {
        String[] bits = state.contains(",") ? state.split(",") : new String[]{state};
        IBlockState rv = block.func_176223_P();
        for (String sv : bits) {
            Optional propValue;
            String[] kvp = sv.split("=");
            IProperty prop = block.func_176194_O().func_185920_a(kvp[0]);
            if (prop != null) {
                propValue = prop.func_185929_b(kvp[1]);
                if (!propValue.isPresent()) {
                    throw new BadStateValueException(String.format("%s is not a valid value for property %s", kvp[1], kvp[0]));
                }
            } else {
                throw new BadStateValueException(String.format("%s is not a known property of %s", kvp[0], block.getRegistryName()));
            }
            rv = rv.func_177226_a(prop, (Comparable)propValue.get());
        }
        return rv;
    }
}

