/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn;

import com.mcmoddev.orespawn.OreSpawn;
import com.mcmoddev.orespawn.api.os3.BuilderLogic;
import com.mcmoddev.orespawn.api.os3.DimensionBuilder;
import com.mcmoddev.orespawn.api.os3.SpawnBuilder;
import com.mcmoddev.orespawn.data.Config;
import java.util.Arrays;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.stream.Collectors;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class EventHandlers {
    private Deque<ChunkPos> chunks;
    private Deque<ChunkPos> retroChunks;
    private List<OreGenEvent.GenerateMinable.EventType> vanillaEvents = Arrays.asList(OreGenEvent.GenerateMinable.EventType.ANDESITE, OreGenEvent.GenerateMinable.EventType.COAL, OreGenEvent.GenerateMinable.EventType.DIAMOND, OreGenEvent.GenerateMinable.EventType.DIORITE, OreGenEvent.GenerateMinable.EventType.DIRT, OreGenEvent.GenerateMinable.EventType.EMERALD, OreGenEvent.GenerateMinable.EventType.GOLD, OreGenEvent.GenerateMinable.EventType.GRANITE, OreGenEvent.GenerateMinable.EventType.GRAVEL, OreGenEvent.GenerateMinable.EventType.IRON, OreGenEvent.GenerateMinable.EventType.LAPIS, OreGenEvent.GenerateMinable.EventType.REDSTONE, OreGenEvent.GenerateMinable.EventType.QUARTZ, OreGenEvent.GenerateMinable.EventType.SILVERFISH);

    EventHandlers() {
        this.chunks = new ConcurrentLinkedDeque<ChunkPos>();
        this.retroChunks = new ConcurrentLinkedDeque<ChunkPos>();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void onGenerateMinable(OreGenEvent.GenerateMinable event) {
        if (Config.getBoolean("Replace Vanilla Oregen") && this.vanillaEvents.contains(event.getType())) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onChunkSave(ChunkDataEvent.Save ev) {
        NBTTagCompound dataTag = ev.getData().func_74775_l("MMD OreSpawn Data");
        NBTTagList ores = new NBTTagList();
        NBTTagList features = new NBTTagList();
        features.func_74742_a((NBTBase)new NBTTagString("orespawn:default"));
        List<DimensionBuilder> spawns = OreSpawn.API.getSpawns().entrySet().stream().filter(ent -> ((BuilderLogic)ent.getValue()).getAllDimensions().containsKey((Object)ev.getWorld().field_73011_w.getDimension())).map(ent -> ((BuilderLogic)ent.getValue()).getDimension(ev.getWorld().field_73011_w.getDimension())).collect(Collectors.toList());
        if (ev.getWorld().field_73011_w.getDimension() > 0 && ev.getWorld().field_73011_w.getDimension() != 1) {
            spawns.addAll(OreSpawn.API.getSpawns().entrySet().stream().filter(ent -> ((BuilderLogic)ent.getValue()).getAllDimensions().containsKey((Object)OreSpawn.API.dimensionWildcard())).map(ent -> ((BuilderLogic)ent.getValue()).getDimension(OreSpawn.API.dimensionWildcard())).collect(Collectors.toList()));
        }
        LinkedList spc = new LinkedList();
        LinkedList oreList = new LinkedList();
        spawns.stream().map(DimensionBuilder::getAllSpawns).forEach(spc::addAll);
        spc.stream().map(SpawnBuilder::getOres).forEach(oreList::addAll);
        oreList.stream().map(oreEnt -> new NBTTagString(oreEnt.getOre().func_177230_c().getRegistryName().toString())).forEach(arg_0 -> ((NBTTagList)ores).func_74742_a(arg_0));
        LinkedList featureList = new LinkedList();
        spawns.forEach(sp -> featureList.addAll(sp.getAllSpawns().stream().map(SpawnBuilder::getFeatureGen).collect(Collectors.toList())));
        featureList.stream().map(feat -> new NBTTagString(feat.getFeatureName())).forEach(arg_0 -> ((NBTTagList)features).func_74742_a(arg_0));
        ChunkPos chunkCoords = new ChunkPos(ev.getChunk().field_76635_g, ev.getChunk().field_76647_h);
        if (!Config.getBoolean("Retrogen") || this.chunks.contains(chunkCoords)) {
            dataTag.func_74782_a("ores", (NBTBase)ores);
            dataTag.func_74782_a("features", (NBTBase)features);
        }
        ev.getData().func_74782_a("MMD OreSpawn Data", (NBTBase)dataTag);
    }

    @SubscribeEvent
    public void onChunkLoad(ChunkDataEvent.Load ev) {
        NBTTagCompound chunkTag;
        World world = ev.getWorld();
        ChunkPos chunkCoords = new ChunkPos(ev.getChunk().field_76635_g, ev.getChunk().field_76647_h);
        this.doBedrockRetrogen(chunkCoords);
        if (this.chunks.contains(chunkCoords)) {
            return;
        }
        if (Config.getBoolean("Retrogen") && (this.featuresAreDifferent(chunkTag = ev.getData().func_74775_l("MMD OreSpawn Data"), world.field_73011_w.getDimension()) || Config.getBoolean("Force Retrogen"))) {
            this.chunks.addLast(chunkCoords);
        }
    }

    private boolean featuresAreDifferent(NBTTagCompound chunkTag, int dim) {
        return this.countOres(dim) != chunkTag.func_150295_c("ores", 8).func_74745_c() || this.compFeatures(chunkTag.func_150295_c("features", 8), dim);
    }

    private boolean compFeatures(NBTTagList tagList, int dim) {
        List<DimensionBuilder> spawns = OreSpawn.API.getSpawns().entrySet().stream().filter(ent -> ((BuilderLogic)ent.getValue()).getAllDimensions().containsKey((Object)dim)).map(ent -> ((BuilderLogic)ent.getValue()).getDimension(dim)).collect(Collectors.toList());
        if (dim > 0 && dim != 1) {
            spawns.addAll(OreSpawn.API.getSpawns().entrySet().stream().filter(ent -> ((BuilderLogic)ent.getValue()).getAllDimensions().containsKey((Object)OreSpawn.API.dimensionWildcard())).map(ent -> ((BuilderLogic)ent.getValue()).getDimension(OreSpawn.API.dimensionWildcard())).collect(Collectors.toList()));
        }
        LinkedList featureList = new LinkedList();
        spawns.forEach(sp -> featureList.addAll(sp.getAllSpawns().stream().map(SpawnBuilder::getFeatureGen).collect(Collectors.toList())));
        return featureList.size() == tagList.func_74745_c();
    }

    private void doBedrockRetrogen(ChunkPos chunkCoords) {
        if (this.retroChunks.contains(chunkCoords)) {
            return;
        }
        if (Config.getBoolean("Retrogen Flat Bedrock")) {
            this.retroChunks.addLast(chunkCoords);
        }
    }

    private int countOres(int dim) {
        int acc = 0;
        for (Map.Entry sL : OreSpawn.API.getSpawns().entrySet()) {
            if (((BuilderLogic)sL.getValue()).getAllDimensions().containsKey((Object)dim)) {
                acc += ((DimensionBuilder)((BuilderLogic)sL.getValue()).getAllDimensions().get((Object)dim)).getAllSpawns().size();
            }
            if (!((BuilderLogic)sL.getValue()).getAllDimensions().containsKey((Object)OreSpawn.API.dimensionWildcard())) continue;
            acc += ((DimensionBuilder)((BuilderLogic)sL.getValue()).getAllDimensions().get((Object)OreSpawn.API.dimensionWildcard())).getAllSpawns().size();
        }
        return acc;
    }

    @SubscribeEvent
    public void worldTick(TickEvent.WorldTickEvent ev) {
        if (ev.side != Side.SERVER) {
            return;
        }
        World world = ev.world;
        if (ev.phase == TickEvent.Phase.END) {
            ChunkPos p;
            int c;
            for (c = 0; c < 5 && !this.chunks.isEmpty(); ++c) {
                p = this.chunks.pop();
                Random random = new Random(world.func_72905_C());
                random.setSeed((random.nextLong() >> 5) + (long)p.field_77276_a + ((random.nextLong() >> 3) + (long)p.field_77275_b) ^ world.func_72905_C());
                ChunkProviderServer chunkProvider = (ChunkProviderServer)world.func_72863_F();
                IChunkGenerator chunkGenerator = (IChunkGenerator)ObfuscationReflectionHelper.getPrivateValue(ChunkProviderServer.class, (Object)chunkProvider, (String[])new String[]{"field_186029_c", "chunkGenerator"});
                OreSpawn.API.getGenerator().generate(random, p.field_77276_a, p.field_77275_b, world, chunkGenerator, (IChunkProvider)chunkProvider);
            }
            for (c = 0; c < 5 && !this.retroChunks.isEmpty(); ++c) {
                p = this.retroChunks.pop();
                OreSpawn.flatBedrock.retrogen(world, p.field_77276_a, p.field_77275_b);
            }
        }
    }
}

