/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn.api;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mcmoddev.orespawn.OreSpawn;
import com.mcmoddev.orespawn.api.BiomeLocation;
import com.mcmoddev.orespawn.impl.location.BiomeLocationComposition;
import com.mcmoddev.orespawn.util.OreList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class FeatureBase {
    private static final int MAX_CACHE_SIZE = 2048;
    private static final Map<Vec3i, Map<BlockPos, IBlockState>> overflowCache = new HashMap<Vec3i, Map<BlockPos, IBlockState>>(2048);
    private static final Deque<Vec3i> cacheOrder = new LinkedList<Vec3i>();
    protected Random random;
    protected static final Vec3i[] offsets_small = new Vec3i[]{new Vec3i(0, 0, 0), new Vec3i(1, 0, 0), new Vec3i(0, 1, 0), new Vec3i(1, 1, 0), new Vec3i(0, 0, 1), new Vec3i(1, 0, 1), new Vec3i(0, 1, 1), new Vec3i(1, 1, 1)};
    protected static final Vec3i[] offsets = new Vec3i[]{new Vec3i(-1, -1, -1), new Vec3i(0, -1, -1), new Vec3i(1, -1, -1), new Vec3i(-1, 0, -1), new Vec3i(0, 0, -1), new Vec3i(1, 0, -1), new Vec3i(-1, 1, -1), new Vec3i(0, 1, -1), new Vec3i(1, 1, -1), new Vec3i(-1, -1, 0), new Vec3i(0, -1, 0), new Vec3i(1, -1, 0), new Vec3i(-1, 0, 0), new Vec3i(0, 0, 0), new Vec3i(1, 0, 0), new Vec3i(-1, 1, 0), new Vec3i(0, 1, 0), new Vec3i(1, 1, 0), new Vec3i(-1, -1, 1), new Vec3i(0, -1, 1), new Vec3i(1, -1, 1), new Vec3i(-1, 0, 1), new Vec3i(0, 0, 1), new Vec3i(1, 0, 1), new Vec3i(-1, 1, 1), new Vec3i(0, 1, 1), new Vec3i(1, 1, 1)};
    protected static final int[] offsetIndexRef = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26};
    protected static final int[] offsetIndexRef_small = new int[]{0, 1, 2, 3, 4, 5, 6, 7};

    public FeatureBase(Random rand) {
        this.random = rand;
    }

    private boolean fullMatch(ImmutableSet<BiomeLocation> locs, Biome biome) {
        for (BiomeLocation b : locs) {
            for (Biome bm : b.getBiomes()) {
                if (!bm.equals(biome)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean biomeMatch(Biome chunkBiome, BiomeLocation inp) {
        if (inp.getBiomes().isEmpty()) {
            return false;
        }
        if (inp instanceof BiomeLocationComposition) {
            BiomeLocationComposition loc = (BiomeLocationComposition)inp;
            boolean exclMatch = this.fullMatch(loc.getExclusions(), chunkBiome);
            boolean inclMatch = this.fullMatch(loc.getInclusions(), chunkBiome);
            if ((loc.getInclusions().isEmpty() || inclMatch) && !exclMatch) {
                return false;
            }
        } else if (inp.matches(chunkBiome)) {
            return false;
        }
        return true;
    }

    protected void runCache(int chunkX, int chunkZ, World world, List<IBlockState> blockReplace) {
        Vec3i chunkCoord = new Vec3i(chunkX, chunkZ, world.field_73011_w.getDimension());
        Map<BlockPos, IBlockState> cache = this.retrieveCache(chunkCoord);
        if (!cache.isEmpty()) {
            for (Map.Entry<BlockPos, IBlockState> ent : cache.entrySet()) {
                this.spawnNoCheck(cache.get(ent.getKey()), world, ent.getKey(), world.field_73011_w.getDimension(), blockReplace);
            }
        }
    }

    protected boolean spawn(IBlockState oreBlock, World world, BlockPos coord, int dimension, boolean cacheOverflow, List<IBlockState> blockReplace, BiomeLocation biomes) {
        if (oreBlock == null) {
            OreSpawn.LOGGER.fatal("FeatureBase.spawn() called with a null ore!");
            return false;
        }
        Biome thisBiome = world.func_180494_b(coord);
        if (this.biomeMatch(thisBiome, biomes)) {
            return false;
        }
        BlockPos np = this.mungeFixYcoord(coord);
        if (coord.func_177956_o() >= world.func_72800_K()) {
            OreSpawn.LOGGER.warn("Asked to spawn %s above build limit at %s", (Object)oreBlock, (Object)coord);
            return false;
        }
        return this.spawnOrCache(world, np, blockReplace, oreBlock, cacheOverflow, dimension);
    }

    private BlockPos mungeFixYcoord(BlockPos coord) {
        if (coord.func_177956_o() < 0) {
            int newYCoord = coord.func_177956_o() * -1;
            return new BlockPos(coord.func_177958_n(), newYCoord, coord.func_177952_p());
        }
        return new BlockPos((Vec3i)coord);
    }

    private boolean spawnOrCache(World world, BlockPos coord, List<IBlockState> blockReplace, IBlockState oreBlock, boolean cacheOverflow, int dimension) {
        if (world.func_175667_e(coord)) {
            IBlockState targetBlock = world.func_180495_p(coord);
            if (this.canReplace(targetBlock, blockReplace)) {
                world.func_175656_a(coord, oreBlock);
                return true;
            }
            return false;
        }
        if (cacheOverflow) {
            this.cacheOverflowBlock(oreBlock, coord, dimension);
            return true;
        }
        return false;
    }

    private void spawnNoCheck(IBlockState oreBlock, World world, BlockPos coord, int dimension, List<IBlockState> blockReplace) {
        if (oreBlock == null) {
            OreSpawn.LOGGER.fatal("FeatureBase.spawn() called with a null ore!");
            return;
        }
        BlockPos np = this.mungeFixYcoord(coord);
        if (coord.func_177956_o() >= world.func_72800_K()) {
            OreSpawn.LOGGER.warn("Asked to spawn %s above build limit at %s", (Object)oreBlock, (Object)coord);
            return;
        }
        this.spawnOrCache(world, np, blockReplace, oreBlock, false, dimension);
    }

    private void cacheOverflowBlock(IBlockState bs, BlockPos coord, int dimension) {
        Vec3i chunkCoord = new Vec3i(coord.func_177958_n() >> 4, coord.func_177956_o() >> 4, dimension);
        if (overflowCache.containsKey(chunkCoord)) {
            cacheOrder.addLast(chunkCoord);
            if (cacheOrder.size() > 2048) {
                Vec3i drop = cacheOrder.removeFirst();
                overflowCache.get(drop).clear();
                overflowCache.remove(drop);
            }
            overflowCache.put(chunkCoord, new HashMap());
        }
        Map cache = overflowCache.getOrDefault(chunkCoord, new HashMap());
        cache.put(coord, bs);
    }

    private Map<BlockPos, IBlockState> retrieveCache(Vec3i chunkCoord) {
        if (overflowCache.containsKey(chunkCoord)) {
            Map<BlockPos, IBlockState> cache = overflowCache.get(chunkCoord);
            cacheOrder.remove(chunkCoord);
            overflowCache.remove(chunkCoord);
            return cache;
        }
        return Collections.emptyMap();
    }

    protected void scramble(int[] target, Random prng) {
        for (int i = target.length - 1; i > 0; --i) {
            int n = prng.nextInt(i);
            int temp = target[i];
            target[i] = target[n];
            target[n] = temp;
        }
    }

    private boolean canReplace(IBlockState target, List<IBlockState> blockToReplace) {
        return !target.func_177230_c().equals(Blocks.field_150350_a) && blockToReplace.contains(target);
    }

    protected static void mergeDefaults(JsonObject parameters, JsonObject defaultParameters) {
        defaultParameters.entrySet().forEach(entry -> {
            if (!parameters.has((String)entry.getKey())) {
                parameters.add((String)entry.getKey(), (JsonElement)entry.getValue());
            }
        });
    }

    private double triangularDistribution(double a, double b, double c) {
        double base = (c - a) / (b - a);
        double rand = this.random.nextDouble();
        if (rand < base) {
            return a + Math.sqrt(rand * (b - a) * (c - a));
        }
        return b - Math.sqrt((1.0 - rand) * (b - a) * (b - c));
    }

    protected int getPoint(int lowerBound, int upperBound, int median) {
        int t = (int)Math.round(this.triangularDistribution(lowerBound, upperBound, median));
        return t - median;
    }

    protected void spawnMungeSW(World world, BlockPos blockPos, int rSqr, double radius, List<IBlockState> replaceBlock, int count, OreList possibleOres) {
        Random prng = this.random;
        int quantity = count;
        int dy = (int)(-1.0 * radius);
        while ((double)dy < radius) {
            for (int dx = (int)radius; dx >= (int)(-1.0 * radius); --dx) {
                for (int dz = (int)radius; dz >= (int)(-1.0 * radius); --dz) {
                    if (dx * dx + dy * dy + dz * dz <= rSqr) {
                        IBlockState oreBlock = possibleOres.getRandomOre(prng).getOre();
                        this.spawnOrCache(world, blockPos.func_177982_a(dx, dy, dz), replaceBlock, oreBlock, true, world.field_73011_w.getDimension());
                        --quantity;
                    }
                    if (quantity > 0) continue;
                    return;
                }
            }
            ++dy;
        }
    }

    protected void spawnMungeNE(World world, BlockPos blockPos, int rSqr, double radius, List<IBlockState> replaceBlock, int count, OreList possibleOres) {
        Random prng = this.random;
        int quantity = count;
        int dy = (int)(-1.0 * radius);
        while ((double)dy < radius) {
            int dz = (int)(-1.0 * radius);
            while ((double)dz < radius) {
                int dx = (int)(-1.0 * radius);
                while ((double)dx < radius) {
                    if (dx * dx + dy * dy + dz * dz <= rSqr) {
                        IBlockState oreBlock = possibleOres.getRandomOre(prng).getOre();
                        this.spawnOrCache(world, blockPos.func_177982_a(dx, dy, dz), replaceBlock, oreBlock, true, world.field_73011_w.getDimension());
                        --quantity;
                    }
                    if (quantity <= 0) {
                        return;
                    }
                    ++dx;
                }
                ++dz;
            }
            ++dy;
        }
    }

    protected int getABC(int dx, int dy, int dz) {
        return dx * dx + dy * dy + dz * dz;
    }

    protected int countItem(int dx, boolean toPositive) {
        return toPositive ? dx + 1 : dx - 1;
    }

    protected boolean endCheck(boolean toPositive, int dx, double radius) {
        return toPositive ? dx >= this.getStart(toPositive, radius) : (double)dx < radius;
    }

    protected int getStart(boolean toPositive, double radius) {
        return (int)(radius * (double)(toPositive ? 1 : -1));
    }

    public class FunctionParameterWrapper {
        private World world;
        private BlockPos blockPos;
        private List<IBlockState> replacements;
        private OreList ores;
        private BiomeLocation biomes;
        private ChunkPos chunkPos;
        private IBlockState block;

        public FunctionParameterWrapper() {
        }

        public FunctionParameterWrapper(FunctionParameterWrapper other) {
            this.world = other.getWorld();
            this.blockPos = other.getBlockPos();
            this.replacements = other.getReplacements();
            this.ores = other.getOres();
            this.biomes = other.getBiomes();
            this.chunkPos = other.getChunkPos();
            this.block = other.getBlock();
        }

        public BiomeLocation getBiomes() {
            return this.biomes;
        }

        public void setBiomes(BiomeLocation biomes) {
            this.biomes = biomes;
        }

        public World getWorld() {
            return this.world;
        }

        public void setWorld(World world) {
            this.world = world;
        }

        public BlockPos getBlockPos() {
            return this.blockPos;
        }

        public void setBlockPos(BlockPos blockPos) {
            this.blockPos = blockPos;
        }

        public List<IBlockState> getReplacements() {
            return this.replacements;
        }

        public void setReplacements(List<IBlockState> replacements) {
            this.replacements = replacements;
        }

        public OreList getOres() {
            return this.ores;
        }

        public void setOres(OreList ores) {
            this.ores = ores;
        }

        public ChunkPos getChunkPos() {
            return this.chunkPos;
        }

        public void setChunkPos(ChunkPos chunkPos) {
            this.chunkPos = chunkPos;
        }

        public IBlockState getBlock() {
            return this.block;
        }

        public void setBlock(IBlockState block) {
            this.block = block;
        }
    }
}

