/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn.api;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mcmoddev.orespawn.api.BiomeLocation;
import com.mcmoddev.orespawn.util.OreList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.ChunkPos;

public class GeneratorParameters {
    private final ChunkPos chunk;
    private final OreList ores;
    private final ImmutableList<IBlockState> replacements;
    private final JsonObject parameters = new JsonObject();
    private final BiomeLocation biomes;

    public GeneratorParameters(ChunkPos chunkPos, OreList oreList, List<IBlockState> replacementBlocks, BiomeLocation biomes, JsonObject generatorParameters) {
        for (Map.Entry stringJsonElementEntry : generatorParameters.entrySet()) {
            this.parameters.add((String)stringJsonElementEntry.getKey(), (JsonElement)stringJsonElementEntry.getValue());
        }
        this.chunk = new ChunkPos(chunkPos.field_77276_a, chunkPos.field_77275_b);
        this.ores = oreList;
        this.replacements = ImmutableList.copyOf(replacementBlocks);
        this.biomes = biomes;
    }

    public ChunkPos getChunk() {
        return this.chunk;
    }

    public BiomeLocation getBiomes() {
        return this.biomes;
    }

    public ImmutableList<IBlockState> getReplacements() {
        return this.replacements;
    }

    public JsonObject getParameters() {
        return this.parameters;
    }

    public OreList getOres() {
        return this.ores;
    }
}

