/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn.commands;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mcmoddev.orespawn.OreSpawn;
import com.mcmoddev.orespawn.api.os3.BiomeBuilder;
import com.mcmoddev.orespawn.api.os3.DimensionBuilder;
import com.mcmoddev.orespawn.api.os3.FeatureBuilder;
import com.mcmoddev.orespawn.api.os3.OreBuilder;
import com.mcmoddev.orespawn.api.os3.SpawnBuilder;
import com.mcmoddev.orespawn.data.ReplacementsRegistry;
import com.mcmoddev.orespawn.util.StateUtil;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class AddOreCommand
extends CommandBase {
    private static final String ALL = "all";

    public String func_71517_b() {
        return "addore";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/addore <file> <dimension|all> <options>";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (!(sender instanceof EntityPlayer)) {
            throw new CommandException("Only players can use this command", new Object[0]);
        }
        EntityPlayer player = (EntityPlayer)sender;
        ItemStack stack = player.func_184586_b(EnumHand.MAIN_HAND);
        String jsonArgs = null;
        if (stack == null) {
            throw new CommandException("You have no item in your main hand", new Object[0]);
        }
        if (!(stack.func_77973_b() instanceof ItemBlock)) {
            throw new CommandException("The item in your main hand isn't a block", new Object[0]);
        }
        if (args.length < 2) {
            throw new CommandException(this.func_71518_a(sender), new Object[0]);
        }
        if (args.length > 2) {
            jsonArgs = AddOreCommand.func_147178_a((ICommandSender)sender, (String[])args, (int)2).func_150260_c();
        }
        String file = args[0];
        IBlockState state = ((ItemBlock)stack.func_77973_b()).func_179223_d().func_176203_a(stack.func_77952_i());
        int dimension = OreSpawn.API.dimensionWildcard();
        try {
            if (!args[1].equalsIgnoreCase(ALL)) {
                dimension = Integer.parseInt(args[1]);
            }
        }
        catch (NumberFormatException e) {
            throw new CommandException(args[1] + " isn't a valid dimension", new Object[0]);
        }
        JsonObject ore = new JsonObject();
        JsonObject oreArgs = null;
        int size = 25;
        int variation = 12;
        int frequency = 20;
        int minHeight = 0;
        int maxHeight = 128;
        oreArgs = new JsonObject();
        oreArgs.addProperty("size", (Number)size);
        oreArgs.addProperty("variation", (Number)variation);
        oreArgs.addProperty("frequency", (Number)frequency);
        oreArgs.addProperty("minHeight", (Number)minHeight);
        oreArgs.addProperty("maxHeight", (Number)maxHeight);
        ore.addProperty("block", state.func_177230_c().getRegistryName().toString());
        ore.addProperty("state", StateUtil.serializeState(state));
        if (jsonArgs != null) {
            JsonObject newOreArgs = new JsonParser().parse(jsonArgs).getAsJsonObject();
            this.setProperties(oreArgs, newOreArgs);
        }
        this.setOre(ore, oreArgs);
        this.putFile(file, ore, dimension);
        player.func_146105_b((ITextComponent)new TextComponentString("Added " + state.func_177230_c().getRegistryName().toString() + " to the json"), true);
    }

    private void setProperties(JsonObject oreArgs, JsonObject newOreArgs) {
        for (Map.Entry ent : newOreArgs.entrySet()) {
            oreArgs.remove((String)ent.getKey());
            oreArgs.add((String)ent.getKey(), (JsonElement)ent.getValue());
        }
    }

    private void setOre(JsonObject ore, JsonObject oreArgs) {
        for (Map.Entry ent : oreArgs.entrySet()) {
            ore.add((String)ent.getKey(), (JsonElement)ent.getValue());
        }
    }

    private void putFile(String file, JsonObject ore, int id) {
        DimensionBuilder db = OreSpawn.API.getLogic(file).newDimensionBuilder(id);
        SpawnBuilder sb = db.newSpawnBuilder(null);
        OreBuilder ob = sb.newOreBuilder();
        String b = ore.get("block").getAsString();
        ore.remove("block");
        String s = ore.get("state").getAsString();
        ore.remove("state");
        if ("normal".equals(s)) {
            ob.setOre(b);
        } else {
            ob.setOre(b, s);
        }
        FeatureBuilder fb = sb.newFeatureBuilder("default");
        fb.setGenerator("default").setDefaultParameters().setParameters(ore);
        BiomeBuilder bb = sb.newBiomeBuilder();
        IBlockState rep = ReplacementsRegistry.getDimensionDefault(id).get(0);
        ArrayList<IBlockState> rl = new ArrayList<IBlockState>();
        rl.add(rep);
        sb.create(bb, fb, rl, ob);
        db.create(sb);
        OreSpawn.API.getLogic(file).create(db);
        OreSpawn.API.registerLogic(OreSpawn.API.getLogic(file));
        OreSpawn.writer.writeAddOreEntry(file);
    }

    public int compareTo(ICommand command) {
        return this.func_71517_b().compareTo(command.func_71517_b());
    }
}

