/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn.commands;

import com.mcmoddev.orespawn.worldgen.OreSpawnWorldGen;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class ClearChunkCommand
extends CommandBase {
    private static final String STONE_ID = "minecraft:stone";
    private static final List<String> stoneVariants = Arrays.asList("minecraft:stone", "minecraft:diorite", "minecraft:andesite", "minecraft:granite", "minecraft:sandstone", "minecraft:red_sandstone", "minecraft:netherrack", "minecraft:end_stone");
    private static final List<String> baseStones = Arrays.asList("minecraft:stone", "minecraft:netherrack", "minecraft:end_stone", "minecraft:cobblestone", "minecraft:obsidian", "minecraft:magma", "minecraft:soul_sand");
    private static final List<String> dirtVariants = Arrays.asList("minecraft:dirt", "minecraft:grass");
    private static final List<String> otherVariants = Arrays.asList("minecraft:gravel", "minecraft:sand");

    public String func_71517_b() {
        return "clearchunk";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/clearchunk <viewores|dirtandgravel|classic>";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (!(sender instanceof EntityPlayer)) {
            throw new CommandException("Only players can use this command", new Object[0]);
        }
        EntityPlayer player = (EntityPlayer)sender;
        Chunk chunk = player.func_130014_f_().func_175726_f(player.func_180425_c());
        ChunkPos chunkPos = chunk.func_76632_l();
        boolean flagClassic = args.length > 0 ? args[0].toLowerCase().equalsIgnoreCase("classic") : false;
        LinkedList<String> blockNames = new LinkedList<String>();
        this.getBlocks(args, blockNames);
        List<Block> blocks = blockNames.stream().map(blockName -> (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockName))).collect(Collectors.toList());
        List<Block> overburden = Arrays.asList("minecraft:dirt", "minecraft:sand", "minecraft:gravel", "minecraft:grass", "minecraft:sandstone", "minecraft:red_sandstone").stream().map(blockName -> (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockName))).collect(Collectors.toList());
        this.clearBlocks(chunkPos, blocks, overburden, flagClassic, player);
        player.func_146105_b((ITextComponent)new TextComponentString("chunk " + chunkPos.toString() + " cleared"), true);
    }

    private void clearBlocks(ChunkPos chunkPos, List<Block> blocks, List<Block> overburden, boolean flagClassic, EntityPlayer player) {
        for (int x = chunkPos.func_180334_c(); x <= chunkPos.func_180332_e(); ++x) {
            for (int y = 256; y >= 0; --y) {
                for (int z = chunkPos.func_180333_d(); z <= chunkPos.func_180330_f(); ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    Block block = player.func_130014_f_().func_180495_p(pos).func_177230_c();
                    this.removeIfBlocks(player, pos, block, blocks, overburden, !flagClassic);
                    this.removeIfFluid(pos, player);
                }
            }
        }
    }

    private void removeIfFluid(BlockPos pos, EntityPlayer player) {
        IBlockState bs;
        if (player.func_130014_f_().func_180495_p(pos).func_185904_a().func_76224_d() && ((bs = player.func_130014_f_().func_180495_p(pos)).func_185904_a().equals(Material.field_151587_i) || bs.func_185904_a().equals(Material.field_151586_h))) {
            player.func_130014_f_().func_175698_g(pos);
        }
    }

    private void removeIfBlocks(EntityPlayer player, BlockPos pos, Block block, List<Block> blocks, List<Block> overburden, boolean flagClassic) {
        if (blocks.contains(block) || pos.func_177956_o() >= 64 && overburden.contains(block) && flagClassic) {
            player.func_130014_f_().func_175698_g(pos);
        }
    }

    private void getBlocks(String[] args, List<String> blockNames) {
        if (args.length > 0) {
            switch (args[0].toLowerCase()) {
                case "viewores": {
                    blockNames.addAll(stoneVariants);
                    blockNames.addAll(dirtVariants);
                    blockNames.addAll(otherVariants);
                    break;
                }
                case "dirtandgravel": {
                    blockNames.add(STONE_ID);
                    blockNames.addAll(dirtVariants);
                    blockNames.addAll(otherVariants);
                    break;
                }
                case "classic": {
                    blockNames.addAll(OreSpawnWorldGen.getSpawnBlocks().stream().map(block -> block.getRegistryName().toString()).collect(Collectors.toList()));
                    break;
                }
                default: {
                    blockNames.addAll(baseStones);
                    break;
                }
            }
        } else {
            blockNames.addAll(baseStones);
        }
    }

    public int compareTo(ICommand command) {
        return this.func_71517_b().compareTo(command.func_71517_b());
    }
}

