/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn.data;

import com.mcmoddev.orespawn.util.StateUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;

public class ReplacementsRegistry {
    private static Map<String, IBlockState> blocks = new HashMap<String, IBlockState>();

    private ReplacementsRegistry() {
    }

    public static List<IBlockState> getDimensionDefault(int dimension) {
        String[] names = new String[]{"minecraft:netherrack", "minecraft:stone", "minecraft:end_stone"};
        if (dimension < -1 || dimension > 1 || dimension == 0) {
            ArrayList<IBlockState> rv = new ArrayList<IBlockState>();
            for (ItemStack iS : OreDictionary.getOres((String)"stone")) {
                rv.add(Block.func_149634_a((Item)iS.func_77973_b()).func_176203_a(iS.func_77960_j()));
            }
            return rv;
        }
        return Arrays.asList(((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(names[dimension + 1]))).func_176223_P());
    }

    public static IBlockState getBlock(String name) {
        return blocks.get(name);
    }

    public static void addBlock(String name, String blockName, String blockState) {
        Block nb = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockName));
        blocks.put(name, "default".equals(blockState) ? nb.func_176223_P() : StateUtil.deserializeState(nb, blockState));
    }

    public static Map<String, IBlockState> getBlocks() {
        return Collections.unmodifiableMap(blocks);
    }

    public static void addBlock(String name, IBlockState state) {
        blocks.put(name, state);
    }
}

