/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn.impl.features;

import com.google.gson.JsonObject;
import com.mcmoddev.orespawn.OreSpawn;
import com.mcmoddev.orespawn.api.BiomeLocation;
import com.mcmoddev.orespawn.api.FeatureBase;
import com.mcmoddev.orespawn.api.GeneratorParameters;
import com.mcmoddev.orespawn.api.IFeature;
import com.mcmoddev.orespawn.util.OreList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;

public class ClusterGenerator
extends FeatureBase
implements IFeature {
    private ClusterGenerator(Random rand) {
        super(rand);
    }

    public ClusterGenerator() {
        this(new Random());
    }

    @Override
    public void generate(World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider, GeneratorParameters parameters) {
        ChunkPos pos = parameters.getChunk();
        LinkedList<IBlockState> blockReplace = new LinkedList<IBlockState>();
        blockReplace.addAll((Collection<IBlockState>)parameters.getReplacements());
        JsonObject params = parameters.getParameters();
        OreList ores = parameters.getOres();
        BiomeLocation biomes = parameters.getBiomes();
        int chunkX = pos.field_77276_a;
        int chunkZ = pos.field_77275_b;
        ClusterGenerator.mergeDefaults(params, this.getDefaultParameters());
        this.runCache(chunkX, chunkZ, world, blockReplace);
        int blockX = chunkX * 16 + 8;
        int blockZ = chunkZ * 16 + 8;
        int maxSpread = params.get("maxSpread").getAsInt();
        int minHeight = params.get("minHeight").getAsInt();
        int maxHeight = params.get("maxHeight").getAsInt();
        int variance = params.get("variation").getAsInt();
        int frequency = params.get("frequency").getAsInt();
        int triesMin = params.get("minAttempts").getAsInt();
        int triesMax = params.get("maxAttempts").getAsInt();
        int clusterSize = params.get("size").getAsInt();
        int clusterCount = params.get("numObjects").getAsInt();
        for (int tries = triesMax == triesMin ? triesMax : this.random.nextInt(triesMax - triesMin) + triesMin; tries > 0; --tries) {
            if (this.random.nextInt(100) > frequency) continue;
            int xRand = this.random.nextInt(16);
            int zRand = this.random.nextInt(16);
            int x = blockX + xRand - maxSpread / 2;
            int y = this.random.nextInt(maxHeight - minHeight) + minHeight;
            int z = blockZ + zRand - maxSpread / 2;
            FeatureBase.FunctionParameterWrapper fp = new FeatureBase.FunctionParameterWrapper();
            fp.setBlockPos(new BlockPos(x, y, z));
            fp.setWorld(world);
            fp.setReplacements(blockReplace);
            fp.setBiomes(biomes);
            fp.setOres(ores);
            this.spawnCluster(clusterSize, variance, clusterCount, maxSpread, minHeight, maxHeight, fp);
        }
    }

    private void spawnCluster(int clusterSize, int variance, int clusterCount, int maxSpread, int minHeight, int maxHeight, FeatureBase.FunctionParameterWrapper params) {
        int r = clusterSize - variance;
        if (variance > 0) {
            r += this.random.nextInt(2 * variance) - variance;
        }
        this.spawnChunk(params, r);
        int count = this.random.nextInt(clusterCount - 1);
        if (variance > 0) {
            count += this.random.nextInt(2 * variance) - variance;
        }
        while (count >= 0) {
            r = clusterSize - variance;
            if (variance > 0) {
                r += this.random.nextInt(2 * variance) - variance;
            }
            int radius = maxSpread / 2;
            int xp = this.getPoint(-radius, radius, 0);
            int yp = this.getPoint(minHeight, maxHeight, (maxHeight - minHeight) / 2);
            int zp = this.getPoint(-radius, radius, 0);
            BlockPos p = params.getBlockPos().func_177982_a(xp, yp, zp);
            FeatureBase.FunctionParameterWrapper np = new FeatureBase.FunctionParameterWrapper(params);
            np.setBlockPos(p);
            this.spawnChunk(np, r);
            count -= r;
        }
    }

    private void spawnChunk(FeatureBase.FunctionParameterWrapper params, int quantity) {
        int count = quantity;
        int lutType = quantity < 8 ? offsetIndexRef_small.length : offsetIndexRef.length;
        int[] lut = quantity < 8 ? offsetIndexRef_small : offsetIndexRef;
        Vec3i[] offs = new Vec3i[lutType];
        System.arraycopy(quantity < 8 ? offsets_small : offsets, 0, offs, 0, lutType);
        int dimension = params.getWorld().field_73011_w.getDimension();
        if (quantity < 27) {
            int[] scrambledLUT = new int[lutType];
            System.arraycopy(lut, 0, scrambledLUT, 0, scrambledLUT.length);
            this.scramble(scrambledLUT, this.random);
            int z = 0;
            while (count > 0) {
                IBlockState oreBlock = params.getOres().getRandomOre(this.random).getOre();
                if (!this.spawn(oreBlock, params.getWorld(), params.getBlockPos().func_177971_a(offs[scrambledLUT[--count]]), dimension, true, params.getReplacements(), params.getBiomes())) {
                    ++count;
                    ++z;
                } else {
                    z = 0;
                }
                if (z <= 5) continue;
                --count;
                z = 0;
                OreSpawn.LOGGER.warn("Unable to place block for chunk after 5 tries");
            }
            return;
        }
        this.doSpawnFill(this.random.nextBoolean(), count, params);
    }

    private void doSpawnFill(boolean nextBoolean, int quantity, FeatureBase.FunctionParameterWrapper params) {
        int count = quantity;
        double radius = Math.pow(quantity, 0.3333333333333333) * 0.238732414637843 + 2.0;
        int rSqr = (int)(radius * radius);
        if (nextBoolean) {
            this.spawnMungeNE(params.getWorld(), params.getBlockPos(), rSqr, radius, params.getReplacements(), count, params.getOres());
        } else {
            this.spawnMungeSW(params.getWorld(), params.getBlockPos(), rSqr, radius, params.getReplacements(), count, params.getOres());
        }
    }

    @Override
    public void setRandom(Random rand) {
        this.random = rand;
    }

    @Override
    public JsonObject getDefaultParameters() {
        JsonObject defParams = new JsonObject();
        defParams.addProperty("maxSpread", (Number)16);
        defParams.addProperty("size", (Number)8);
        defParams.addProperty("numObjects", (Number)8);
        defParams.addProperty("minHeight", (Number)8);
        defParams.addProperty("maxHeight", (Number)24);
        defParams.addProperty("variation", (Number)4);
        defParams.addProperty("frequency", (Number)25);
        defParams.addProperty("minAttempts", (Number)4);
        defParams.addProperty("maxAttempts", (Number)8);
        return defParams;
    }
}

