/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn.impl.features;

import com.google.gson.JsonObject;
import com.mcmoddev.orespawn.api.BiomeLocation;
import com.mcmoddev.orespawn.api.FeatureBase;
import com.mcmoddev.orespawn.api.GeneratorParameters;
import com.mcmoddev.orespawn.api.IFeature;
import com.mcmoddev.orespawn.util.OreList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;

public class DefaultFeatureGenerator
extends FeatureBase
implements IFeature {
    public DefaultFeatureGenerator() {
        super(new Random());
    }

    @Override
    public void generate(World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider, GeneratorParameters parameters) {
        ChunkPos pos = parameters.getChunk();
        LinkedList<IBlockState> replaceBlock = new LinkedList<IBlockState>();
        replaceBlock.addAll((Collection<IBlockState>)parameters.getReplacements());
        JsonObject params = parameters.getParameters();
        OreList ores = parameters.getOres();
        BiomeLocation biomes = parameters.getBiomes();
        int chunkX = pos.field_77276_a;
        int chunkZ = pos.field_77275_b;
        DefaultFeatureGenerator.mergeDefaults(params, this.getDefaultParameters());
        this.runCache(chunkX, chunkZ, world, replaceBlock);
        int blockX = chunkX * 16 + 8;
        int blockZ = chunkZ * 16 + 8;
        int minY = params.get("minHeight").getAsInt();
        int maxY = params.get("maxHeight").getAsInt();
        int vari = params.get("variation").getAsInt();
        float freq = params.get("frequency").getAsFloat();
        int size = params.get("size").getAsInt();
        FeatureBase.FunctionParameterWrapper fp = new FeatureBase.FunctionParameterWrapper();
        fp.setWorld(world);
        fp.setReplacements(replaceBlock);
        fp.setBiomes(biomes);
        fp.setOres(ores);
        if (freq >= 1.0f) {
            int i = 0;
            while ((float)i < freq) {
                int x = blockX + this.random.nextInt(16);
                int y = this.random.nextInt(maxY - minY) + minY;
                int z = blockZ + this.random.nextInt(16);
                int r = vari > 0 ? this.random.nextInt(2 * vari) - vari : 0;
                fp.setBlockPos(new BlockPos(x, y, z));
                this.spawnOre(fp, size + r);
                ++i;
            }
        } else if (this.random.nextFloat() < freq) {
            int x = blockX + this.random.nextInt(8);
            int y = this.random.nextInt(maxY - minY) + minY;
            int z = blockZ + this.random.nextInt(8);
            int r = vari > 0 ? this.random.nextInt(2 * vari) - vari : 0;
            fp.setBlockPos(new BlockPos(x, y, z));
            this.spawnOre(fp, size + r);
        }
    }

    private void spawnOre(FeatureBase.FunctionParameterWrapper params, int quantity) {
        int count = quantity;
        int lutType = quantity < 8 ? offsetIndexRef_small.length : offsetIndexRef.length;
        int[] lut = quantity < 8 ? offsetIndexRef_small : offsetIndexRef;
        Vec3i[] offs = new Vec3i[lutType];
        System.arraycopy(quantity < 8 ? offsets_small : offsets, 0, offs, 0, lutType);
        if (quantity < 27) {
            int[] scrambledLUT = new int[lutType];
            System.arraycopy(lut, 0, scrambledLUT, 0, scrambledLUT.length);
            this.scramble(scrambledLUT, this.random);
            while (count > 0) {
                IBlockState oreBlock = params.getOres().getRandomOre(this.random).getOre();
                BlockPos target = params.getBlockPos().func_177971_a(offs[scrambledLUT[--count]]);
                this.spawn(oreBlock, params.getWorld(), target, params.getWorld().field_73011_w.getDimension(), true, params.getReplacements(), params.getBiomes());
            }
            return;
        }
        this.doSpawnFill(this.random.nextBoolean(), count, params);
    }

    private void doSpawnFill(boolean nextBoolean, int quantity, FeatureBase.FunctionParameterWrapper params) {
        int count = quantity;
        double radius = Math.pow(quantity, 0.3333333333333333) * 0.238732414637843 + 2.0;
        int rSqr = (int)(radius * radius);
        if (nextBoolean) {
            this.spawnMungeNE(params.getWorld(), params.getBlockPos(), rSqr, radius, params.getReplacements(), count, params.getOres());
        } else {
            this.spawnMungeSW(params.getWorld(), params.getBlockPos(), rSqr, radius, params.getReplacements(), count, params.getOres());
        }
    }

    @Override
    public JsonObject getDefaultParameters() {
        JsonObject defParams = new JsonObject();
        defParams.addProperty("minHeight", (Number)0);
        defParams.addProperty("maxHeight", (Number)256);
        defParams.addProperty("variation", (Number)16);
        defParams.addProperty("frequency", (Number)0.5);
        defParams.addProperty("size", (Number)8);
        return defParams;
    }

    @Override
    public void setRandom(Random rand) {
        this.random = rand;
    }
}

