/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn.impl.features;

import com.google.gson.JsonObject;
import com.mcmoddev.orespawn.OreSpawn;
import com.mcmoddev.orespawn.api.BiomeLocation;
import com.mcmoddev.orespawn.api.FeatureBase;
import com.mcmoddev.orespawn.api.GeneratorParameters;
import com.mcmoddev.orespawn.api.IFeature;
import com.mcmoddev.orespawn.util.OreList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;

public class PrecisionGenerator
extends FeatureBase
implements IFeature {
    private PrecisionGenerator(Random rand) {
        super(rand);
    }

    public PrecisionGenerator() {
        this(new Random());
    }

    @Override
    public void generate(World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider, GeneratorParameters parameters) {
        int nodeSize;
        ChunkPos pos = parameters.getChunk();
        LinkedList<IBlockState> blockReplace = new LinkedList<IBlockState>();
        blockReplace.addAll((Collection<IBlockState>)parameters.getReplacements());
        JsonObject params = parameters.getParameters();
        OreList ores = parameters.getOres();
        BiomeLocation biomes = parameters.getBiomes();
        int chunkX = pos.field_77276_a;
        int chunkZ = pos.field_77275_b;
        PrecisionGenerator.mergeDefaults(params, this.getDefaultParameters());
        this.runCache(chunkX, chunkZ, world, blockReplace);
        int nodeCount = params.get("numObjects").getAsInt();
        int maxHeight = params.get("maxHeight").getAsInt();
        int minHeight = params.get("minHeight").getAsInt();
        int thisNode = nodeSize = params.get("size").getAsInt();
        for (int c = nodeCount; c > 0; --c) {
            HeightRange hr = new HeightRange(minHeight, maxHeight);
            BlockPos spot = this.chooseSpot(chunkX, chunkZ, hr);
            FeatureBase.FunctionParameterWrapper fp = new FeatureBase.FunctionParameterWrapper();
            fp.setBlockPos(spot);
            fp.setWorld(world);
            fp.setReplacements(blockReplace);
            fp.setBiomes(biomes);
            fp.setOres(ores);
            fp.setChunkPos(new ChunkPos(chunkX, chunkZ));
            int sc = this.spawnAtSpot(thisNode, hr, fp);
            if (sc != thisNode && sc != 0) {
                OreSpawn.LOGGER.debug("node at %s of size %d instead of %d - modding to %d", (Object)spot, (Object)sc, (Object)nodeSize, (Object)(thisNode += nodeSize - sc));
            } else if (sc == thisNode) {
                thisNode = nodeSize;
            }
            if (thisNode > 0) continue;
            thisNode = nodeSize;
        }
    }

    private int spawnAtSpot(int nodeSize, HeightRange heightRange, FeatureBase.FunctionParameterWrapper params) {
        int c;
        int spawned = 0;
        FeatureBase.FunctionParameterWrapper np = new FeatureBase.FunctionParameterWrapper(params);
        BlockPos act = params.getBlockPos();
        for (int counter = nodeSize; counter > 0 && spawned < nodeSize; counter -= c + 1, spawned += c) {
            np.setBlockPos(act);
            c = this.spawnOreNode(np, nodeSize, heightRange);
            if (c != 0) continue;
            OreSpawn.LOGGER.debug("Unable to place block at %s (chunk %s)", (Object)np.getBlockPos(), (Object)np.getChunkPos());
            act = this.chooseSpot(Math.floorDiv(params.getBlockPos().func_177958_n(), 16), Math.floorDiv(params.getBlockPos().func_177952_p(), 16), heightRange);
        }
        return spawned;
    }

    private int spawnOreNode(FeatureBase.FunctionParameterWrapper params, int nodeSize, HeightRange heightRange) {
        int lutType = nodeSize < 8 ? offsetIndexRef_small.length : offsetIndexRef.length;
        int[] lut = nodeSize < 8 ? offsetIndexRef_small : offsetIndexRef;
        Vec3i[] offs = new Vec3i[lutType];
        System.arraycopy(nodeSize < 8 ? offsets_small : offsets, 0, offs, 0, lutType);
        if (nodeSize < 27) {
            int[] scrambledLUT = new int[lutType];
            System.arraycopy(lut, 0, scrambledLUT, 0, scrambledLUT.length);
            this.scramble(scrambledLUT, this.random);
            int nc = 0;
            for (int count = nodeSize; count > 0 && nc <= nodeSize; --count) {
                IBlockState oreBlock = params.getOres().getRandomOre(this.random).getOre();
                Vec3i offset = offs[scrambledLUT[--count]];
                BlockPos p = this.fixMungeOffset(offset, params.getBlockPos(), heightRange, params.getChunkPos());
                int dimension = params.getWorld().field_73011_w.getDimension();
                if (!this.spawn(oreBlock, params.getWorld(), p, dimension, true, params.getReplacements(), params.getBiomes())) continue;
                ++nc;
            }
            return nc;
        }
        return this.spawnFill(params, nodeSize, heightRange);
    }

    private BlockPos fixMungeOffset(Vec3i offset, BlockPos spot, HeightRange heightRange, ChunkPos pos) {
        BlockPos p = spot.func_177971_a(offset);
        ChunkPos x1z1 = new ChunkPos(pos.field_77276_a + 1, pos.field_77275_b + 1);
        int xMax = x1z1.func_180332_e();
        int zMax = x1z1.func_180330_f();
        int xMin = pos.func_180334_c();
        int zMin = pos.func_180333_d();
        int xmod = offset.func_177958_n();
        int ymod = offset.func_177956_o();
        int zmod = offset.func_177952_p();
        if (p.func_177956_o() < heightRange.getMin() || p.func_177956_o() > heightRange.getMax()) {
            ymod = this.rescaleOffset(ymod, spot.func_177956_o(), heightRange.getMin(), heightRange.getMax());
        }
        if (p.func_177958_n() < xMin || p.func_177958_n() > xMax) {
            xmod = this.rescaleOffset(xmod, spot.func_177958_n(), xMin, xMax);
        }
        if (p.func_177952_p() < zMin || p.func_177952_p() > zMax) {
            zmod = this.rescaleOffset(zmod, spot.func_177952_p(), zMin, zMax);
        }
        BlockPos rVal = spot.func_177982_a(xmod, ymod, zmod);
        OreSpawn.LOGGER.debug("rescaled %s to %s", (Object)spot, (Object)rVal);
        return rVal;
    }

    private int rescaleOffset(int offsetIn, int centerIn, int minimumIn, int maximumIn) {
        int actual = centerIn + offsetIn;
        int range = maximumIn - minimumIn;
        int wrapDistance = actual < minimumIn ? minimumIn - actual : actual - maximumIn;
        wrapDistance = wrapDistance < 0 ? -1 * wrapDistance % range : (wrapDistance %= range);
        int workingPoint = actual < minimumIn ? maximumIn - wrapDistance : minimumIn + wrapDistance;
        return workingPoint - centerIn;
    }

    private int spawnFill(FeatureBase.FunctionParameterWrapper params, int nodeSize, HeightRange heightRange) {
        double radius = Math.pow(nodeSize, 0.3333333333333333) * 0.238732414637843 + 2.0;
        int rSqr = (int)Math.ceil(radius * radius);
        if (this.random.nextBoolean()) {
            return this.spawnPrecise(params, heightRange, false, radius, rSqr, nodeSize);
        }
        return this.spawnPrecise(params, heightRange, true, radius, rSqr, nodeSize);
    }

    private int spawnPrecise(FeatureBase.FunctionParameterWrapper params, HeightRange heightRange, boolean toPositive, double radius, int rSqr, int nodeSize) {
        int quantity = nodeSize;
        int nc = 0;
        int dy = (int)(-1.0 * radius);
        while ((double)dy < radius) {
            int dx = this.getStart(toPositive, radius);
            while (this.endCheck(toPositive, dx, radius)) {
                int dz = this.getStart(toPositive, radius);
                while (this.endCheck(toPositive, dz, radius)) {
                    if (this.doCheckSpawn(dx, dy, dz, rSqr, heightRange, params) >= 0 && (++nc >= nodeSize || --quantity <= 0)) {
                        return nc;
                    }
                    dz = this.countItem(dz, toPositive);
                }
                dx = this.countItem(dx, toPositive);
            }
            ++dy;
        }
        return nc;
    }

    private int doCheckSpawn(int dx, int dy, int dz, int rSqr, HeightRange heightRange, FeatureBase.FunctionParameterWrapper params) {
        if (this.getABC(dx, dy, dz) <= rSqr) {
            BlockPos p = this.fixMungeOffset(new Vec3i(dx, dy, dz), params.getBlockPos(), heightRange, params.getChunkPos());
            IBlockState bl = params.getOres().getRandomOre(this.random).getOre();
            return this.spawn(bl, params.getWorld(), p, params.getWorld().field_73011_w.getDimension(), true, params.getReplacements(), params.getBiomes()) ? 1 : 0;
        }
        return -1;
    }

    private int getPoint(int lowerBound, int upperBound) {
        ArrayList<Integer> arr = new ArrayList<Integer>();
        for (int i = lowerBound; i <= upperBound; ++i) {
            arr.add(i);
        }
        return (Integer)arr.get(this.random.nextInt(arr.size()));
    }

    private BlockPos chooseSpot(int xPosition, int zPosition, HeightRange heightRange) {
        int xRet = this.getPoint(0, 15) + xPosition * 16;
        int zRet = this.getPoint(0, 15) + zPosition * 16;
        int yRet = this.getPoint(heightRange.getMin(), heightRange.getMax());
        return new BlockPos(xRet, yRet, zRet);
    }

    @Override
    public void setRandom(Random rand) {
        this.random = rand;
    }

    @Override
    public JsonObject getDefaultParameters() {
        JsonObject defaults = new JsonObject();
        defaults.addProperty("numObjects", (Number)4);
        defaults.addProperty("minHeight", (Number)16);
        defaults.addProperty("maxHeight", (Number)80);
        defaults.addProperty("size", (Number)8);
        return defaults;
    }

    private class HeightRange {
        private int min;
        private int max;

        HeightRange(int min, int max) {
            this.min = min;
            this.max = max;
        }

        int getMin() {
            return this.min;
        }

        int getMax() {
            return this.max;
        }
    }
}

