/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn.impl.features;

import com.google.gson.JsonObject;
import com.mcmoddev.orespawn.api.BiomeLocation;
import com.mcmoddev.orespawn.api.FeatureBase;
import com.mcmoddev.orespawn.api.GeneratorParameters;
import com.mcmoddev.orespawn.api.IFeature;
import com.mcmoddev.orespawn.util.OreList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;

public class VeinGenerator
extends FeatureBase
implements IFeature {
    private float[][] rowMap = new float[][]{{0.5f, 0.75f, 0.5f}, {0.5f, 1.0f, 0.5f}, {0.5f, 0.75f, 0.5f}};
    private float[] colMap = new float[]{0.75f, 1.0f, 0.75f};
    private int[][][][] facePosMap = new int[][][][]{new int[][][]{new int[][]{{-1, 1, 1}, {0, 1, 1}, {1, 1, 1}}, new int[][]{{-1, 1, 0}, {0, 1, 0}, {1, 0, 1}}, new int[][]{{-1, 1, -1}, {0, 1, -1}, {1, 1, -1}}}, new int[][][]{new int[][]{{-1, 1, 1}, {0, 1, 1}, {1, 1, 1}}, new int[][]{{-1, 0, 1}, {0, 0, 1}, {1, 0, 1}}, new int[][]{{-1, -1, 1}, {0, -1, 1}, {1, -1, 1}}}, new int[][][]{new int[][]{{-1, -1, 1}, {0, -1, 1}, {1, -1, 1}}, new int[][]{{-1, -1, 0}, {0, -1, 0}, {1, -1, 0}}, new int[][]{{-1, -1, -1}, {0, -1, -1}, {1, -1, -1}}}, new int[][][]{new int[][]{{-1, 1, -1}, {0, 1, -1}, {1, 1, -1}}, new int[][]{{-1, 0, -1}, {0, -1, 0}, {1, 0, -1}}, new int[][]{{-1, -1, -1}, {0, -1, -1}, {1, -1, -1}}}, new int[][][]{new int[][]{{1, 1, 1}, {1, 1, 0}, {1, 1, -1}}, new int[][]{{1, 0, 1}, {1, 0, 0}, {1, 0, -1}}, new int[][]{{1, -1, 1}, {1, -1, 0}, {1, -1, -1}}}, new int[][][]{new int[][]{{-1, 1, 1}, {-1, 1, 0}, {-1, 1, -1}}, new int[][]{{-1, 0, 1}, {-1, 0, 0}, {-1, 0, -1}}, new int[][]{{-1, -1, 1}, {-1, -1, 0}, {-1, -1, -1}}}};

    private VeinGenerator(Random rand) {
        super(rand);
    }

    public VeinGenerator() {
        this(new Random());
    }

    @Override
    public void generate(World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider, GeneratorParameters parameters) {
        ChunkPos pos = parameters.getChunk();
        LinkedList<IBlockState> blockReplace = new LinkedList<IBlockState>();
        blockReplace.addAll((Collection<IBlockState>)parameters.getReplacements());
        JsonObject params = parameters.getParameters();
        OreList ores = parameters.getOres();
        BiomeLocation biomes = parameters.getBiomes();
        int chunkX = pos.field_77276_a;
        int chunkZ = pos.field_77275_b;
        this.runCache(chunkX, chunkZ, world, blockReplace);
        VeinGenerator.mergeDefaults(params, this.getDefaultParameters());
        int blockX = chunkX * 16 + 8;
        int blockZ = chunkZ * 16 + 8;
        int minY = params.get("minHeight").getAsInt();
        int maxY = params.get("maxHeight").getAsInt();
        int vari = params.get("variation").getAsInt();
        int freq = params.get("frequency").getAsInt();
        int length = params.get("length").getAsInt();
        int wander = params.get("wander").getAsInt();
        int nodeSize = params.get("size").getAsInt();
        int triesMin = params.get("minAttempts").getAsInt();
        int triesMax = params.get("maxAttempts").getAsInt();
        for (int tries = triesMax == triesMin ? triesMax : this.random.nextInt(triesMax - triesMin) + triesMin; tries > 0; --tries) {
            if (this.random.nextInt(100) > freq) continue;
            int x = blockX + this.random.nextInt(16);
            int y = this.random.nextInt(maxY - minY) + minY;
            int z = blockZ + this.random.nextInt(16);
            int r = vari > 0 ? this.random.nextInt(2 * vari) - vari : 0;
            FeatureBase.FunctionParameterWrapper fp = new FeatureBase.FunctionParameterWrapper();
            fp.setBlockPos(new BlockPos(x, y, z));
            fp.setWorld(world);
            fp.setReplacements(blockReplace);
            fp.setBiomes(biomes);
            fp.setOres(ores);
            this.spawnVein(length + r, nodeSize, wander, fp);
        }
    }

    private int triangularDistributionNoRandom(double current) {
        if (current < 0.5) {
            return (int)Math.sqrt(current * 2.0);
        }
        return (int)(2.0 - Math.sqrt((1.0 - current) * 2.0));
    }

    private BlockPos adjustPos(BlockPos pos, int row, int col, EnumFace face) {
        int faceOrd = face.ordinal();
        int[] adjust = this.facePosMap[faceOrd][row][col];
        return pos.func_177982_a(adjust[0], adjust[1], adjust[2]);
    }

    private void spawnVein(int length, int nodeSize, int wander, FeatureBase.FunctionParameterWrapper params) {
        this.spawnOre(params, nodeSize);
        float curRow = 1.0f;
        float curCol = 1.0f;
        int colAdj = 2;
        int rowAdj = 2;
        EnumFace faceToUse = EnumFace.getRandomFace(this.random);
        int l = length;
        BlockPos workPos = new BlockPos((Vec3i)params.getBlockPos());
        while (l > 0) {
            workPos = this.adjustPos(workPos, colAdj, rowAdj, faceToUse);
            --l;
            if (this.random.nextInt(100) > wander) continue;
            colAdj = this.triangularDistributionNoRandom(curCol);
            curCol += this.colMap[colAdj];
            while (curCol > 1.0f) {
                curCol /= 10.0f;
            }
            rowAdj = this.triangularDistributionNoRandom(curCol);
            curRow += this.rowMap[colAdj][rowAdj];
            while (curRow > 1.0f) {
                curRow /= 10.0f;
            }
            FeatureBase.FunctionParameterWrapper np = new FeatureBase.FunctionParameterWrapper(params);
            np.setBlockPos(workPos);
            this.spawnOre(np, nodeSize);
            if (nodeSize <= 2) continue;
            faceToUse = EnumFace.getRandomFace(this.random);
        }
    }

    private void spawnOre(FeatureBase.FunctionParameterWrapper params, int nodeSize) {
        int count = nodeSize;
        int lutType = count < 8 ? offsetIndexRef_small.length : offsetIndexRef.length;
        int[] lut = count < 8 ? offsetIndexRef_small : offsetIndexRef;
        Vec3i[] offs = new Vec3i[lutType];
        System.arraycopy(count < 8 ? offsets_small : offsets, 0, offs, 0, lutType);
        int[] scrambledLUT = new int[lutType];
        System.arraycopy(lut, 0, scrambledLUT, 0, scrambledLUT.length);
        this.scramble(scrambledLUT, this.random);
        int dimension = params.getWorld().field_73011_w.getDimension();
        while (count > 0) {
            this.spawn(params.getOres().getRandomOre(this.random).getOre(), params.getWorld(), params.getBlockPos().func_177971_a(offs[scrambledLUT[--count]]), dimension, true, params.getReplacements(), params.getBiomes());
        }
    }

    @Override
    public JsonObject getDefaultParameters() {
        JsonObject defParams = new JsonObject();
        defParams.addProperty("minHeight", (Number)0);
        defParams.addProperty("maxHeight", (Number)256);
        defParams.addProperty("variation", (Number)16);
        defParams.addProperty("frequency", (Number)50);
        defParams.addProperty("maxAttempts", (Number)8);
        defParams.addProperty("minAttempts", (Number)4);
        defParams.addProperty("length", (Number)16);
        defParams.addProperty("wander", (Number)75);
        defParams.addProperty("size", (Number)3);
        return defParams;
    }

    @Override
    public void setRandom(Random rand) {
        this.random = rand;
    }

    private static enum EnumFace {
        UP,
        FRONT,
        DOWN,
        BACK,
        LEFT,
        RIGHT;


        public static EnumFace getRandomFace(Random random) {
            return EnumFace.values()[random.nextInt(EnumFace.values().length)];
        }
    }
}

