/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn.impl.os3;

import com.google.common.collect.ImmutableSet;
import com.mcmoddev.orespawn.api.BiomeLocation;
import com.mcmoddev.orespawn.api.os3.BiomeBuilder;
import com.mcmoddev.orespawn.impl.location.BiomeLocationComposition;
import com.mcmoddev.orespawn.impl.location.BiomeLocationDictionary;
import com.mcmoddev.orespawn.impl.location.BiomeLocationList;
import com.mcmoddev.orespawn.impl.location.BiomeLocationSingle;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class BiomeBuilderImpl
implements BiomeBuilder {
    private List<BiomeLocation> biomeWhitelist = new ArrayList<BiomeLocation>();
    private List<BiomeLocation> biomeBlacklist = new ArrayList<BiomeLocation>();
    private BiomeLocation loc;

    BiomeBuilderImpl() {
    }

    private Biome getBiomeByName(String name) {
        return (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(name));
    }

    private BiomeDictionary.Type getBiomeDictionaryType(String name) {
        return BiomeDictionary.Type.getType((String)name, (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);
    }

    @Override
    public BiomeBuilder whitelistBiome(@Nonnull Biome biome) {
        this.biomeWhitelist.add(new BiomeLocationSingle(biome));
        return this;
    }

    @Override
    public BiomeBuilder whitelistBiomeByName(@Nonnull String biomeName) {
        Biome b = this.getBiomeByName(biomeName);
        BiomeLocationSingle bL = new BiomeLocationSingle(b);
        if (!this.biomeWhitelist.contains(bL)) {
            this.biomeWhitelist.add(bL);
        }
        return this;
    }

    @Override
    public BiomeBuilder whitelistBiomeByDictionary(@Nonnull String biomeDictionaryName) {
        this.biomeWhitelist.add(new BiomeLocationDictionary(this.getBiomeDictionaryType(biomeDictionaryName)));
        return this;
    }

    @Override
    public BiomeBuilder blacklistBiome(@Nonnull Biome biome) {
        this.biomeBlacklist.add(new BiomeLocationSingle(biome));
        return this;
    }

    @Override
    public BiomeBuilder blacklistBiomeByName(@Nonnull String biomeName) {
        this.biomeBlacklist.add(new BiomeLocationSingle(this.getBiomeByName(biomeName)));
        return this;
    }

    @Override
    public BiomeBuilder blacklistBiomeByDictionary(@Nonnull String biomeDictionaryName) {
        this.biomeBlacklist.add(new BiomeLocationDictionary(this.getBiomeDictionaryType(biomeDictionaryName)));
        return this;
    }

    @Override
    public BiomeLocation getBiomes() {
        if (this.loc != null) {
            return this.loc;
        }
        this.loc = !this.biomeBlacklist.isEmpty() ? new BiomeLocationComposition((ImmutableSet<BiomeLocation>)ImmutableSet.copyOf(this.biomeWhitelist), (ImmutableSet<BiomeLocation>)ImmutableSet.copyOf(this.biomeBlacklist)) : (this.biomeWhitelist.size() == 1 ? this.biomeWhitelist.toArray(new BiomeLocation[0])[0] : new BiomeLocationList((ImmutableSet<BiomeLocation>)ImmutableSet.copyOf(this.biomeWhitelist)));
        return this.loc;
    }

    @Override
    public BiomeBuilder setFromBiomeLocation(@Nonnull BiomeLocation biomes) {
        this.loc = biomes;
        return this;
    }
}

