/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn.impl.os3;

import com.google.common.collect.ImmutableMap;
import com.mcmoddev.orespawn.OreSpawn;
import com.mcmoddev.orespawn.api.os3.BuilderLogic;
import com.mcmoddev.orespawn.api.os3.DimensionBuilder;
import com.mcmoddev.orespawn.impl.os3.DimensionBuilderImpl;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class BuilderLogicImpl
implements BuilderLogic {
    private final Map<Integer, DimensionBuilder> dimensions = new HashMap<Integer, DimensionBuilder>();

    @Override
    public DimensionBuilder newDimensionBuilder(String name) {
        int id = this.dimensionNameToId(name);
        if (id == OreSpawn.API.dimensionWildcard()) {
            return this.newDimensionBuilder();
        }
        return this.newDimensionBuilder(id);
    }

    @Override
    public DimensionBuilder newDimensionBuilder(int id) {
        if (this.dimensions.containsKey(id)) {
            return this.getDimension(id);
        }
        DimensionBuilderImpl db = new DimensionBuilderImpl();
        this.dimensions.put(id, db);
        return db;
    }

    @Override
    public DimensionBuilder newDimensionBuilder() {
        return this.newDimensionBuilder(OreSpawn.API.dimensionWildcard());
    }

    @Override
    public BuilderLogic create(DimensionBuilder ... dimensions) {
        return this;
    }

    @Override
    public DimensionBuilder getDimension(String name) {
        Integer id = this.dimensionNameToId(name);
        return this.getDimension(id);
    }

    @Override
    public DimensionBuilder getDimension(int id) {
        if (this.dimensions.containsKey(id)) {
            return this.dimensions.get(id);
        }
        return null;
    }

    @Override
    public ImmutableMap<Integer, DimensionBuilder> getAllDimensions() {
        return ImmutableMap.copyOf(this.dimensions);
    }

    private int dimensionNameToId(String name) {
        switch (name.toLowerCase(Locale.ROOT)) {
            case "overworld": 
            case "the overworld": {
                return 0;
            }
            case "nether": 
            case "the nether": {
                return -1;
            }
            case "end": 
            case "the end": {
                return 1;
            }
        }
        return OreSpawn.API.dimensionWildcard();
    }
}

